/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.generator.skeletons.core.layers;

import javax.swing.tree.MutableTreeNode;
import org.sklsft.generator.model.domain.Package;
import org.sklsft.generator.model.domain.Project;
import org.sklsft.generator.model.domain.business.Bean;
import org.sklsft.generator.skeletons.commands.interfaces.FileWriteCommand;
import org.sklsft.generator.skeletons.core.commands.dao.BaseDaoHibernateImplFileWriteCommand;
import org.sklsft.generator.skeletons.core.commands.dao.BaseDaoInterfaceFileWriteCommand;
import org.sklsft.generator.skeletons.core.commands.dao.DaoImplFileWriteCommand;
import org.sklsft.generator.skeletons.core.commands.dao.DaoInterfaceFileWriteCommand;
import org.sklsft.generator.skeletons.core.commands.dao.configuration.RepositoryPomFileWriteCommand;
import org.sklsft.generator.skeletons.core.commands.dao.configuration.SpringRepositoryFileWriteCommand;
import org.sklsft.generator.skeletons.layers.AbstractLayer;
import org.sklsft.generator.skeletons.tree.FileWriteCommandTreeNode;

public class HibernateDaoLayer
extends AbstractLayer {
    public HibernateDaoLayer() {
        super("Hibernate based daos");
    }

    public FileWriteCommandTreeNode getResourcesNode(Project project) {
        return null;
    }

    public FileWriteCommandTreeNode getConfigurationNode(Project project) {
        FileWriteCommandTreeNode configurationTreeNode = new FileWriteCommandTreeNode();
        FileWriteCommandTreeNode repositoryPomTreeNode = new FileWriteCommandTreeNode((FileWriteCommand)new RepositoryPomFileWriteCommand(project));
        configurationTreeNode.add((MutableTreeNode)repositoryPomTreeNode);
        FileWriteCommandTreeNode springRepositoryTreeNode = new FileWriteCommandTreeNode((FileWriteCommand)new SpringRepositoryFileWriteCommand(project));
        configurationTreeNode.add((MutableTreeNode)springRepositoryTreeNode);
        return configurationTreeNode;
    }

    public FileWriteCommandTreeNode getGenerationNode(Project project) {
        FileWriteCommandTreeNode beanTreeNode;
        FileWriteCommandTreeNode persistenceTreeNode = new FileWriteCommandTreeNode();
        FileWriteCommandTreeNode baseDAOTreeNode = new FileWriteCommandTreeNode("Base DAO");
        persistenceTreeNode.add((MutableTreeNode)baseDAOTreeNode);
        for (Package myPackage : project.model.packages) {
            Object bean2;
            FileWriteCommandTreeNode packageTreeNode = new FileWriteCommandTreeNode(myPackage.name);
            baseDAOTreeNode.add((MutableTreeNode)packageTreeNode);
            FileWriteCommandTreeNode interfacesTreeNode = new FileWriteCommandTreeNode("interfaces");
            packageTreeNode.add((MutableTreeNode)interfacesTreeNode);
            for (Object bean2 : myPackage.beans) {
                if (((Bean)bean2).isComponent) continue;
                FileWriteCommandTreeNode beanTreeNode2 = new FileWriteCommandTreeNode((FileWriteCommand)new BaseDaoInterfaceFileWriteCommand((Bean)bean2));
                interfacesTreeNode.add((MutableTreeNode)beanTreeNode2);
            }
            FileWriteCommandTreeNode implTreeNode = new FileWriteCommandTreeNode("impl");
            packageTreeNode.add((MutableTreeNode)implTreeNode);
            bean2 = myPackage.beans.iterator();
            while (bean2.hasNext()) {
                Bean bean3 = (Bean)bean2.next();
                if (bean3.isComponent) continue;
                beanTreeNode = new FileWriteCommandTreeNode((FileWriteCommand)new BaseDaoHibernateImplFileWriteCommand(bean3));
                implTreeNode.add((MutableTreeNode)beanTreeNode);
            }
        }
        FileWriteCommandTreeNode daoTreeNode = new FileWriteCommandTreeNode("DAO");
        persistenceTreeNode.add((MutableTreeNode)daoTreeNode);
        for (Package myPackage : project.model.packages) {
            FileWriteCommandTreeNode packageTreeNode = new FileWriteCommandTreeNode(myPackage.name);
            baseDAOTreeNode.add((MutableTreeNode)packageTreeNode);
            FileWriteCommandTreeNode interfacesTreeNode = new FileWriteCommandTreeNode("interfaces");
            packageTreeNode.add((MutableTreeNode)interfacesTreeNode);
            for (Bean bean3 : myPackage.beans) {
                if (bean3.isComponent) continue;
                beanTreeNode = new FileWriteCommandTreeNode((FileWriteCommand)new DaoInterfaceFileWriteCommand(bean3));
                interfacesTreeNode.add((MutableTreeNode)beanTreeNode);
            }
            FileWriteCommandTreeNode implTreeNode = new FileWriteCommandTreeNode("impl");
            packageTreeNode.add((MutableTreeNode)implTreeNode);
            for (Bean bean : myPackage.beans) {
                if (bean.isComponent) continue;
                FileWriteCommandTreeNode beanTreeNode3 = new FileWriteCommandTreeNode((FileWriteCommand)new DaoImplFileWriteCommand(bean));
                implTreeNode.add((MutableTreeNode)beanTreeNode3);
            }
        }
        return persistenceTreeNode;
    }
}

