/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.generator.skeletons.core.layers;

import javax.swing.tree.MutableTreeNode;
import org.sklsft.generator.model.domain.Package;
import org.sklsft.generator.model.domain.Project;
import org.sklsft.generator.model.domain.business.Bean;
import org.sklsft.generator.skeletons.commands.interfaces.FileWriteCommand;
import org.sklsft.generator.skeletons.core.commands.model.EntityBeanFileWriteCommand;
import org.sklsft.generator.skeletons.core.commands.model.configuration.BusinessModelPomFileWriteCommand;
import org.sklsft.generator.skeletons.core.commands.model.resources.AuditEntityFileWriteCommand;
import org.sklsft.generator.skeletons.core.commands.model.resources.AuditListenerFileWriteCommand;
import org.sklsft.generator.skeletons.layers.AbstractLayer;
import org.sklsft.generator.skeletons.tree.FileWriteCommandTreeNode;

public class HibernateBusinessModelLayer
extends AbstractLayer {
    public HibernateBusinessModelLayer() {
        super("Business Model / Hibernate mappings");
    }

    public FileWriteCommandTreeNode getResourcesNode(Project project) {
        FileWriteCommandTreeNode resourcesTreeNode = new FileWriteCommandTreeNode();
        if (project.audited) {
            FileWriteCommandTreeNode auditEntityTreeNode = new FileWriteCommandTreeNode((FileWriteCommand)new AuditEntityFileWriteCommand(project));
            resourcesTreeNode.add((MutableTreeNode)auditEntityTreeNode);
            FileWriteCommandTreeNode auditListenerTreeNode = new FileWriteCommandTreeNode((FileWriteCommand)new AuditListenerFileWriteCommand(project));
            resourcesTreeNode.add((MutableTreeNode)auditListenerTreeNode);
        }
        return resourcesTreeNode;
    }

    public FileWriteCommandTreeNode getConfigurationNode(Project project) {
        FileWriteCommandTreeNode configurationTreeNode = new FileWriteCommandTreeNode();
        FileWriteCommandTreeNode businessModelPomTreeNode = new FileWriteCommandTreeNode((FileWriteCommand)new BusinessModelPomFileWriteCommand(project));
        configurationTreeNode.add((MutableTreeNode)businessModelPomTreeNode);
        return configurationTreeNode;
    }

    public FileWriteCommandTreeNode getGenerationNode(Project project) {
        FileWriteCommandTreeNode businessModelTreeNode = new FileWriteCommandTreeNode();
        for (Package myPackage : project.model.packages) {
            FileWriteCommandTreeNode packageTreeNode = new FileWriteCommandTreeNode(myPackage.name);
            businessModelTreeNode.add((MutableTreeNode)packageTreeNode);
            FileWriteCommandTreeNode omTreeNode = new FileWriteCommandTreeNode("Entities");
            packageTreeNode.add((MutableTreeNode)omTreeNode);
            for (Bean bean : myPackage.beans) {
                FileWriteCommandTreeNode beanTreeNode = new FileWriteCommandTreeNode((FileWriteCommand)new EntityBeanFileWriteCommand(bean));
                omTreeNode.add((MutableTreeNode)beanTreeNode);
            }
        }
        return businessModelTreeNode;
    }
}

