/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.generator.skeletons.core.layers;

import javax.swing.tree.MutableTreeNode;
import org.sklsft.generator.model.domain.Package;
import org.sklsft.generator.model.domain.Project;
import org.sklsft.generator.model.domain.business.Bean;
import org.sklsft.generator.skeletons.commands.interfaces.FileWriteCommand;
import org.sklsft.generator.skeletons.core.commands.api.configuration.ApiPomFileWriteCommand;
import org.sklsft.generator.skeletons.core.commands.api.interfaces.BaseServiceInterfaceFileWriteCommand;
import org.sklsft.generator.skeletons.core.commands.api.interfaces.ServiceInterfaceFileWriteCommand;
import org.sklsft.generator.skeletons.core.commands.api.model.BasicViewBeanFileWriteCommand;
import org.sklsft.generator.skeletons.core.commands.api.model.FilterFileWriteCommand;
import org.sklsft.generator.skeletons.core.commands.api.model.FormBeanFileWriteCommand;
import org.sklsft.generator.skeletons.core.commands.api.model.FullViewBeanFileWriteCommand;
import org.sklsft.generator.skeletons.core.commands.api.model.SortingFileWriteCommand;
import org.sklsft.generator.skeletons.layers.AbstractLayer;
import org.sklsft.generator.skeletons.tree.FileWriteCommandTreeNode;

public class ApiLayer
extends AbstractLayer {
    public ApiLayer() {
        super("API");
    }

    public FileWriteCommandTreeNode getResourcesNode(Project project) {
        return null;
    }

    public FileWriteCommandTreeNode getConfigurationNode(Project project) {
        FileWriteCommandTreeNode configurationTreeNode = new FileWriteCommandTreeNode();
        FileWriteCommandTreeNode apiPomTreeNode = new FileWriteCommandTreeNode((FileWriteCommand)new ApiPomFileWriteCommand(project));
        configurationTreeNode.add((MutableTreeNode)apiPomTreeNode);
        return configurationTreeNode;
    }

    public FileWriteCommandTreeNode getGenerationNode(Project project) {
        FileWriteCommandTreeNode apiTreeNode = new FileWriteCommandTreeNode();
        FileWriteCommandTreeNode interfacesTreeNode = new FileWriteCommandTreeNode("Interfaces");
        apiTreeNode.add((MutableTreeNode)interfacesTreeNode);
        for (Package myPackage : project.model.packages) {
            FileWriteCommandTreeNode packageTreeNode = new FileWriteCommandTreeNode(myPackage.name);
            interfacesTreeNode.add((MutableTreeNode)packageTreeNode);
            for (Bean bean : myPackage.beans) {
                if (bean.isComponent) continue;
                FileWriteCommandTreeNode baseBeanTreeNode = new FileWriteCommandTreeNode((FileWriteCommand)new BaseServiceInterfaceFileWriteCommand(bean));
                interfacesTreeNode.add((MutableTreeNode)baseBeanTreeNode);
                FileWriteCommandTreeNode beanTreeNode = new FileWriteCommandTreeNode((FileWriteCommand)new ServiceInterfaceFileWriteCommand(bean));
                interfacesTreeNode.add((MutableTreeNode)beanTreeNode);
            }
        }
        FileWriteCommandTreeNode modelTreeNode = new FileWriteCommandTreeNode("Model");
        apiTreeNode.add((MutableTreeNode)modelTreeNode);
        for (Package myPackage : project.model.packages) {
            Object bean2;
            FileWriteCommandTreeNode packageTreeNode = new FileWriteCommandTreeNode(myPackage.name);
            modelTreeNode.add((MutableTreeNode)packageTreeNode);
            FileWriteCommandTreeNode ovTreeNode = new FileWriteCommandTreeNode("Views");
            packageTreeNode.add((MutableTreeNode)ovTreeNode);
            for (Object bean2 : myPackage.beans) {
                if (((Bean)bean2).isEmbedded) continue;
                FileWriteCommandTreeNode basicViewTreeNode = new FileWriteCommandTreeNode((FileWriteCommand)new BasicViewBeanFileWriteCommand((Bean)bean2));
                ovTreeNode.add((MutableTreeNode)basicViewTreeNode);
                FileWriteCommandTreeNode fullViewTreeNode = new FileWriteCommandTreeNode((FileWriteCommand)new FullViewBeanFileWriteCommand((Bean)bean2));
                ovTreeNode.add((MutableTreeNode)fullViewTreeNode);
                FileWriteCommandTreeNode formTreeNode = new FileWriteCommandTreeNode((FileWriteCommand)new FormBeanFileWriteCommand((Bean)bean2));
                ovTreeNode.add((MutableTreeNode)formTreeNode);
            }
            FileWriteCommandTreeNode filterTreeNode = new FileWriteCommandTreeNode("Filters");
            packageTreeNode.add((MutableTreeNode)filterTreeNode);
            bean2 = myPackage.beans.iterator();
            while (bean2.hasNext()) {
                Bean bean3 = (Bean)bean2.next();
                if (bean3.isEmbedded || bean3.isOneToOneComponent) continue;
                FileWriteCommandTreeNode beanTreeNode = new FileWriteCommandTreeNode((FileWriteCommand)new FilterFileWriteCommand(bean3));
                filterTreeNode.add((MutableTreeNode)beanTreeNode);
            }
            FileWriteCommandTreeNode oerderingTreeNode = new FileWriteCommandTreeNode("Orderings");
            packageTreeNode.add((MutableTreeNode)oerderingTreeNode);
            for (Bean bean4 : myPackage.beans) {
                if (bean4.isEmbedded || bean4.isOneToOneComponent) continue;
                FileWriteCommandTreeNode beanTreeNode = new FileWriteCommandTreeNode((FileWriteCommand)new SortingFileWriteCommand(bean4));
                filterTreeNode.add((MutableTreeNode)beanTreeNode);
            }
        }
        return apiTreeNode;
    }
}

