/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.generator.skeletons.core.commands.services;

import java.io.File;
import java.io.IOException;
import org.sklsft.generator.model.domain.business.Bean;
import org.sklsft.generator.model.domain.business.OneToManyComponent;
import org.sklsft.generator.model.domain.business.OneToOneComponent;
import org.sklsft.generator.model.domain.business.Property;
import org.sklsft.generator.model.domain.ui.ViewProperty;
import org.sklsft.generator.model.metadata.RelationType;
import org.sklsft.generator.model.metadata.SelectionMode;
import org.sklsft.generator.skeletons.commands.impl.typed.JavaFileWriteCommand;

public class BaseServiceImplFileWriteCommand
extends JavaFileWriteCommand {
    private Bean bean;

    public BaseServiceImplFileWriteCommand(Bean bean) {
        super(bean.myPackage.model.project.workspaceFolder + File.separator + bean.myPackage.model.project.projectName + "-services" + File.separator + "src" + File.separator + "main" + File.separator + "java" + File.separator + bean.myPackage.baseServiceImplPackageName.replace(".", File.separator), bean.baseServiceClassName);
        this.bean = bean;
    }

    protected void fetchSpecificImports() {
        Bean currentBean;
        this.javaImports.add("import java.util.Date;");
        this.javaImports.add("import java.math.BigDecimal;");
        this.javaImports.add("import java.util.Collection;");
        this.javaImports.add("import java.util.List;");
        this.javaImports.add("import java.util.ArrayList;");
        this.javaImports.add("import javax.inject.Inject;");
        this.javaImports.add("import org.springframework.transaction.annotation.Transactional;");
        this.javaImports.add("import org.sklsft.commons.api.model.ScrollForm;");
        this.javaImports.add("import org.sklsft.commons.api.model.ScrollView;");
        this.javaImports.add("import org.sklsft.commons.api.model.SelectItem;");
        this.javaImports.add("import " + this.bean.myPackage.omPackageName + "." + this.bean.className + ";");
        this.javaImports.add("import " + this.bean.myPackage.basicViewsPackageName + "." + this.bean.basicViewBean.className + ";");
        this.javaImports.add("import " + this.bean.myPackage.fullViewsPackageName + "." + this.bean.fullViewBean.className + ";");
        this.javaImports.add("import " + this.bean.myPackage.formsPackageName + "." + this.bean.formBean.className + ";");
        this.javaImports.add("import " + this.bean.myPackage.filtersPackageName + "." + this.bean.basicViewBean.filterClassName + ";");
        this.javaImports.add("import " + this.bean.myPackage.sortingsPackageName + "." + this.bean.basicViewBean.sortingClassName + ";");
        this.javaImports.add("import " + this.bean.myPackage.DAOInterfacePackageName + "." + this.bean.daoInterfaceName + ";");
        for (Property property : this.bean.properties) {
            if (property.referenceBean == null || !property.relation.equals((Object)RelationType.MANY_TO_ONE)) continue;
            Bean parentBean = property.referenceBean;
            this.javaImports.add("import " + parentBean.myPackage.omPackageName + "." + parentBean.className + ";");
            this.javaImports.add("import " + parentBean.myPackage.DAOInterfacePackageName + "." + parentBean.daoInterfaceName + ";");
        }
        this.javaImports.add("import " + this.bean.myPackage.basicViewMapperPackageName + "." + this.bean.basicViewBean.mapperClassName + ";");
        this.javaImports.add("import " + this.bean.myPackage.fullViewMapperPackageName + "." + this.bean.fullViewBean.mapperClassName + ";");
        this.javaImports.add("import " + this.bean.myPackage.formMapperPackageName + "." + this.bean.formBean.mapperClassName + ";");
        this.javaImports.add("import " + this.bean.myPackage.processorImplPackageName + "." + this.bean.processorClassName + ";");
        this.javaImports.add("import " + this.bean.myPackage.stateManagerImplPackageName + "." + this.bean.stateManagerClassName + ";");
        this.javaImports.add("import " + this.bean.myPackage.rightsManagerImplPackageName + "." + this.bean.rightsManagerClassName + ";");
        this.javaImports.add("import " + this.bean.myPackage.baseServiceInterfacePackageName + "." + this.bean.baseServiceInterfaceName + ";");
        for (OneToOneComponent oneToOneComponent : this.bean.oneToOneComponentList) {
            currentBean = oneToOneComponent.referenceBean;
            this.javaImports.add("import " + currentBean.myPackage.omPackageName + "." + currentBean.className + ";");
            this.javaImports.add("import " + currentBean.myPackage.fullViewsPackageName + "." + currentBean.fullViewBean.className + ";");
            this.javaImports.add("import " + currentBean.myPackage.formsPackageName + "." + currentBean.formBean.className + ";");
            this.javaImports.add("import " + currentBean.myPackage.fullViewMapperPackageName + "." + currentBean.fullViewBean.mapperClassName + ";");
            this.javaImports.add("import " + currentBean.myPackage.formMapperPackageName + "." + currentBean.formBean.mapperClassName + ";");
        }
        for (OneToManyComponent oneToManyComponent : this.bean.oneToManyComponentList) {
            currentBean = oneToManyComponent.referenceBean;
            this.javaImports.add("import " + currentBean.myPackage.omPackageName + "." + currentBean.className + ";");
            this.javaImports.add("import " + currentBean.myPackage.basicViewsPackageName + "." + currentBean.basicViewBean.className + ";");
            this.javaImports.add("import " + currentBean.myPackage.basicViewMapperPackageName + "." + currentBean.basicViewBean.mapperClassName + ";");
            this.javaImports.add("import " + currentBean.myPackage.fullViewsPackageName + "." + currentBean.fullViewBean.className + ";");
            this.javaImports.add("import " + currentBean.myPackage.fullViewMapperPackageName + "." + currentBean.fullViewBean.mapperClassName + ";");
            this.javaImports.add("import " + currentBean.myPackage.formsPackageName + "." + currentBean.formBean.className + ";");
            this.javaImports.add("import " + currentBean.myPackage.filtersPackageName + "." + currentBean.basicViewBean.filterClassName + ";");
            this.javaImports.add("import " + currentBean.myPackage.sortingsPackageName + "." + currentBean.basicViewBean.sortingClassName + ";");
            this.javaImports.add("import " + currentBean.myPackage.formMapperPackageName + "." + currentBean.formBean.mapperClassName + ";");
        }
    }

    protected void writeContent() throws IOException {
        Bean currentBean;
        this.writeLine("package " + this.bean.myPackage.baseServiceImplPackageName + ";");
        this.skipLine();
        this.writeImports();
        this.skipLine();
        this.writeLine("/**");
        this.writeLine(" * auto generated base service class file");
        this.writeLine(" * <br/>no modification should be done to this file");
        this.writeLine(" * <br/>processed by skeleton-generator");
        this.writeLine(" */");
        this.writeLine("public class " + this.bean.baseServiceClassName + " implements " + this.bean.baseServiceInterfaceName + " {");
        this.skipLine();
        this.writeLine("/*");
        this.writeLine(" * properties injected by spring");
        this.writeLine(" */");
        this.writeLine("@Inject");
        this.writeLine("protected " + this.bean.daoInterfaceName + " " + this.bean.daoObjectName + ";");
        for (Property property : this.bean.properties) {
            if (property.referenceBean == null || !property.relation.equals((Object)RelationType.MANY_TO_ONE)) continue;
            Bean parentBean = property.referenceBean;
            this.writeLine("@Inject");
            this.writeLine("protected " + parentBean.daoInterfaceName + " " + parentBean.daoObjectName + ";");
        }
        this.writeLine("@Inject");
        this.writeLine("protected " + this.bean.fullViewBean.mapperClassName + " " + this.bean.fullViewBean.mapperObjectName + ";");
        this.writeLine("@Inject");
        this.writeLine("protected " + this.bean.basicViewBean.mapperClassName + " " + this.bean.basicViewBean.mapperObjectName + ";");
        this.writeLine("@Inject");
        this.writeLine("protected " + this.bean.formBean.mapperClassName + " " + this.bean.formBean.mapperObjectName + ";");
        for (OneToOneComponent oneToOneComponent : this.bean.oneToOneComponentList) {
            currentBean = oneToOneComponent.referenceBean;
            this.writeLine("@Inject");
            this.writeLine("protected " + currentBean.fullViewBean.mapperClassName + " " + currentBean.fullViewBean.mapperObjectName + ";");
            this.writeLine("@Inject");
            this.writeLine("protected " + currentBean.formBean.mapperClassName + " " + currentBean.formBean.mapperObjectName + ";");
        }
        for (OneToManyComponent oneToManyComponent : this.bean.oneToManyComponentList) {
            currentBean = oneToManyComponent.referenceBean;
            this.writeLine("@Inject");
            this.writeLine("protected " + currentBean.fullViewBean.mapperClassName + " " + currentBean.fullViewBean.mapperObjectName + ";");
            this.writeLine("@Inject");
            this.writeLine("protected " + currentBean.basicViewBean.mapperClassName + " " + currentBean.basicViewBean.mapperObjectName + ";");
            this.writeLine("@Inject");
            this.writeLine("protected " + currentBean.formBean.mapperClassName + " " + currentBean.formBean.mapperObjectName + ";");
        }
        this.writeLine("@Inject");
        this.writeLine("protected " + this.bean.stateManagerClassName + " " + this.bean.stateManagerObjectName + ";");
        this.writeLine("@Inject");
        this.writeLine("protected " + this.bean.rightsManagerClassName + " " + this.bean.rightsManagerObjectName + ";");
        this.writeLine("@Inject");
        this.writeLine("protected " + this.bean.processorClassName + " " + this.bean.processorObjectName + ";");
        this.skipLine();
        if (this.bean.selectable) {
            this.createGetOptions();
        }
        this.createLoadObjectList();
        this.createScroll();
        this.createLoadObject();
        if (this.bean.cardinality > 0) {
            this.createFindObject();
        }
        this.createLoadOneToOneComponent();
        this.createLoadOneToManyComponentList();
        this.createScrollOneToManyComponent();
        this.createLoadOneToManyComponent();
        this.createCreateObject();
        this.createCreateOneToManyComponent();
        this.createSaveObject();
        this.createSaveOneToOneComponent();
        this.createSaveOneToManyComponent();
        this.createUpdateObject();
        this.createUpdateOneTOneComponent();
        this.createUpdateOneToManyComponent();
        this.createDeleteObject();
        this.createDeleteOneToOneComponent();
        this.createDeleteOneToManyComponent();
        this.createDeleteObjectList();
        this.createDeleteOneToManyComponentList();
        this.writeLine("}");
    }

    private void createGetOptions() {
        Property labelProperty;
        Property targetProperty = this.bean.selectionBehavior.targetProperty;
        Property property = labelProperty = this.bean.selectionBehavior.labelProperty != null ? this.bean.selectionBehavior.labelProperty : this.bean.selectionBehavior.targetProperty;
        if (this.bean.selectionBehavior.selectionMode.equals((Object)SelectionMode.DROPDOWN_OPTIONS)) {
            this.writeLine("/**");
            this.writeLine(" * get options");
            this.writeLine(" */");
            this.writeLine("@Override");
            this.writeLine("@Transactional(readOnly=true)");
            this.writeLine("public List<SelectItem> getOptions() {");
            this.writeLine("List<" + this.bean.className + "> " + this.bean.objectName + "List = " + this.bean.daoObjectName + ".loadList();");
            this.writeLine("List<SelectItem> result = new ArrayList<>(" + this.bean.objectName + "List.size());");
            this.writeLine("for (" + this.bean.className + " " + this.bean.objectName + " : " + this.bean.objectName + "List) {");
            this.writeLine("result.add(new SelectItem(" + this.bean.objectName + "." + targetProperty.getterName + "(), " + this.bean.objectName + "." + labelProperty.getterName + "()));");
            this.writeLine("}");
            this.writeLine("return result;");
            this.writeLine("}");
            this.skipLine();
        }
        if (this.bean.selectionBehavior.selectionMode.equals((Object)SelectionMode.AUTO_COMPLETE)) {
            this.writeLine("/**");
            this.writeLine(" * search options");
            this.writeLine(" */");
            this.writeLine("@Override");
            this.writeLine("@Transactional(readOnly=true)");
            this.writeLine("public List<SelectItem> searchOptions(String arg) {");
            this.writeLine("List<" + this.bean.className + "> " + this.bean.objectName + "List = " + this.bean.daoObjectName + ".search(arg);");
            this.writeLine("List<SelectItem> result = new ArrayList<>(" + this.bean.objectName + "List.size());");
            this.writeLine("for (" + this.bean.className + " " + this.bean.objectName + " : " + this.bean.objectName + "List) {");
            this.writeLine("result.add(new SelectItem(" + this.bean.objectName + "." + targetProperty.getterName + "(), " + this.bean.objectName + "." + labelProperty.getterName + "()));");
            this.writeLine("}");
            this.writeLine("return result;");
            this.writeLine("}");
            this.skipLine();
        }
    }

    private void createLoadObjectList() {
        this.writeLine("/**");
        this.writeLine(" * load object list");
        this.writeLine(" */");
        this.writeLine("@Override");
        this.writeLine("@Transactional(readOnly=true)");
        this.writeLine("public List<" + this.bean.basicViewBean.className + "> loadList() {");
        this.writeLine(this.bean.rightsManagerObjectName + ".checkCanAccess();");
        this.writeLine("List<" + this.bean.className + "> " + this.bean.objectName + "List = " + this.bean.daoObjectName + ".loadListEagerly();");
        this.writeLine("List<" + this.bean.basicViewBean.className + "> result = new ArrayList<>(" + this.bean.objectName + "List.size());");
        this.writeLine("for (" + this.bean.className + " " + this.bean.objectName + " : " + this.bean.objectName + "List) {");
        this.writeLine("result.add(this." + this.bean.basicViewBean.mapperObjectName + ".mapFrom(new " + this.bean.basicViewBean.className + "()," + this.bean.objectName + "));");
        this.writeLine("}");
        this.writeLine("return result;");
        this.writeLine("}");
        this.skipLine();
        for (Property property : this.bean.properties) {
            if (property.referenceBean == null || !property.relation.equals((Object)RelationType.MANY_TO_ONE)) continue;
            this.writeLine("/**");
            this.writeLine(" * load object list from " + property.name);
            this.writeLine(" */");
            this.writeLine("@Override");
            this.writeLine("@Transactional(readOnly=true)");
            this.writeLine("public List<" + this.bean.basicViewBean.className + "> loadListFrom" + property.capName + " (Long " + property.name + "Id) {");
            this.writeLine(this.bean.rightsManagerObjectName + ".checkCanAccess();");
            this.writeLine("List<" + this.bean.className + "> " + this.bean.objectName + "List = " + this.bean.daoObjectName + ".loadListEagerlyFrom" + property.capName + "(" + property.name + "Id);");
            this.writeLine("List<" + this.bean.basicViewBean.className + "> result = new ArrayList<>(" + this.bean.objectName + "List.size());");
            this.writeLine("for (" + this.bean.className + " " + this.bean.objectName + " : " + this.bean.objectName + "List) {");
            this.writeLine("result.add(this." + this.bean.basicViewBean.mapperObjectName + ".mapFrom(new " + this.bean.basicViewBean.className + "()," + this.bean.objectName + "));");
            this.writeLine("}");
            this.writeLine("return result;");
            this.writeLine("}");
            this.skipLine();
        }
    }

    private void createScroll() {
        this.writeLine("/**");
        this.writeLine(" * scroll object list");
        this.writeLine(" */");
        this.writeLine("@Override");
        this.writeLine("@Transactional(readOnly=true)");
        this.writeLine("public ScrollView<" + this.bean.basicViewBean.className + "> scroll(ScrollForm<" + this.bean.basicViewBean.filterClassName + ", " + this.bean.basicViewBean.sortingClassName + "> form) {");
        this.writeLine(this.bean.rightsManagerObjectName + ".checkCanAccess();");
        this.writeLine("ScrollView<" + this.bean.basicViewBean.className + "> result = new ScrollView<>();");
        this.writeLine("result.setSize(" + this.bean.daoObjectName + ".count());");
        this.writeLine("Long count = " + this.bean.daoObjectName + ".count(form.getFilter());");
        this.writeLine("result.setNumberOfPages(count/form.getElementsPerPage() + ((count%form.getElementsPerPage()) > 0L?1L:0L));");
        this.writeLine("result.setCurrentPage(Math.max(1L, Math.min(form.getPage()!=null?form.getPage():1L, result.getNumberOfPages())));");
        this.writeLine("List<" + this.bean.className + "> list = " + this.bean.daoObjectName + ".scroll(form.getFilter(), form.getSorting(),(result.getCurrentPage()-1)*form.getElementsPerPage(), form.getElementsPerPage());");
        this.writeLine("List<" + this.bean.basicViewBean.className + "> elements = new ArrayList<>(list.size());");
        this.writeLine("for (" + this.bean.className + " " + this.bean.objectName + " : list) {");
        this.writeLine("elements.add(this." + this.bean.basicViewBean.mapperObjectName + ".mapFrom(new " + this.bean.basicViewBean.className + "()," + this.bean.objectName + "));");
        this.writeLine("}");
        this.writeLine("result.setElements(elements);");
        this.writeLine("return result;");
        this.writeLine("}");
        this.skipLine();
        for (Property property : this.bean.properties) {
            if (property.referenceBean == null || !property.relation.equals((Object)RelationType.MANY_TO_ONE)) continue;
            this.writeLine("/**");
            this.writeLine(" * scroll object list from " + property.name);
            this.writeLine(" */");
            this.writeLine("@Override");
            this.writeLine("@Transactional(readOnly=true)");
            this.writeLine("public ScrollView<" + this.bean.basicViewBean.className + "> scrollFrom" + property.capName + " (Long " + property.name + "Id, ScrollForm<" + this.bean.basicViewBean.filterClassName + ", " + this.bean.basicViewBean.sortingClassName + "> form) {");
            this.writeLine(this.bean.rightsManagerObjectName + ".checkCanAccess();");
            this.writeLine("ScrollView<" + this.bean.basicViewBean.className + "> result = new ScrollView<>();");
            this.writeLine("result.setSize(" + this.bean.daoObjectName + ".countFrom" + property.capName + "(" + property.name + "Id));");
            this.writeLine("Long count = " + this.bean.daoObjectName + ".countFrom" + property.capName + "(" + property.name + "Id, form.getFilter());");
            this.writeLine("result.setNumberOfPages(count/form.getElementsPerPage() + ((count%form.getElementsPerPage()) > 0L?1L:0L));");
            this.writeLine("result.setCurrentPage(Math.max(1L, Math.min(form.getPage()!=null?form.getPage():1L, result.getNumberOfPages())));");
            this.writeLine("List<" + this.bean.className + "> list = " + this.bean.daoObjectName + ".scrollFrom" + property.capName + "(" + property.name + "Id, form.getFilter(), form.getSorting(),(result.getCurrentPage()-1)*form.getElementsPerPage(), form.getElementsPerPage());");
            this.writeLine("List<" + this.bean.basicViewBean.className + "> elements = new ArrayList<>(list.size());");
            this.writeLine("for (" + this.bean.className + " " + this.bean.objectName + " : list) {");
            this.writeLine("elements.add(this." + this.bean.basicViewBean.mapperObjectName + ".mapFrom(new " + this.bean.basicViewBean.className + "()," + this.bean.objectName + "));");
            this.writeLine("}");
            this.writeLine("result.setElements(elements);");
            this.writeLine("return result;");
            this.writeLine("}");
            this.skipLine();
        }
    }

    private void createLoadObject() {
        this.writeLine("/**");
        this.writeLine(" * load object");
        this.writeLine(" */");
        this.writeLine("@Override");
        this.writeLine("@Transactional(readOnly=true)");
        this.writeLine("public " + this.bean.fullViewBean.className + " load(Long id) {");
        this.writeLine(this.bean.className + " " + this.bean.objectName + " = " + this.bean.daoObjectName + ".load(id);");
        this.writeLine(this.bean.rightsManagerObjectName + ".checkCanAccess(" + this.bean.objectName + ");");
        this.writeLine("return this." + this.bean.fullViewBean.mapperObjectName + ".mapFrom(new " + this.bean.fullViewBean.className + "()," + this.bean.objectName + ");");
        this.writeLine("}");
        this.skipLine();
    }

    private void createFindObject() {
        boolean start = true;
        this.writeLine("/**");
        this.writeLine(" * find object");
        this.writeLine(" */");
        this.writeLine("@Override");
        this.writeLine("@Transactional(readOnly=true)");
        this.write("public " + this.bean.fullViewBean.className + " find(");
        for (ViewProperty property : this.bean.referenceViewProperties) {
            if (start) {
                start = false;
            } else {
                this.write(", ");
            }
            this.write(property.beanDataType + " " + property.name);
        }
        this.writeLine(") {");
        start = true;
        this.write(this.bean.className + " " + this.bean.objectName + " = " + this.bean.daoObjectName + ".find(");
        for (ViewProperty property : this.bean.referenceViewProperties) {
            if (start) {
                start = false;
            } else {
                this.write(", ");
            }
            this.write(property.name);
        }
        this.writeLine(");");
        this.writeLine(this.bean.rightsManagerObjectName + ".checkCanAccess(" + this.bean.objectName + ");");
        this.writeLine("return this." + this.bean.fullViewBean.mapperObjectName + ".mapFrom(new " + this.bean.fullViewBean.className + "(), " + this.bean.objectName + ");");
        this.writeLine("}");
        this.skipLine();
    }

    private void createLoadOneToOneComponent() {
        for (OneToOneComponent oneToOneComponent : this.bean.oneToOneComponentList) {
            Bean currentBean = oneToOneComponent.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * load one to one component " + currentBean.objectName);
            this.writeLine(" */");
            this.writeLine("@Override");
            this.writeLine("@Transactional(readOnly=true)");
            this.writeLine("public " + currentBean.fullViewBean.className + " load" + currentBean.className + "(Long id) {");
            this.writeLine(this.bean.className + " " + this.bean.objectName + " = " + this.bean.daoObjectName + ".load(id);");
            this.writeLine(this.bean.rightsManagerObjectName + ".checkCanAccess" + currentBean.className + "(" + this.bean.objectName + ");");
            this.writeLine(currentBean.className + " " + currentBean.objectName + " = " + this.bean.objectName + ".get" + currentBean.className + "();");
            this.writeLine("if (" + currentBean.objectName + "==null) {");
            this.writeLine("return new " + currentBean.fullViewBean.className + "();");
            this.writeLine("} else {");
            this.writeLine("return this." + currentBean.fullViewBean.mapperObjectName + ".mapFrom(new " + currentBean.fullViewBean.className + "(), " + currentBean.objectName + ");");
            this.writeLine("}");
            this.writeLine("}");
            this.skipLine();
        }
    }

    private void createLoadOneToManyComponentList() {
        for (OneToManyComponent oneToManyComponent : this.bean.oneToManyComponentList) {
            Bean currentBean = oneToManyComponent.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * load one to many component " + currentBean.objectName + " list");
            this.writeLine(" */");
            this.writeLine("@Override");
            this.writeLine("@Transactional(readOnly=true)");
            this.writeLine("public List<" + currentBean.basicViewBean.className + "> load" + currentBean.className + "List(Long id) {");
            this.writeLine(this.bean.className + " " + this.bean.objectName + " = " + this.bean.daoObjectName + ".load(id);");
            this.writeLine(this.bean.rightsManagerObjectName + ".checkCanAccess" + currentBean.className + "(" + this.bean.objectName + ");");
            this.writeLine("List<" + currentBean.className + "> " + currentBean.objectName + "List = " + this.bean.daoObjectName + ".load" + currentBean.className + "List(id);");
            this.writeLine("List<" + currentBean.basicViewBean.className + "> result = new ArrayList<>(" + currentBean.objectName + "List.size());");
            this.writeLine("for (" + currentBean.className + " " + currentBean.objectName + ":" + currentBean.objectName + "List){");
            this.writeLine("result.add(this." + currentBean.basicViewBean.mapperObjectName + ".mapFrom(new " + currentBean.basicViewBean.className + "()," + currentBean.objectName + "));");
            this.writeLine("}");
            this.writeLine("return result;");
            this.writeLine("}");
            this.skipLine();
        }
    }

    private void createScrollOneToManyComponent() {
        for (OneToManyComponent oneToManyComponent : this.bean.oneToManyComponentList) {
            Bean currentBean = oneToManyComponent.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * scroll one to many component " + currentBean.objectName);
            this.writeLine(" */");
            this.writeLine("@Override");
            this.writeLine("@Transactional(readOnly=true)");
            this.writeLine("public ScrollView<" + currentBean.basicViewBean.className + "> scroll" + currentBean.className + " (Long " + this.bean.objectName + "Id, ScrollForm<" + currentBean.basicViewBean.filterClassName + ", " + currentBean.basicViewBean.sortingClassName + "> form) {");
            this.writeLine(this.bean.className + " " + this.bean.objectName + " = " + this.bean.daoObjectName + ".load(" + this.bean.objectName + "Id);");
            this.writeLine(this.bean.rightsManagerObjectName + ".checkCanAccess" + currentBean.className + "(" + this.bean.objectName + ");");
            this.writeLine("ScrollView<" + currentBean.basicViewBean.className + "> result = new ScrollView<>();");
            this.writeLine("result.setSize(" + this.bean.daoObjectName + ".count" + currentBean.className + "(" + this.bean.objectName + "Id));");
            this.writeLine("Long count = " + this.bean.daoObjectName + ".count" + currentBean.className + "(" + this.bean.objectName + "Id, form.getFilter());");
            this.writeLine("result.setNumberOfPages(count/form.getElementsPerPage() + ((count%form.getElementsPerPage()) > 0L?1L:0L));");
            this.writeLine("result.setCurrentPage(Math.max(1L, Math.min(form.getPage()!=null?form.getPage():1L, result.getNumberOfPages())));");
            this.writeLine("List<" + currentBean.className + "> list = " + this.bean.daoObjectName + ".scroll" + currentBean.className + "(" + this.bean.objectName + "Id, form.getFilter(), form.getSorting(),(result.getCurrentPage()-1)*form.getElementsPerPage(), form.getElementsPerPage());");
            this.writeLine("List<" + currentBean.basicViewBean.className + "> elements = new ArrayList<>(list.size());");
            this.writeLine("for (" + currentBean.className + " " + currentBean.objectName + " : list) {");
            this.writeLine("elements.add(this." + currentBean.basicViewBean.mapperObjectName + ".mapFrom(new " + currentBean.basicViewBean.className + "()," + currentBean.objectName + "));");
            this.writeLine("}");
            this.writeLine("result.setElements(elements);");
            this.writeLine("return result;");
            this.writeLine("}");
            this.skipLine();
        }
    }

    private void createLoadOneToManyComponent() {
        for (OneToManyComponent oneToManyComponent : this.bean.oneToManyComponentList) {
            Bean currentBean = oneToManyComponent.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * load one to many component " + currentBean.objectName);
            this.writeLine(" */");
            this.writeLine("@Override");
            this.writeLine("@Transactional(readOnly=true)");
            this.writeLine("public " + currentBean.fullViewBean.className + " load" + currentBean.className + "(Long id) {");
            this.writeLine(currentBean.className + " " + currentBean.objectName + " = " + this.bean.daoObjectName + ".load" + currentBean.className + "(id);");
            this.writeLine(this.bean.rightsManagerObjectName + ".checkCanAccess" + currentBean.className + "(" + currentBean.objectName + ".get" + oneToManyComponent.referenceProperty.capName + "());");
            this.writeLine("return this." + currentBean.fullViewBean.mapperObjectName + ".mapFrom(" + currentBean.objectName + ");");
            this.writeLine("}");
            this.skipLine();
        }
    }

    private void createCreateObject() {
        this.writeLine("/**");
        this.writeLine(" * create object");
        this.writeLine(" */");
        this.writeLine("@Override");
        this.writeLine("public " + this.bean.fullViewBean.className + " create() {");
        this.writeLine(this.bean.rightsManagerObjectName + ".checkCanCreate();");
        this.writeLine("return new " + this.bean.fullViewBean.className + "();");
        this.writeLine("}");
        this.skipLine();
    }

    private void createCreateOneToManyComponent() {
        for (OneToManyComponent oneToManyComponent : this.bean.oneToManyComponentList) {
            Bean currentBean = oneToManyComponent.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * create one to many component " + currentBean.objectName);
            this.writeLine(" */");
            this.writeLine("@Override");
            this.writeLine("@Transactional(readOnly=true)");
            this.writeLine("public " + currentBean.fullViewBean.className + " create" + currentBean.className + "(Long id) {");
            this.writeLine(this.bean.className + " " + this.bean.objectName + " = " + this.bean.daoObjectName + ".load(id);");
            this.writeLine(this.bean.rightsManagerObjectName + ".checkCanCreate" + currentBean.className + "(" + this.bean.objectName + ");");
            this.writeLine("return new " + currentBean.fullViewBean.className + "();");
            this.writeLine("}");
            this.skipLine();
        }
    }

    private void createSaveObject() {
        this.writeLine("/**");
        this.writeLine(" * save object");
        this.writeLine(" */");
        this.writeLine("@Override");
        this.writeLine("@Transactional(rollbackFor=Exception.class)");
        this.writeLine("public Long save(" + this.bean.formBean.className + " " + this.bean.formBean.objectName + ") {");
        this.writeLine(this.bean.className + " " + this.bean.objectName + " = this." + this.bean.formBean.mapperObjectName + ".mapTo(" + this.bean.formBean.objectName + ", new " + this.bean.className + "());");
        this.writeLine(this.bean.rightsManagerObjectName + ".checkCanSave(" + this.bean.objectName + ");");
        this.writeLine(this.bean.stateManagerObjectName + ".checkCanSave(" + this.bean.objectName + ");");
        this.writeLine("return " + this.bean.processorObjectName + ".save(" + this.bean.objectName + ");");
        this.writeLine("}");
        this.skipLine();
        for (Property property : this.bean.properties) {
            if (property.referenceBean == null || !property.relation.equals((Object)RelationType.MANY_TO_ONE)) continue;
            Bean parentBean = property.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * save object from parent " + parentBean.className);
            this.writeLine(" */");
            this.writeLine("@Override");
            this.writeLine("@Transactional(rollbackFor=Exception.class)");
            this.writeLine("public Long saveFrom" + parentBean.className + "(Long " + parentBean.objectName + "Id, " + this.bean.formBean.className + " " + this.bean.formBean.objectName + ") {");
            this.writeLine(this.bean.className + " " + this.bean.objectName + " = this." + this.bean.formBean.mapperObjectName + ".mapTo(" + this.bean.formBean.objectName + ", new " + this.bean.className + "());");
            this.writeLine(parentBean.className + " " + parentBean.objectName + " = this." + parentBean.daoObjectName + ".load(" + parentBean.objectName + "Id);");
            this.writeLine(this.bean.objectName + "." + property.setterName + "(" + parentBean.objectName + ");");
            this.writeLine(this.bean.rightsManagerObjectName + ".checkCanSave(" + this.bean.objectName + ");");
            this.writeLine(this.bean.stateManagerObjectName + ".checkCanSave(" + this.bean.objectName + ");");
            this.writeLine("return " + this.bean.processorObjectName + ".save(" + this.bean.objectName + ");");
            this.writeLine("}");
            this.skipLine();
        }
    }

    private void createSaveOneToOneComponent() {
        for (OneToOneComponent oneToOneComponent : this.bean.oneToOneComponentList) {
            Bean currentBean = oneToOneComponent.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * save one to one component " + currentBean.objectName);
            this.writeLine(" */");
            this.writeLine("@Override");
            this.writeLine("@Transactional(rollbackFor=Exception.class)");
            this.writeLine("public void save" + currentBean.className + "(Long id, " + currentBean.formBean.className + " " + currentBean.formBean.objectName + ") {");
            this.writeLine(this.bean.className + " " + this.bean.objectName + " = this." + this.bean.daoObjectName + ".load(id);");
            this.writeLine(currentBean.className + " " + currentBean.objectName + " = this." + currentBean.formBean.mapperObjectName + ".mapTo(" + currentBean.formBean.objectName + ", new " + currentBean.className + "());");
            this.writeLine(this.bean.rightsManagerObjectName + ".checkCanSave" + currentBean.className + "(" + currentBean.objectName + "," + this.bean.objectName + ");");
            this.writeLine(this.bean.stateManagerObjectName + ".checkCanSave" + currentBean.className + "(" + currentBean.objectName + "," + this.bean.objectName + ");");
            this.writeLine(this.bean.processorObjectName + ".save" + currentBean.className + "(" + currentBean.objectName + ", " + this.bean.objectName + ");");
            this.writeLine("}");
            this.skipLine();
        }
    }

    private void createSaveOneToManyComponent() {
        for (OneToManyComponent oneToManyComponent : this.bean.oneToManyComponentList) {
            Bean currentBean = oneToManyComponent.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * save one to many component " + currentBean.objectName);
            this.writeLine(" */");
            this.writeLine("@Override");
            this.writeLine("@Transactional(rollbackFor=Exception.class)");
            this.writeLine("public void save" + currentBean.className + "(Long id, " + currentBean.formBean.className + " " + currentBean.formBean.objectName + ") {");
            this.writeLine(this.bean.className + " " + this.bean.objectName + " = this." + this.bean.daoObjectName + ".load(id);");
            this.writeLine(currentBean.className + " " + currentBean.objectName + " = this." + currentBean.formBean.mapperObjectName + ".mapTo(" + currentBean.formBean.objectName + ", new " + currentBean.className + "());");
            this.writeLine(this.bean.rightsManagerObjectName + ".checkCanSave" + currentBean.className + "(" + currentBean.objectName + "," + this.bean.objectName + ");");
            this.writeLine(this.bean.stateManagerObjectName + ".checkCanSave" + currentBean.className + "(" + currentBean.objectName + "," + this.bean.objectName + ");");
            this.writeLine(this.bean.processorObjectName + ".save" + currentBean.className + "(" + currentBean.objectName + "," + this.bean.objectName + ");");
            this.writeLine("}");
            this.skipLine();
        }
    }

    private void createUpdateObject() {
        this.writeLine("/**");
        this.writeLine(" * update object");
        this.writeLine(" */");
        this.writeLine("@Override");
        this.writeLine("@Transactional(rollbackFor=Exception.class)");
        this.writeLine("public void update(Long id, " + this.bean.formBean.className + " " + this.bean.formBean.objectName + ") {");
        this.writeLine(this.bean.className + " " + this.bean.objectName + " = this." + this.bean.daoObjectName + ".load(id);");
        this.writeLine(this.bean.rightsManagerObjectName + ".checkCanUpdate(" + this.bean.objectName + ");");
        this.writeLine(this.bean.stateManagerObjectName + ".checkCanUpdate(" + this.bean.objectName + ");");
        this.writeLine(this.bean.objectName + " = this." + this.bean.formBean.mapperObjectName + ".mapTo(" + this.bean.formBean.objectName + ", " + this.bean.objectName + ");");
        this.writeLine(this.bean.processorObjectName + ".update(" + this.bean.objectName + ");");
        this.writeLine("}");
        this.skipLine();
    }

    private void createUpdateOneTOneComponent() {
        for (OneToOneComponent oneToOneComponent : this.bean.oneToOneComponentList) {
            Bean currentBean = oneToOneComponent.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * update one to one component " + currentBean.objectName);
            this.writeLine(" */");
            this.writeLine("@Override");
            this.writeLine("@Transactional(rollbackFor=Exception.class)");
            this.writeLine("public void update" + currentBean.className + "(Long id, " + currentBean.formBean.className + " " + currentBean.formBean.objectName + ") {");
            this.writeLine(this.bean.className + " " + this.bean.objectName + " = this." + this.bean.daoObjectName + ".load(id);");
            this.writeLine(currentBean.className + " " + currentBean.objectName + " = " + this.bean.objectName + ".get" + currentBean.className + "();");
            this.writeLine(this.bean.rightsManagerObjectName + ".checkCanUpdate" + currentBean.className + "(" + currentBean.objectName + ");");
            this.writeLine(this.bean.stateManagerObjectName + ".checkCanUpdate" + currentBean.className + "(" + currentBean.objectName + ");");
            this.writeLine(this.bean.objectName + ".set" + currentBean.className + "(this." + currentBean.formBean.mapperObjectName + ".mapTo(" + currentBean.formBean.objectName + ", " + currentBean.objectName + "));");
            this.writeLine(this.bean.processorObjectName + ".update" + currentBean.className + "(" + currentBean.objectName + ");");
            this.writeLine("}");
            this.skipLine();
        }
    }

    private void createUpdateOneToManyComponent() {
        for (OneToManyComponent oneToManyComponent : this.bean.oneToManyComponentList) {
            Bean currentBean = oneToManyComponent.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * update one to many component " + currentBean.objectName);
            this.writeLine(" */");
            this.writeLine("@Override");
            this.writeLine("@Transactional(rollbackFor=Exception.class)");
            this.writeLine("public void update" + currentBean.className + "(Long id, " + currentBean.formBean.className + " " + currentBean.formBean.objectName + ") {");
            this.writeLine(currentBean.className + " " + currentBean.objectName + " = this." + this.bean.daoObjectName + ".load" + currentBean.className + "(id);");
            this.writeLine(this.bean.rightsManagerObjectName + ".checkCanUpdate" + currentBean.className + "(" + currentBean.objectName + ");");
            this.writeLine(this.bean.stateManagerObjectName + ".checkCanUpdate" + currentBean.className + "(" + currentBean.objectName + ");");
            this.writeLine(currentBean.objectName + " = this." + currentBean.formBean.mapperObjectName + ".mapTo(" + currentBean.formBean.objectName + ", " + currentBean.objectName + ");");
            this.writeLine(this.bean.processorObjectName + ".update" + currentBean.className + "(" + currentBean.objectName + ");");
            this.writeLine("}");
            this.skipLine();
            this.skipLine();
        }
    }

    private void createDeleteObject() {
        this.writeLine("/**");
        this.writeLine(" * delete object");
        this.writeLine(" */");
        this.writeLine("@Override");
        this.writeLine("@Transactional(rollbackFor=Exception.class)");
        this.writeLine("public void delete(Long id) {");
        this.writeLine(this.bean.className + " " + this.bean.objectName + " = " + this.bean.daoObjectName + ".load(id);");
        this.writeLine(this.bean.rightsManagerObjectName + ".checkCanDelete(" + this.bean.objectName + ");");
        this.writeLine(this.bean.stateManagerObjectName + ".checkCanDelete(" + this.bean.objectName + ");");
        this.writeLine(this.bean.processorObjectName + ".delete(" + this.bean.objectName + ");");
        this.writeLine("}");
        this.skipLine();
    }

    private void createDeleteOneToManyComponent() {
        for (OneToManyComponent oneToManyComponent : this.bean.oneToManyComponentList) {
            Bean currentBean = oneToManyComponent.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * delete one to many component " + currentBean.objectName);
            this.writeLine(" */");
            this.writeLine("@Override");
            this.writeLine("@Transactional(rollbackFor=Exception.class)");
            this.writeLine("public void delete" + currentBean.className + "(Long id) {");
            this.writeLine(currentBean.className + " " + currentBean.objectName + " = " + this.bean.daoObjectName + ".load" + currentBean.className + "(id);");
            this.writeLine(this.bean.rightsManagerObjectName + ".checkCanDelete" + currentBean.className + "(" + currentBean.objectName + ");");
            this.writeLine(this.bean.stateManagerObjectName + ".checkCanDelete" + currentBean.className + "(" + currentBean.objectName + ");");
            this.writeLine("this." + this.bean.processorObjectName + ".delete" + currentBean.className + "(" + currentBean.objectName + ");");
            this.writeLine("}");
            this.skipLine();
        }
    }

    private void createDeleteOneToOneComponent() {
        for (OneToOneComponent oneToOneComponent : this.bean.oneToOneComponentList) {
            Bean currentBean = oneToOneComponent.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * delete one to one component " + currentBean.objectName);
            this.writeLine(" */");
            this.writeLine("@Override");
            this.writeLine("@Transactional(rollbackFor=Exception.class)");
            this.writeLine("public void delete" + currentBean.className + "(Long id) {");
            this.writeLine(this.bean.className + " " + this.bean.objectName + " = this." + this.bean.daoObjectName + ".load(id);");
            this.writeLine(currentBean.className + " " + currentBean.objectName + " = " + this.bean.objectName + ".get" + currentBean.className + "();");
            this.writeLine(this.bean.rightsManagerObjectName + ".checkCanDelete" + currentBean.className + "(" + currentBean.objectName + ");");
            this.writeLine(this.bean.stateManagerObjectName + ".checkCanDelete" + currentBean.className + "(" + currentBean.objectName + ");");
            this.writeLine("this." + this.bean.processorObjectName + ".delete" + currentBean.className + "(" + currentBean.objectName + ");");
            this.writeLine("}");
            this.skipLine();
        }
    }

    private void createDeleteObjectList() {
        this.writeLine("/**");
        this.writeLine(" * delete object list");
        this.writeLine(" */");
        this.writeLine("@Override");
        this.writeLine("@Transactional(rollbackFor=Exception.class)");
        this.writeLine("public void deleteList(List<Long> idList) {");
        this.writeLine(this.bean.className + " " + this.bean.objectName + ";");
        this.writeLine("if (idList != null){");
        this.writeLine("for (Long id:idList){");
        this.writeLine(this.bean.objectName + " = " + this.bean.daoObjectName + ".load(id);");
        this.writeLine(this.bean.rightsManagerObjectName + ".checkCanDelete(" + this.bean.objectName + ");");
        this.writeLine(this.bean.stateManagerObjectName + ".checkCanDelete(" + this.bean.objectName + ");");
        this.writeLine(this.bean.processorObjectName + ".delete(" + this.bean.objectName + ");");
        this.writeLine("}");
        this.writeLine("}");
        this.writeLine("}");
        this.skipLine();
    }

    private void createDeleteOneToManyComponentList() {
        for (OneToManyComponent oneToManyComponent : this.bean.oneToManyComponentList) {
            Bean currentBean = oneToManyComponent.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * delete one to many component " + currentBean.objectName + " list");
            this.writeLine(" */");
            this.writeLine("@Override");
            this.writeLine("@Transactional(rollbackFor=Exception.class)");
            this.writeLine("public void delete" + currentBean.className + "List(List<Long> idList) {");
            this.writeLine(currentBean.className + " " + currentBean.objectName + ";");
            this.writeLine("if (idList != null){");
            this.writeLine("for (Long i:idList){");
            this.writeLine(currentBean.objectName + " = " + this.bean.daoObjectName + ".load" + currentBean.className + "(i);");
            this.writeLine(this.bean.rightsManagerObjectName + ".checkCanDelete" + currentBean.className + "(" + currentBean.objectName + ");");
            this.writeLine(this.bean.stateManagerObjectName + ".checkCanDelete" + currentBean.className + "(" + currentBean.objectName + ");");
            this.writeLine("this." + this.bean.processorObjectName + ".delete" + currentBean.className + "(" + currentBean.objectName + ");");
            this.writeLine("}");
            this.writeLine("}");
            this.writeLine("}");
            this.skipLine();
        }
    }
}

