/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.generator.skeletons.core.commands.population;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.sklsft.generator.model.domain.business.Bean;
import org.sklsft.generator.model.domain.business.OneToManyComponent;
import org.sklsft.generator.model.domain.ui.ViewProperty;
import org.sklsft.generator.skeletons.commands.impl.typed.JavaFileWriteCommand;

public class OneToManyComponentPopulatorCommandFileWriteCommand
extends JavaFileWriteCommand {
    private OneToManyComponent oneToManyComponent;
    private Bean referenceBean;
    private Bean parentBean;

    public OneToManyComponentPopulatorCommandFileWriteCommand(OneToManyComponent oneToManyComponent) {
        super(oneToManyComponent.referenceBean.myPackage.model.project.workspaceFolder + File.separator + oneToManyComponent.referenceBean.myPackage.model.project.projectName + "-populator" + File.separator + "src" + File.separator + "main" + File.separator + "java" + File.separator + oneToManyComponent.referenceBean.myPackage.commandPackageName.replace(".", File.separator), oneToManyComponent.referenceBean.className + "Command");
        this.oneToManyComponent = oneToManyComponent;
        this.referenceBean = oneToManyComponent.referenceBean;
        this.parentBean = oneToManyComponent.parentBean;
    }

    protected void fetchSpecificImports() {
        this.javaImports.add("import java.util.Arrays;");
        this.javaImports.add("import java.util.List;");
        this.javaImports.add("import java.util.Date;");
        this.javaImports.add("import java.math.BigDecimal;");
        this.javaImports.add("import org.sklsft.generator.repository.backup.command.interfaces.BackupArgumentsCommand;");
        this.javaImports.add("import org.sklsft.generator.repository.backup.reader.model.BackupArguments;");
        this.javaImports.add("import org.slf4j.Logger;");
        this.javaImports.add("import org.slf4j.LoggerFactory;");
        this.javaImports.add("import javax.inject.Inject;");
        this.javaImports.add("import org.springframework.stereotype.Component;");
        this.javaImports.add("import " + this.referenceBean.myPackage.fullViewsPackageName + "." + this.referenceBean.fullViewBean.className + ";");
        this.javaImports.add("import " + this.referenceBean.myPackage.formsPackageName + "." + this.referenceBean.formBean.className + ";");
        this.javaImports.add("import " + this.parentBean.myPackage.fullViewsPackageName + "." + this.parentBean.fullViewBean.className + ";");
        this.javaImports.add("import " + this.parentBean.myPackage.serviceInterfacePackageName + "." + this.parentBean.serviceInterfaceName + ";");
        this.javaImports.add("import org.sklsft.commons.mapper.impl.ObjectArrayToBeanMapperImpl;");
        this.javaImports.add("import org.sklsft.commons.mapper.impl.StringArrayToBeanMapperImpl;");
        this.javaImports.add("import org.sklsft.commons.mapper.interfaces.ObjectArrayToBeanMapper;");
        this.javaImports.add("import org.sklsft.commons.mapper.impl.StringToObjectConverter;");
    }

    protected void writeContent() throws IOException {
        this.writeLine("package " + this.oneToManyComponent.referenceBean.myPackage.commandPackageName + ";");
        this.skipLine();
        this.writeImports();
        this.skipLine();
        this.writeLine("/**");
        this.writeLine(" * auto generated view command class file");
        this.writeLine(" * <br/>no modification should be done to this file");
        this.writeLine(" * <br/>processed by skeleton-generator");
        this.writeLine(" */");
        this.writeLine("@Component");
        this.writeLine("public class " + this.oneToManyComponent.referenceBean.className + "Command implements BackupArgumentsCommand {");
        this.skipLine();
        this.writeLine("/*");
        this.writeLine(" * logger");
        this.writeLine(" */");
        this.writeLine("private static final Logger logger = LoggerFactory.getLogger(" + this.parentBean.serviceInterfaceName + ".class);");
        this.skipLine();
        this.writeLine("@Inject");
        this.writeLine("private " + this.oneToManyComponent.parentBean.serviceInterfaceName + " " + this.parentBean.serviceObjectName + ";");
        this.skipLine();
        this.writeLine("@Override");
        this.writeLine("public void execute(BackupArguments arguments) {");
        this.writeLine("ObjectArrayToBeanMapper<" + this.referenceBean.formBean.className + "> mapper;");
        this.writeLine("if (arguments.isArgumentsTyped()) {");
        this.writeLine("mapper = new ObjectArrayToBeanMapperImpl<" + this.referenceBean.formBean.className + ">(" + this.referenceBean.formBean.className + ".class);");
        this.writeLine("} else {");
        this.writeLine("mapper = new StringArrayToBeanMapperImpl<" + this.referenceBean.formBean.className + ">(" + this.referenceBean.formBean.className + ".class);");
        this.writeLine("}");
        this.writeLine("for (Object[] args:arguments.getArguments()) {");
        this.writeLine("String message = \"execute " + this.parentBean.serviceObjectName + ".save - args : " + '\"' + ";");
        this.writeLine("for (Object arg:args) {");
        this.writeLine("message += \"[\" + arg + \"]\";");
        this.writeLine("}");
        this.writeLine("logger.info(message);");
        this.skipLine();
        this.writeLine("try {");
        List properties = this.parentBean.referenceViewProperties;
        this.writeLine(this.referenceBean.formBean.className + " " + this.referenceBean.formBean.objectName + " = mapper.mapFrom(new " + this.referenceBean.formBean.className + "(), Arrays.copyOfRange(args," + properties.size() + ",args.length));");
        this.skipLine();
        int i = 0;
        for (ViewProperty property : properties) {
            String type = property.beanDataType;
            this.writeLine(type + " arg" + i + " = arguments.isArgumentsTyped()?(" + type + ")args[" + i + "]:(" + type + ")(StringToObjectConverter.getObjectFromString((String)args[" + i + "], " + type + ".class));");
            ++i;
        }
        this.write(this.parentBean.fullViewBean.className + " " + this.parentBean.fullViewBean.objectName + " = " + this.parentBean.serviceObjectName + ".find(arg0");
        for (i = 1; i < properties.size(); ++i) {
            this.write(", arg" + i);
        }
        this.writeLine(");");
        this.skipLine();
        this.writeLine("this." + this.parentBean.serviceObjectName + ".save" + this.referenceBean.className + "(" + this.parentBean.fullViewBean.objectName + ".getId(), " + this.referenceBean.formBean.objectName + ");");
        this.writeLine("} catch (Exception e) {");
        this.writeLine("logger.error(message + \"failed : \" + e.getClass().getSimpleName() + \" - \" + e.getMessage(), e);");
        this.writeLine("}");
        this.writeLine("}");
        this.writeLine("}");
        this.writeLine("}");
    }
}

