/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.generator.skeletons.core.commands.population;

import java.io.File;
import java.io.IOException;
import org.sklsft.generator.model.domain.business.Bean;
import org.sklsft.generator.skeletons.commands.impl.typed.JavaFileWriteCommand;

public class BeanPopulatorCommandFileWriteCommand
extends JavaFileWriteCommand {
    private Bean bean;

    public BeanPopulatorCommandFileWriteCommand(Bean bean) {
        super(bean.myPackage.model.project.workspaceFolder + File.separator + bean.myPackage.model.project.projectName + "-populator" + File.separator + "src" + File.separator + "main" + File.separator + "java" + File.separator + bean.myPackage.commandPackageName.replace(".", File.separator), bean.className + "Command");
        this.bean = bean;
    }

    protected void fetchSpecificImports() {
        this.javaImports.add("import java.util.List;");
        this.javaImports.add("import org.sklsft.generator.repository.backup.command.interfaces.BackupArgumentsCommand;");
        this.javaImports.add("import org.sklsft.generator.repository.backup.reader.model.BackupArguments;");
        this.javaImports.add("import org.slf4j.Logger;");
        this.javaImports.add("import org.slf4j.LoggerFactory;");
        this.javaImports.add("import javax.inject.Inject;");
        this.javaImports.add("import org.springframework.stereotype.Component;");
        this.javaImports.add("import " + this.bean.myPackage.formsPackageName + "." + this.bean.formBean.className + ";");
        this.javaImports.add("import " + this.bean.myPackage.serviceInterfacePackageName + "." + this.bean.serviceInterfaceName + ";");
        this.javaImports.add("import org.sklsft.commons.mapper.impl.ObjectArrayToBeanMapperImpl;");
        this.javaImports.add("import org.sklsft.commons.mapper.impl.StringArrayToBeanMapperImpl;");
        this.javaImports.add("import org.sklsft.commons.mapper.interfaces.ObjectArrayToBeanMapper;");
    }

    protected void writeContent() throws IOException {
        this.writeLine("package " + this.bean.myPackage.commandPackageName + ";");
        this.skipLine();
        this.writeImports();
        this.skipLine();
        this.writeLine("/**");
        this.writeLine(" * auto generated bean populator command class file");
        this.writeLine(" * <br/>no modification should be done to this file");
        this.writeLine(" * <br/>processed by skeleton-generator");
        this.writeLine(" */");
        this.writeLine("@Component");
        this.writeLine("public class " + this.bean.className + "Command implements BackupArgumentsCommand {");
        this.skipLine();
        this.writeLine("/*");
        this.writeLine(" * logger");
        this.writeLine(" */");
        this.writeLine("private static final Logger logger = LoggerFactory.getLogger(" + this.bean.serviceInterfaceName + ".class);");
        this.skipLine();
        this.writeLine("@Inject");
        this.writeLine("private " + this.bean.serviceInterfaceName + " " + this.bean.serviceObjectName + ";");
        this.skipLine();
        this.writeLine("@Override");
        this.writeLine("public void execute(BackupArguments arguments) {");
        this.writeLine("ObjectArrayToBeanMapper<" + this.bean.formBean.className + "> mapper;");
        this.writeLine("if (arguments.isArgumentsTyped()) {");
        this.writeLine("mapper = new ObjectArrayToBeanMapperImpl<" + this.bean.formBean.className + ">(" + this.bean.formBean.className + ".class);");
        this.writeLine("} else {");
        this.writeLine("mapper = new StringArrayToBeanMapperImpl<" + this.bean.formBean.className + ">(" + this.bean.formBean.className + ".class);");
        this.writeLine("}");
        this.writeLine("for (Object[] args : arguments.getArguments()) {");
        this.writeLine("String message = \"execute " + this.bean.serviceObjectName + ".save - args : " + '\"' + ";");
        this.writeLine("for (Object arg:args) {");
        this.writeLine("message += \"[\" + arg + \"]\";");
        this.writeLine("}");
        this.writeLine("logger.info(message);");
        this.skipLine();
        this.writeLine("try {");
        this.writeLine(this.bean.formBean.className + " " + this.bean.formBean.objectName + " = mapper.mapFrom(new " + this.bean.formBean.className + "(), args);");
        this.skipLine();
        this.writeLine("this." + this.bean.serviceObjectName + ".save(" + this.bean.formBean.objectName + ");");
        this.writeLine("} catch (Exception e) {");
        this.writeLine("logger.error(message + \"failed : \" + e.getClass().getSimpleName() + \" - \" + e.getMessage(), e);");
        this.writeLine("}");
        this.writeLine("}");
        this.writeLine("}");
        this.writeLine("}");
    }
}

