/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.generator.skeletons.core.commands.database.postgresql;

import java.io.File;
import java.io.IOException;
import org.sklsft.generator.model.domain.Project;
import org.sklsft.generator.model.domain.database.Column;
import org.sklsft.generator.model.domain.database.Table;
import org.sklsft.generator.skeletons.commands.impl.typed.SqlFileWriteCommand;

public class PostgresqlTableFkDefinitionFileWriteCommand
extends SqlFileWriteCommand {
    private Table table;

    public PostgresqlTableFkDefinitionFileWriteCommand(Table table) {
        super(table.myPackage.model.project.sourceFolder + File.separator + Project.BUILD_SCRIPT_FOLDER + File.separator + "2" + File.separator + table.myPackage.name.toUpperCase().replace(".", File.separator), table.originalName);
        this.table = table;
    }

    public void writeContent() throws IOException {
        this.createTableFks();
        this.writeNotOverridableContent();
    }

    private void createTableFks() {
        this.writeLine("-- table foreign keys and indexes --");
        int i = 0;
        for (Column column : this.table.columns) {
            if (column.referenceTable != null) {
                this.write("ALTER TABLE " + this.table.name + " ADD CONSTRAINT FK_" + this.table.name + "_" + i + " FOREIGN KEY (" + column.name + ") REFERENCES " + column.referenceTable.name);
                if (((Column)this.table.columns.get((int)i)).deleteCascade) {
                    this.write(" ON DELETE CASCADE");
                }
                this.writeLine(";");
                this.writeLine("/");
                this.skipLine();
            }
            ++i;
        }
        i = 0;
        for (Column column : this.table.columns) {
            if (column.referenceTable != null) {
                this.writeLine("CREATE INDEX FK_" + this.table.name + "_" + i + " ON " + this.table.name + "(" + column.name + ");");
                this.writeLine("/");
                this.skipLine();
            }
            ++i;
        }
    }
}

