/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.generator.skeletons.core.commands.database.postgresql;

import java.io.File;
import java.io.IOException;
import org.sklsft.generator.model.domain.Project;
import org.sklsft.generator.model.domain.database.Column;
import org.sklsft.generator.model.domain.database.Table;
import org.sklsft.generator.model.domain.database.UniqueConstraint;
import org.sklsft.generator.model.metadata.DataType;
import org.sklsft.generator.skeletons.commands.impl.typed.SqlFileWriteCommand;

public class PostgresqlTableDefinitionFileWriteCommand
extends SqlFileWriteCommand {
    private Table table;
    private String sequenceName;

    public PostgresqlTableDefinitionFileWriteCommand(Table table) {
        super(table.myPackage.model.project.sourceFolder + File.separator + Project.BUILD_SCRIPT_FOLDER + File.separator + "1" + File.separator + table.myPackage.name.toUpperCase().replace(".", File.separator), table.originalName);
        this.table = table;
        this.sequenceName = table.name + "_id_seq";
    }

    public void writeContent() throws IOException {
        this.createTable();
        this.createConstraints();
        if (this.table.myPackage.model.project.audited) {
            this.createAuditTable();
        }
        this.writeNotOverridableContent();
    }

    private void createTable() {
        this.writeLine("-- create table --");
        this.writeLine("CREATE TABLE " + this.table.name);
        this.writeLine("(");
        this.write("id " + this.getPostgresqlType(DataType.LONG));
        for (Column column : this.table.columns) {
            this.writeLine(",");
            this.write(column.name + " " + this.getPostgresqlType(column.dataType));
            if (column.nullable) {
                this.write(" NULL");
                continue;
            }
            this.write(" NOT NULL");
        }
        this.skipLine();
        this.writeLine(");");
        this.writeLine("/");
        this.skipLine();
        this.writeLine("ALTER TABLE " + this.table.name + " ADD CONSTRAINT PK_" + this.table.name + " PRIMARY KEY (ID);");
        this.writeLine("/");
        this.skipLine();
        this.writeLine("-- create sequence --");
        this.writeLine("CREATE SEQUENCE " + this.sequenceName);
        this.writeLine("INCREMENT 1");
        this.writeLine("MINVALUE 0");
        this.writeLine("MAXVALUE 9223372036854775807");
        this.writeLine("START 0");
        this.writeLine("CACHE 1;");
        this.writeLine("/");
        this.skipLine();
    }

    private void createConstraints() {
        if (this.table.cardinality > 0) {
            this.write("ALTER TABLE " + this.table.name + " ADD CONSTRAINT UC_" + this.table.name + " UNIQUE (" + ((Column)this.table.columns.get((int)0)).name);
            for (int i = 1; i < this.table.cardinality; ++i) {
                this.write("," + ((Column)this.table.columns.get((int)i)).name);
            }
            this.writeLine(");");
            this.writeLine("/");
            this.skipLine();
        }
        for (UniqueConstraint uniqueConstraint : this.table.uniqueConstraints) {
            this.write("ALTER TABLE " + this.table.name + " ADD CONSTRAINT UC_" + uniqueConstraint.name + " UNIQUE (" + ((Column)uniqueConstraint.columns.get((int)0)).name);
            for (int i = 1; i < uniqueConstraint.columns.size(); ++i) {
                this.write("," + ((Column)uniqueConstraint.columns.get((int)i)).name);
            }
            this.writeLine(");");
            this.writeLine("/");
            this.skipLine();
        }
    }

    private void createAuditTable() {
        this.writeLine("-- table d'audit des elements --");
        this.writeLine("CREATE TABLE " + this.table.name + "_aud");
        this.writeLine("(");
        this.writeLine("id integer NOT NULL,");
        this.writeLine("rev integer NOT NULL,");
        this.writeLine("revtype smallint NOT NULL,");
        for (Column column : this.table.columns) {
            this.writeLine(column.name + " " + this.getPostgresqlType(column.dataType) + " NULL,");
        }
        this.writeLine("CONSTRAINT " + this.table.name + "_aud_pkey PRIMARY KEY (id, rev),");
        this.writeLine("CONSTRAINT " + this.table.name + "_aud_rev FOREIGN KEY (rev)");
        this.writeLine("REFERENCES auditentity (id) MATCH SIMPLE");
        this.writeLine("ON UPDATE NO ACTION ON DELETE NO ACTION");
        this.writeLine(")");
        this.writeLine(";");
        this.skipLine();
    }

    public String getPostgresqlType(DataType type) {
        switch (type) {
            case TEXT: {
                return "TEXT";
            }
            case STRING: {
                return "VARCHAR(255)";
            }
            case LONG: {
                return "BIGINT";
            }
            case DOUBLE: {
                return "DOUBLE PRECISION";
            }
            case DATE: {
                return "DATE";
            }
            case DATETIME: {
                return "TIMESTAMP WITH TIME ZONE";
            }
            case BIG_DECIMAL: {
                return "NUMERIC";
            }
            case BOOLEAN: {
                return "BOOLEAN";
            }
        }
        throw new IllegalArgumentException("Unhandled data type " + type);
    }
}

