/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.generator.skeletons.core.commands.database.oracle;

import java.io.File;
import java.io.IOException;
import org.sklsft.generator.model.domain.Project;
import org.sklsft.generator.model.domain.database.Column;
import org.sklsft.generator.model.domain.database.Table;
import org.sklsft.generator.model.metadata.DataType;
import org.sklsft.generator.skeletons.commands.impl.typed.SqlFileWriteCommand;

public class OracleTableDefinitionFileWriteCommand
extends SqlFileWriteCommand {
    private Table table;
    private String sequenceName;

    public OracleTableDefinitionFileWriteCommand(Table table) {
        super(table.myPackage.model.project.sourceFolder + File.separator + Project.BUILD_SCRIPT_FOLDER + File.separator + "1" + File.separator + table.myPackage.name.toUpperCase().replace(".", File.separator), table.originalName);
        this.table = table;
        this.sequenceName = table.name + "_id_seq";
    }

    public void writeContent() throws IOException {
        this.createTable();
        if (this.table.myPackage.model.project.audited) {
            this.createAuditTable();
        }
        this.writeNotOverridableContent();
        this.skipLine();
    }

    private void createTable() {
        int i;
        this.writeLine("-- drop table --");
        this.writeLine("BEGIN");
        this.writeLine("EXECUTE IMMEDIATE 'DROP TABLE " + this.table.name + "';");
        this.writeLine("EXCEPTION");
        this.writeLine("WHEN OTHERS THEN NULL;");
        this.writeLine("END;");
        this.writeLine("/");
        this.skipLine();
        this.writeLine("-- create table --");
        this.writeLine("CREATE TABLE " + this.table.name);
        this.writeLine("(");
        this.write("ID " + this.getOracleType(DataType.LONG));
        for (Column column : this.table.columns) {
            this.writeLine(",");
            this.write(column.name + " " + this.getOracleType(column.dataType));
            if (column.nullable) {
                this.write(" NULL");
                continue;
            }
            this.write(" NOT NULL");
        }
        this.writeLine(",");
        this.write("CONSTRAINT UC_" + this.table.name + " UNIQUE (" + ((Column)this.table.columns.get((int)0)).name);
        for (i = 1; i < this.table.cardinality; ++i) {
            this.write("," + ((Column)this.table.columns.get((int)i)).name);
        }
        this.writeLine(")");
        this.write("USING INDEX (CREATE INDEX UC_" + this.table.name + " ON " + this.table.name + "(" + ((Column)this.table.columns.get((int)0)).name);
        for (i = 1; i < this.table.cardinality; ++i) {
            this.write("," + ((Column)this.table.columns.get((int)i)).name);
        }
        this.writeLine(") TABLESPACE " + this.table.myPackage.model.project.databaseName + "_IND)");
        this.writeLine(", CONSTRAINT PK_" + this.table.name + " PRIMARY KEY (ID)");
        this.writeLine("USING INDEX (CREATE INDEX PK_" + this.table.name + " ON " + this.table.name + "(ID) TABLESPACE " + this.table.myPackage.model.project.databaseName + "_IND)");
        this.writeLine(") TABLESPACE " + this.table.myPackage.model.project.databaseName + "_TBL");
        this.writeLine("/");
        this.skipLine();
        this.writeLine("-- drop sequence --");
        this.writeLine("BEGIN");
        this.writeLine("EXECUTE IMMEDIATE 'DROP SEQUENCE " + this.sequenceName + "';");
        this.writeLine("EXCEPTION");
        this.writeLine("WHEN OTHERS THEN NULL;");
        this.writeLine("END;");
        this.writeLine("/");
        this.skipLine();
        this.writeLine("-- create sequence --");
        this.writeLine("CREATE SEQUENCE " + this.sequenceName + " MINVALUE 0 NOMAXVALUE START WITH 0 INCREMENT BY 1 NOCYCLE");
        this.writeLine("/");
        this.skipLine();
    }

    private void createAuditTable() {
        this.writeLine("-- drop audit table --");
        this.writeLine("BEGIN");
        this.writeLine("EXECUTE IMMEDIATE 'DROP TABLE " + this.table.name + "_AUD';");
        this.writeLine("EXCEPTION");
        this.writeLine("WHEN OTHERS THEN NULL;");
        this.writeLine("END;");
        this.writeLine("/");
        this.skipLine();
        this.writeLine("-- create audit table --");
        this.writeLine("CREATE TABLE " + this.table.name + "_AUD");
        this.writeLine("(");
        this.writeLine("ID int NOT NULL,");
        this.writeLine("REV int NOT NULL,");
        this.writeLine("REVTYPE smallint NOT NULL,");
        for (Column column : this.table.columns) {
            this.writeLine(column.name + " " + this.getOracleType(column.dataType) + " NULL,");
        }
        this.writeLine("CONSTRAINT PK_" + this.table.name + "_AUD PRIMARY KEY (ID, REV),");
        this.writeLine("CONSTRAINT FK_" + this.table.name + "_AUD FOREIGN KEY (REV)");
        this.writeLine("REFERENCES AUDITENTITY (ID)");
        this.writeLine(") TABLESPACE " + this.table.myPackage.model.project.databaseName + "_AUD");
        this.writeLine("/");
        this.skipLine();
        this.writeLine("CREATE INDEX FK_" + this.table.name + "_AUD ON " + this.table.name + "_AUD(REV)");
        this.writeLine("/");
        this.skipLine();
    }

    private String getOracleType(DataType type) {
        switch (type) {
            case TEXT: {
                return "CLOB";
            }
            case STRING: {
                return "VARCHAR2(255)";
            }
            case LONG: {
                return "NUMBER(19,0)";
            }
            case DOUBLE: {
                return "FLOAT(24)";
            }
            case BIG_DECIMAL: {
                return "NUMERIC";
            }
            case DATE: {
                return "DATE";
            }
            case DATETIME: {
                return "TIMESTAMP WITH TIME ZONE";
            }
            case BOOLEAN: {
                return "NUMBER(1,0)";
            }
        }
        throw new IllegalArgumentException("Unhandled data type " + (Object)((Object)this));
    }
}

