/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.generator.skeletons.core.commands.dao;

import java.io.File;
import java.io.IOException;
import org.sklsft.generator.model.domain.business.Bean;
import org.sklsft.generator.model.domain.business.OneToManyComponent;
import org.sklsft.generator.model.domain.business.OneToOneComponent;
import org.sklsft.generator.model.domain.business.Property;
import org.sklsft.generator.model.domain.ui.ViewProperty;
import org.sklsft.generator.model.metadata.RelationType;
import org.sklsft.generator.model.metadata.SelectionMode;
import org.sklsft.generator.skeletons.commands.impl.typed.JavaFileWriteCommand;

public class BaseDaoInterfaceFileWriteCommand
extends JavaFileWriteCommand {
    private Bean bean;

    public BaseDaoInterfaceFileWriteCommand(Bean bean) {
        super(bean.myPackage.model.project.workspaceFolder + File.separator + bean.myPackage.model.project.projectName + "-repository" + File.separator + "src" + File.separator + "main" + File.separator + "java" + File.separator + bean.myPackage.baseDAOInterfacePackageName.replace(".", File.separator), bean.baseDaoInterfaceName);
        this.bean = bean;
    }

    protected void fetchSpecificImports() {
        Bean currentBean;
        this.javaImports.add("import java.util.List;");
        this.javaImports.add("import java.util.Date;");
        this.javaImports.add("import java.math.BigDecimal;");
        this.javaImports.add("import org.sklsft.commons.model.patterns.BaseDao;");
        this.javaImports.add("import " + this.bean.myPackage.omPackageName + "." + this.bean.className + ";");
        this.javaImports.add("import " + this.bean.myPackage.filtersPackageName + "." + this.bean.basicViewBean.filterClassName + ";");
        this.javaImports.add("import " + this.bean.myPackage.sortingsPackageName + "." + this.bean.basicViewBean.sortingClassName + ";");
        for (OneToManyComponent oneToManyComponent : this.bean.oneToManyComponentList) {
            currentBean = oneToManyComponent.referenceBean;
            this.javaImports.add("import " + currentBean.myPackage.omPackageName + "." + currentBean.className + ";");
            this.javaImports.add("import " + currentBean.myPackage.filtersPackageName + "." + currentBean.basicViewBean.filterClassName + ";");
            this.javaImports.add("import " + currentBean.myPackage.sortingsPackageName + "." + currentBean.basicViewBean.sortingClassName + ";");
        }
        for (OneToOneComponent oneToOneComponent : this.bean.oneToOneComponentList) {
            currentBean = oneToOneComponent.referenceBean;
            this.javaImports.add("import " + currentBean.myPackage.omPackageName + "." + currentBean.className + ";");
        }
    }

    protected void writeContent() throws IOException {
        this.writeLine("package " + this.bean.myPackage.baseDAOInterfacePackageName + ";");
        this.writeImports();
        this.writeLine("/**");
        this.writeLine(" * auto generated base dao interface file");
        this.writeLine(" * <br/>no modification should be done to this file");
        this.writeLine(" * <br/>processed by skeleton-generator");
        this.writeLine(" */");
        this.writeLine("public interface " + this.bean.baseDaoInterfaceName + " extends BaseDao<" + this.bean.className + ", Long> {");
        this.skipLine();
        this.createLoadObjectList();
        this.createCount();
        this.createScroll();
        this.createLoadOneToManyComponentList();
        this.createCountOneToManyComponent();
        this.createScrollOneToManyComponent();
        this.createLoadOneToManyComponent();
        if (this.bean.cardinality > 0) {
            this.createExistsObject();
            this.createFindObject();
        }
        if (this.bean.selectable && this.bean.selectionBehavior.selectionMode.equals((Object)SelectionMode.AUTO_COMPLETE)) {
            this.createSearch();
        }
        this.createSaveComponent();
        this.createDeleteComponent();
        this.writeLine("}");
    }

    private void createLoadObjectList() {
        for (Property property : this.bean.properties) {
            if (property.referenceBean == null || !property.relation.equals((Object)RelationType.MANY_TO_ONE)) continue;
            this.writeLine("/**");
            this.writeLine(" * load object list from " + property.referenceBean.objectName);
            this.writeLine(" */");
            this.writeLine("List<" + this.bean.className + "> loadListFrom" + property.capName + "(Long " + property.name + "Id);");
            this.skipLine();
            this.writeLine("/**");
            this.writeLine(" * load object list eagerly from " + property.referenceBean.objectName);
            this.writeLine(" */");
            this.writeLine("List<" + this.bean.className + "> loadListEagerlyFrom" + property.capName + "(Long " + property.name + "Id);");
            this.skipLine();
        }
    }

    private void createCount() {
        this.writeLine("/**");
        this.writeLine(" * count filtered object list");
        this.writeLine(" */");
        this.writeLine("Long count(" + this.bean.basicViewBean.filterClassName + " filter);");
        this.skipLine();
        for (Property property : this.bean.properties) {
            if (property.referenceBean == null || !property.relation.equals((Object)RelationType.MANY_TO_ONE)) continue;
            this.writeLine("/**");
            this.writeLine(" * count object list from " + property.referenceBean.objectName);
            this.writeLine(" */");
            this.writeLine("Long countFrom" + property.capName + "(Long " + property.name + "Id);");
            this.skipLine();
            this.writeLine("/**");
            this.writeLine(" * count filtered object list from " + property.referenceBean.objectName);
            this.writeLine(" */");
            this.writeLine("Long countFrom" + property.capName + "(Long " + property.name + "Id, " + this.bean.basicViewBean.filterClassName + " filter);");
            this.skipLine();
        }
    }

    private void createScroll() {
        this.writeLine("/**");
        this.writeLine(" * scroll filtered object list");
        this.writeLine(" */");
        this.writeLine("List<" + this.bean.className + "> scroll(" + this.bean.basicViewBean.filterClassName + " filter, " + this.bean.basicViewBean.sortingClassName + " sorting, Long firstResult, Long maxResults);");
        this.skipLine();
        for (Property property : this.bean.properties) {
            if (property.referenceBean == null || !property.relation.equals((Object)RelationType.MANY_TO_ONE)) continue;
            this.writeLine("/**");
            this.writeLine(" * scroll filtered object from " + property.referenceBean.objectName);
            this.writeLine(" */");
            this.writeLine("List<" + this.bean.className + "> scrollFrom" + property.capName + "(Long " + property.name + "Id, " + this.bean.basicViewBean.filterClassName + " filter, " + this.bean.basicViewBean.sortingClassName + " sorting, Long firstResult, Long maxResults);");
            this.skipLine();
        }
    }

    private void createLoadOneToManyComponentList() {
        for (OneToManyComponent oneToManyComponent : this.bean.oneToManyComponentList) {
            Bean currentBean = oneToManyComponent.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * load one to many component " + currentBean.className + " list");
            this.writeLine(" */");
            this.writeLine("List<" + currentBean.className + "> load" + currentBean.className + "List(Long " + this.bean.objectName + "Id);");
            this.skipLine();
        }
    }

    private void createCountOneToManyComponent() {
        for (OneToManyComponent oneToManyComponent : this.bean.oneToManyComponentList) {
            Bean currentBean = oneToManyComponent.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * count one to many component " + currentBean.className);
            this.writeLine(" */");
            this.writeLine("Long count" + currentBean.className + "(Long " + this.bean.objectName + "Id);");
            this.skipLine();
            this.writeLine("/**");
            this.writeLine(" * count filtered one to many component " + currentBean.className);
            this.writeLine(" */");
            this.writeLine("Long count" + currentBean.className + "(Long " + this.bean.objectName + "Id, " + currentBean.basicViewBean.filterClassName + " filter);");
            this.skipLine();
        }
    }

    private void createScrollOneToManyComponent() {
        for (OneToManyComponent oneToManyComponent : this.bean.oneToManyComponentList) {
            Bean currentBean = oneToManyComponent.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * scroll filtered one to many component " + currentBean.className);
            this.writeLine(" */");
            this.writeLine("List<" + currentBean.className + "> scroll" + currentBean.className + "(Long " + this.bean.objectName + "Id, " + currentBean.basicViewBean.filterClassName + " filter, " + currentBean.basicViewBean.sortingClassName + " sorting, Long firstResult, Long maxResults);");
            this.skipLine();
        }
    }

    private void createLoadOneToManyComponent() {
        for (OneToManyComponent oneToManyComponent : this.bean.oneToManyComponentList) {
            Bean currentBean = oneToManyComponent.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * load one to many component " + currentBean.className);
            this.writeLine(" */");
            this.writeLine(currentBean.className + " load" + currentBean.className + "(Long id);");
            this.skipLine();
        }
    }

    private void createExistsObject() {
        boolean start = true;
        this.writeLine("/**");
        this.writeLine(" * exists object");
        this.writeLine(" */");
        this.write("boolean exists(");
        for (ViewProperty property : this.bean.referenceViewProperties) {
            if (start) {
                start = false;
            } else {
                this.write(", ");
            }
            this.write(property.beanDataType + " " + property.name);
        }
        this.writeLine(");");
        this.skipLine();
    }

    private void createFindObject() {
        boolean start = true;
        this.writeLine("/**");
        this.writeLine(" * find object or null");
        this.writeLine(" */");
        this.write(this.bean.className + " findOrNull(");
        for (ViewProperty property : this.bean.referenceViewProperties) {
            if (start) {
                start = false;
            } else {
                this.write(", ");
            }
            this.write(property.beanDataType + " " + property.name);
        }
        this.writeLine(");");
        this.skipLine();
        start = true;
        this.writeLine("/**");
        this.writeLine(" * find object");
        this.writeLine(" */");
        this.write(this.bean.className + " find(");
        for (ViewProperty property : this.bean.referenceViewProperties) {
            if (start) {
                start = false;
            } else {
                this.write(", ");
            }
            this.write(property.beanDataType + " " + property.name);
        }
        this.writeLine(");");
        this.skipLine();
    }

    private void createSearch() {
        this.writeLine("/**");
        this.writeLine(" * search");
        this.writeLine(" */");
        this.writeLine("List<" + this.bean.className + "> search(String arg);");
        this.skipLine();
    }

    private void createSaveComponent() {
        Bean currentBean;
        for (OneToManyComponent oneToManyComponent : this.bean.oneToManyComponentList) {
            currentBean = oneToManyComponent.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * save one to many component " + currentBean.className);
            this.writeLine(" */");
            this.writeLine("void save" + currentBean.className + "(" + this.bean.className + " " + this.bean.objectName + ", " + currentBean.className + " " + currentBean.objectName + ");");
            this.skipLine();
        }
        for (OneToOneComponent oneToOneComponent : this.bean.oneToOneComponentList) {
            currentBean = oneToOneComponent.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * save one to one component " + currentBean.className);
            this.writeLine(" */");
            this.writeLine("void save" + currentBean.className + "(" + this.bean.className + " " + this.bean.objectName + ", " + currentBean.className + " " + currentBean.objectName + ");");
            this.skipLine();
        }
    }

    private void createDeleteComponent() {
        Bean currentBean;
        for (OneToManyComponent oneToManyComponent : this.bean.oneToManyComponentList) {
            currentBean = oneToManyComponent.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * delete one to many component " + currentBean.className);
            this.writeLine(" */");
            this.writeLine("void delete" + currentBean.className + "(" + currentBean.className + " " + currentBean.objectName + ");");
            this.skipLine();
        }
        for (OneToOneComponent oneToOneComponent : this.bean.oneToOneComponentList) {
            currentBean = oneToOneComponent.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * delete one to one component " + currentBean.className);
            this.writeLine(" */");
            this.writeLine("void delete" + currentBean.className + "(" + currentBean.className + " " + currentBean.objectName + ");");
            this.skipLine();
        }
    }
}

