/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.generator.skeletons.core.commands.dao;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.sklsft.generator.model.domain.business.Bean;
import org.sklsft.generator.model.domain.business.OneToManyComponent;
import org.sklsft.generator.model.domain.business.OneToOneComponent;
import org.sklsft.generator.model.domain.business.Property;
import org.sklsft.generator.model.domain.ui.ViewProperty;
import org.sklsft.generator.model.metadata.RelationType;
import org.sklsft.generator.model.metadata.SelectionMode;
import org.sklsft.generator.skeletons.commands.impl.typed.JavaFileWriteCommand;
import org.sklsft.generator.util.naming.JavaClassNaming;

public class BaseDaoHibernateImplFileWriteCommand
extends JavaFileWriteCommand {
    private Bean bean;

    public BaseDaoHibernateImplFileWriteCommand(Bean bean) {
        super(bean.myPackage.model.project.workspaceFolder + File.separator + bean.myPackage.model.project.projectName + "-repository" + File.separator + "src" + File.separator + "main" + File.separator + "java" + File.separator + bean.myPackage.baseDAOImplPackageName.replace(".", File.separator), bean.baseDaoClassName);
        this.bean = bean;
    }

    protected void fetchSpecificImports() {
        Bean currentBean;
        this.javaImports.add("import static org.sklsft.commons.model.patterns.HibernateCriteriaUtils.*;");
        this.javaImports.add("import java.util.Date;");
        this.javaImports.add("import java.math.BigDecimal;");
        this.javaImports.add("import java.util.List;");
        this.javaImports.add("import org.hibernate.criterion.Projections;");
        this.javaImports.add("import org.hibernate.criterion.Restrictions;");
        this.javaImports.add("import org.hibernate.Criteria;");
        this.javaImports.add("import org.hibernate.criterion.Order;");
        this.javaImports.add("import org.sklsft.commons.api.model.OrderType;");
        this.javaImports.add("import org.hibernate.sql.JoinType;");
        this.javaImports.add("import org.hibernate.FetchMode;");
        this.javaImports.add("import org.sklsft.commons.api.exception.repository.ObjectNotFoundException;");
        this.javaImports.add("import org.springframework.stereotype.Repository;");
        this.javaImports.add("import org.sklsft.commons.model.patterns.BaseDaoImpl;");
        this.javaImports.add("import " + this.bean.myPackage.omPackageName + "." + this.bean.className + ";");
        this.javaImports.add("import " + this.bean.myPackage.filtersPackageName + "." + this.bean.basicViewBean.filterClassName + ";");
        this.javaImports.add("import " + this.bean.myPackage.sortingsPackageName + "." + this.bean.basicViewBean.sortingClassName + ";");
        this.javaImports.add("import " + this.bean.myPackage.baseDAOInterfacePackageName + "." + this.bean.baseDaoInterfaceName + ";");
        for (OneToManyComponent oneToManyComponent : this.bean.oneToManyComponentList) {
            currentBean = oneToManyComponent.referenceBean;
            this.javaImports.add("import " + currentBean.myPackage.omPackageName + "." + currentBean.className + ";");
            this.javaImports.add("import " + currentBean.myPackage.filtersPackageName + "." + currentBean.basicViewBean.filterClassName + ";");
            this.javaImports.add("import " + currentBean.myPackage.sortingsPackageName + "." + currentBean.basicViewBean.sortingClassName + ";");
        }
        for (OneToOneComponent oneToOneComponent : this.bean.oneToOneComponentList) {
            currentBean = oneToOneComponent.referenceBean;
            this.javaImports.add("import " + currentBean.myPackage.omPackageName + "." + currentBean.className + ";");
        }
    }

    protected void writeContent() throws IOException {
        this.writeLine("package " + this.bean.myPackage.baseDAOImplPackageName + ";");
        this.skipLine();
        this.writeImports();
        this.skipLine();
        this.writeLine("/**");
        this.writeLine(" * auto generated base dao class file");
        this.writeLine(" * <br/>no modification should be done to this file");
        this.writeLine(" * <br/>processed by skeleton-generator");
        this.writeLine(" */");
        this.writeLine("public class " + this.bean.baseDaoClassName + " extends BaseDaoImpl<" + this.bean.className + ", Long> implements " + this.bean.baseDaoInterfaceName + " {");
        this.skipLine();
        this.writeLine("/**");
        this.writeLine(" * constructor");
        this.writeLine(" */");
        this.writeLine("public " + this.bean.baseDaoClassName + "() {");
        this.writeLine("super(" + this.bean.className + ".class);");
        this.write("}");
        this.skipLine();
        this.createLoadObjectList();
        this.createCount();
        this.createScroll();
        this.createLoadOneToManyComponentList();
        this.createCountOneToManyComponent();
        this.createScrollOneToManyComponent();
        this.createLoadOneToManyComponent();
        if (this.bean.cardinality > 0) {
            this.createExistsObject();
            this.createFindObject();
        }
        if (this.bean.selectable && this.bean.selectionBehavior.selectionMode.equals((Object)SelectionMode.AUTO_COMPLETE)) {
            this.createSearch();
        }
        this.createSaveComponent();
        this.createDeleteComponent();
        this.write("}");
    }

    private void createLoadObjectList() {
        this.writeLine("/**");
        this.writeLine(" * load object list eagerly");
        this.writeLine(" */");
        this.writeLine("@Override");
        this.writeLine("@SuppressWarnings(\"unchecked\")");
        this.writeLine("public List<" + this.bean.className + "> loadListEagerly() {");
        this.writeLine("Criteria criteria = this.sessionFactory.getCurrentSession().createCriteria(" + this.bean.className + ".class);");
        for (Property property : this.bean.properties) {
            if (!property.visibility.isListVisible() || property.referenceBean == null) continue;
            this.writeLine("criteria.setFetchMode(\"" + property.name + '\"' + ",FetchMode.JOIN);");
            for (Alias alias : this.getAliases(property)) {
                this.writeLine("criteria.setFetchMode(\"" + property.name + "." + alias.propertyPath + '\"' + ",FetchMode.JOIN);");
            }
        }
        this.writeLine("return criteria.list();");
        this.writeLine("}");
        this.skipLine();
        for (Property property : this.bean.properties) {
            if (property.referenceBean == null || !property.relation.equals((Object)RelationType.MANY_TO_ONE)) continue;
            this.writeLine("/**");
            this.writeLine(" * load object list from " + property.name);
            this.writeLine(" */");
            this.writeLine("@Override");
            this.writeLine("@SuppressWarnings(\"unchecked\")");
            this.writeLine("public List<" + this.bean.className + "> loadListFrom" + property.capName + "(Long " + property.name + "Id) {");
            this.writeLine("Criteria criteria = this.sessionFactory.getCurrentSession().createCriteria(" + this.bean.className + ".class);");
            this.writeLine("if (" + property.name + "Id == null){");
            this.writeLine("criteria.add(Restrictions.isNull(\"" + property.name + ".id" + '\"' + "));");
            this.writeLine("} else {");
            this.writeLine("criteria.add(Restrictions.eq(\"" + property.name + ".id" + '\"' + ", " + property.name + "Id));");
            this.writeLine("}");
            this.writeLine("return criteria.list();");
            this.writeLine("}");
            this.skipLine();
            this.writeLine("/**");
            this.writeLine(" * load object list eagerly from " + property.name);
            this.writeLine(" */");
            this.writeLine("@Override");
            this.writeLine("@SuppressWarnings(\"unchecked\")");
            this.writeLine("public List<" + this.bean.className + "> loadListEagerlyFrom" + property.capName + "(Long " + property.name + "Id) {");
            this.writeLine("Criteria criteria = this.sessionFactory.getCurrentSession().createCriteria(" + this.bean.className + ".class);");
            this.writeLine("if (" + property.name + "Id == null){");
            this.writeLine("criteria.add(Restrictions.isNull(\"" + property.name + ".id" + '\"' + "));");
            this.writeLine("} else {");
            this.writeLine("criteria.add(Restrictions.eq(\"" + property.name + ".id" + '\"' + ", " + property.name + "Id));");
            this.writeLine("}");
            for (Property prop : this.bean.properties) {
                if (prop.referenceBean == null) continue;
                this.writeLine("criteria.setFetchMode(\"" + prop.name + '\"' + ",FetchMode.JOIN);");
                for (Alias alias : this.getReferenceAliases(prop.referenceBean)) {
                    this.writeLine("criteria.setFetchMode(\"" + prop.name + "." + alias.propertyPath + '\"' + ",FetchMode.JOIN);");
                }
            }
            this.writeLine("return criteria.list();");
            this.writeLine("}");
            this.skipLine();
        }
    }

    private void createCount() {
        this.writeLine("/**");
        this.writeLine(" * count filtered object list");
        this.writeLine(" */");
        this.writeLine("@Override");
        this.writeLine("public Long count(" + this.bean.basicViewBean.filterClassName + " filter) {");
        this.writeLine("Criteria criteria = this.sessionFactory.getCurrentSession().createCriteria(" + this.bean.className + ".class).setProjection(Projections.rowCount());");
        List<Alias> aliases = this.getAllAliases(this.bean);
        for (Alias alias : aliases) {
            this.writeLine("Criteria " + alias.name + "Criteria = " + (alias.parentName != null ? alias.parentName + "Criteria" : "criteria") + ".createCriteria(" + '\"' + alias.propertyName + '\"' + ", JoinType.LEFT_OUTER_JOIN);");
        }
        for (ViewProperty property : this.bean.basicViewBean.properties) {
            this.writeRestriction(property);
        }
        this.writeLine("return (Long) criteria.uniqueResult();");
        this.writeLine("}");
        this.skipLine();
        for (ViewProperty property : this.bean.properties) {
            if (property.referenceBean == null || !property.relation.equals((Object)RelationType.MANY_TO_ONE)) continue;
            this.writeLine("/**");
            this.writeLine(" * count object list from " + property.referenceBean.objectName);
            this.writeLine(" */");
            this.writeLine("public Long countFrom" + property.capName + "(Long " + property.name + "Id) {");
            this.writeLine("Criteria criteria = this.sessionFactory.getCurrentSession().createCriteria(" + this.bean.className + ".class).setProjection(Projections.rowCount());");
            this.writeLine("if (" + property.name + "Id == null){");
            this.writeLine("criteria.add(Restrictions.isNull(\"" + property.name + ".id" + '\"' + "));");
            this.writeLine("} else {");
            this.writeLine("criteria.add(Restrictions.eq(\"" + property.name + ".id" + '\"' + ", " + property.name + "Id));");
            this.writeLine("}");
            this.writeLine("return (Long) criteria.uniqueResult();");
            this.writeLine("}");
            this.skipLine();
            this.writeLine("/**");
            this.writeLine(" * count filtered object list from " + property.referenceBean.objectName);
            this.writeLine(" */");
            this.writeLine("public Long countFrom" + property.capName + "(Long " + property.name + "Id, " + this.bean.basicViewBean.filterClassName + " filter) {");
            this.writeLine("Criteria criteria = this.sessionFactory.getCurrentSession().createCriteria(" + this.bean.className + ".class).setProjection(Projections.rowCount());");
            this.writeLine("if (" + property.name + "Id == null){");
            this.writeLine("criteria.add(Restrictions.isNull(\"" + property.name + ".id" + '\"' + "));");
            this.writeLine("} else {");
            this.writeLine("criteria.add(Restrictions.eq(\"" + property.name + ".id" + '\"' + ", " + property.name + "Id));");
            this.writeLine("}");
            aliases = this.getAllAliases(this.bean);
            for (Alias alias : aliases) {
                this.writeLine("Criteria " + alias.name + "Criteria = " + (alias.parentName != null ? alias.parentName + "Criteria" : "criteria") + ".createCriteria(" + '\"' + alias.propertyName + '\"' + ", JoinType.LEFT_OUTER_JOIN);");
            }
            for (ViewProperty viewProperty : this.bean.basicViewBean.properties) {
                this.writeRestriction(viewProperty);
            }
            this.writeLine("return (Long) criteria.uniqueResult();");
            this.writeLine("}");
            this.skipLine();
        }
    }

    private void createScroll() {
        this.writeLine("/**");
        this.writeLine(" * scroll filtered object list");
        this.writeLine(" */");
        this.writeLine("@Override");
        this.writeLine("@SuppressWarnings(\"unchecked\")");
        this.writeLine("public List<" + this.bean.className + "> scroll(" + this.bean.basicViewBean.filterClassName + " filter, " + this.bean.basicViewBean.sortingClassName + " sorting, Long firstResult, Long maxResults) {");
        this.writeLine("Criteria criteria = this.sessionFactory.getCurrentSession().createCriteria(" + this.bean.className + ".class);");
        List<Alias> aliases = this.getAllAliases(this.bean);
        for (Alias alias : aliases) {
            this.writeLine("Criteria " + alias.name + "Criteria = " + (alias.parentName != null ? alias.parentName + "Criteria" : "criteria") + ".createCriteria(" + '\"' + alias.propertyName + '\"' + ", JoinType.LEFT_OUTER_JOIN);");
        }
        for (ViewProperty property : this.bean.basicViewBean.properties) {
            this.writeRestriction(property);
        }
        for (ViewProperty property : this.bean.basicViewBean.properties) {
            String propertyCriteria = StringUtils.isEmpty((String)property.joinedAliasName) ? "criteria" : property.joinedAliasName + "Criteria";
            this.writeLine("addOrder(" + propertyCriteria + ", " + '\"' + property.lastPropertyName + '\"' + ", sorting.get" + property.capName + "OrderType());");
        }
        this.writeLine("if (firstResult != null){");
        this.writeLine("criteria.setFirstResult(firstResult.intValue());");
        this.writeLine("}");
        this.writeLine("if (maxResults != null){");
        this.writeLine("criteria.setMaxResults(maxResults.intValue());");
        this.writeLine("}");
        this.writeLine("return criteria.list();");
        this.writeLine("}");
        this.skipLine();
        for (ViewProperty property : this.bean.properties) {
            if (property.referenceBean == null || !property.relation.equals((Object)RelationType.MANY_TO_ONE)) continue;
            this.writeLine("/**");
            this.writeLine(" * scroll filtered object list from " + property.referenceBean.objectName);
            this.writeLine(" */");
            this.writeLine("@Override");
            this.writeLine("@SuppressWarnings(\"unchecked\")");
            this.writeLine("public List<" + this.bean.className + "> scrollFrom" + property.capName + "(Long " + property.name + "Id, " + this.bean.basicViewBean.filterClassName + " filter, " + this.bean.basicViewBean.sortingClassName + " sorting, Long firstResult, Long maxResults) {");
            this.writeLine("Criteria criteria = this.sessionFactory.getCurrentSession().createCriteria(" + this.bean.className + ".class);");
            this.writeLine("if (" + property.name + "Id == null){");
            this.writeLine("criteria.add(Restrictions.isNull(\"" + property.name + ".id" + '\"' + "));");
            this.writeLine("} else {");
            this.writeLine("criteria.add(Restrictions.eq(\"" + property.name + ".id" + '\"' + ", " + property.name + "Id));");
            this.writeLine("}");
            aliases = this.getAllAliases(this.bean);
            for (Alias alias : aliases) {
                this.writeLine("Criteria " + alias.name + "Criteria = " + (alias.parentName != null ? alias.parentName + "Criteria" : "criteria") + ".createCriteria(" + '\"' + alias.propertyName + '\"' + ", JoinType.LEFT_OUTER_JOIN);");
            }
            for (ViewProperty viewProperty : this.bean.basicViewBean.properties) {
                this.writeRestriction(viewProperty);
            }
            for (ViewProperty viewProperty : this.bean.basicViewBean.properties) {
                String propertyCriteria = StringUtils.isEmpty((String)viewProperty.joinedAliasName) ? "criteria" : viewProperty.joinedAliasName + "Criteria";
                this.writeLine("addOrder(" + propertyCriteria + ", " + '\"' + viewProperty.lastPropertyName + '\"' + ", sorting.get" + viewProperty.capName + "OrderType());");
            }
            this.writeLine("if (firstResult != null){");
            this.writeLine("criteria.setFirstResult(firstResult.intValue());");
            this.writeLine("}");
            this.writeLine("if (maxResults != null){");
            this.writeLine("criteria.setMaxResults(maxResults.intValue());");
            this.writeLine("}");
            this.writeLine("return criteria.list();");
            this.writeLine("}");
            this.skipLine();
        }
    }

    private void writeRestriction(ViewProperty property) {
        switch (property.dataType) {
            case BOOLEAN: {
                this.writeBooleanRestriction(property);
                return;
            }
            case LONG: {
                this.writeLongRestriction(property);
                return;
            }
            case DATE: {
                this.writeDateRestriction(property);
                return;
            }
            case DATETIME: {
                this.writeDateTimeRestriction(property);
                return;
            }
            case DOUBLE: {
                this.writeDoubleRestriction(property);
                return;
            }
            case BIG_DECIMAL: {
                this.writeBigDecimalRestriction(property);
                return;
            }
            case STRING: 
            case TEXT: {
                this.writeTextRestriction(property);
                return;
            }
        }
    }

    private void writeTextRestriction(ViewProperty property) {
        String propertyPath = "\"{alias}." + property.lastColumnName + '\"';
        String propertyCriteria = StringUtils.isEmpty((String)property.joinedAliasName) ? "criteria" : property.joinedAliasName + "Criteria";
        this.writeLine("addStringContainsRestriction(" + propertyCriteria + ", " + propertyPath + ", filter.get" + property.capName + "());");
    }

    private void writeBooleanRestriction(ViewProperty property) {
        String propertyPath = '\"' + property.lastPropertyName + '\"';
        String propertyCriteria = StringUtils.isEmpty((String)property.joinedAliasName) ? "criteria" : property.joinedAliasName + "Criteria";
        this.writeLine("addBooleanRestriction(" + propertyCriteria + ", " + propertyPath + ", filter.get" + property.capName + "());");
    }

    private void writeDoubleRestriction(ViewProperty property) {
        this.writeComparableRestriction(property);
    }

    private void writeBigDecimalRestriction(ViewProperty property) {
        this.writeComparableRestriction(property);
    }

    private void writeDateRestriction(ViewProperty property) {
        this.writeComparableRestriction(property);
    }

    private void writeDateTimeRestriction(ViewProperty property) {
        this.writeComparableRestriction(property);
    }

    private void writeLongRestriction(ViewProperty property) {
        this.writeComparableRestriction(property);
    }

    private void writeComparableRestriction(ViewProperty property) {
        String propertyPath = '\"' + property.lastPropertyName + '\"';
        String propertyCriteria = StringUtils.isEmpty((String)property.joinedAliasName) ? "criteria" : property.joinedAliasName + "Criteria";
        this.writeLine("addBetweenRestriction(" + propertyCriteria + ", " + propertyPath + ", filter.get" + property.capName + "MinValue(), filter.get" + property.capName + "MaxValue());");
    }

    private void createLoadOneToManyComponentList() {
        for (OneToManyComponent oneToManyComponent : this.bean.oneToManyComponentList) {
            Bean currentBean = oneToManyComponent.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * load one to many component " + currentBean.className + " list");
            this.writeLine(" */");
            this.writeLine("@Override");
            this.writeLine("@SuppressWarnings(\"unchecked\")");
            this.writeLine("public List<" + currentBean.className + "> load" + currentBean.className + "List(Long " + this.bean.objectName + "Id) {");
            this.writeLine("Criteria criteria = this.sessionFactory.getCurrentSession().createCriteria(" + currentBean.className + ".class);");
            this.writeLine("if (" + this.bean.objectName + "Id == null){");
            this.writeLine("criteria.add(Restrictions.isNull(\"" + oneToManyComponent.referenceProperty.name + ".id" + '\"' + "));");
            this.writeLine("} else {");
            this.writeLine("criteria.add(Restrictions.eq(\"" + oneToManyComponent.referenceProperty.name + ".id" + '\"' + ", " + this.bean.objectName + "Id));");
            this.writeLine("}");
            this.writeLine("return criteria.list();");
            this.writeLine("}");
            this.skipLine();
        }
    }

    private void createCountOneToManyComponent() {
        for (OneToManyComponent oneToManyComponent : this.bean.oneToManyComponentList) {
            Bean currentBean = oneToManyComponent.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * count one to many component " + currentBean.className);
            this.writeLine(" */");
            this.writeLine("@Override");
            this.writeLine("public Long count" + currentBean.className + "(Long " + this.bean.objectName + "Id) {");
            this.writeLine("Criteria criteria = this.sessionFactory.getCurrentSession().createCriteria(" + currentBean.className + ".class).setProjection(Projections.rowCount());");
            this.writeLine("if (" + this.bean.objectName + "Id == null){");
            this.writeLine("criteria.add(Restrictions.isNull(\"" + oneToManyComponent.referenceProperty.name + ".id" + '\"' + "));");
            this.writeLine("} else {");
            this.writeLine("criteria.add(Restrictions.eq(\"" + oneToManyComponent.referenceProperty.name + ".id" + '\"' + ", " + this.bean.objectName + "Id));");
            this.writeLine("}");
            this.writeLine("return (Long) criteria.uniqueResult();");
            this.writeLine("}");
            this.skipLine();
            this.writeLine("/**");
            this.writeLine("@Override");
            this.writeLine(" * count filtered one to many component " + currentBean.className);
            this.writeLine(" */");
            this.writeLine("public Long count" + currentBean.className + "(Long " + this.bean.objectName + "Id, " + currentBean.basicViewBean.filterClassName + " filter) {");
            this.writeLine("Criteria criteria = this.sessionFactory.getCurrentSession().createCriteria(" + currentBean.className + ".class).setProjection(Projections.rowCount());");
            this.writeLine("if (" + this.bean.objectName + "Id == null){");
            this.writeLine("criteria.add(Restrictions.isNull(\"" + oneToManyComponent.referenceProperty.name + ".id" + '\"' + "));");
            this.writeLine("} else {");
            this.writeLine("criteria.add(Restrictions.eq(\"" + oneToManyComponent.referenceProperty.name + ".id" + '\"' + ", " + this.bean.objectName + "Id));");
            this.writeLine("}");
            List<Alias> aliases = this.getAllAliases(currentBean);
            for (Alias alias : aliases) {
                this.writeLine("Criteria " + alias.name + "Criteria = " + (alias.parentName != null ? alias.parentName + "Criteria" : "criteria") + ".createCriteria(" + '\"' + alias.propertyName + '\"' + ", JoinType.LEFT_OUTER_JOIN);");
            }
            for (ViewProperty viewProperty : currentBean.basicViewBean.properties) {
                this.writeRestriction(viewProperty);
            }
            this.writeLine("return (Long) criteria.uniqueResult();");
            this.writeLine("}");
            this.skipLine();
        }
    }

    private void createScrollOneToManyComponent() {
        for (OneToManyComponent oneToManyComponent : this.bean.oneToManyComponentList) {
            Bean currentBean = oneToManyComponent.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * scroll filtered one to many component " + currentBean.className);
            this.writeLine(" */");
            this.writeLine("@Override");
            this.writeLine("@SuppressWarnings(\"unchecked\")");
            this.writeLine("public List<" + currentBean.className + "> scroll" + currentBean.className + "(Long " + this.bean.objectName + "Id, " + currentBean.basicViewBean.filterClassName + " filter, " + currentBean.basicViewBean.sortingClassName + " sorting, Long firstResult, Long maxResults) {");
            this.writeLine("Criteria criteria = this.sessionFactory.getCurrentSession().createCriteria(" + currentBean.className + ".class);");
            this.writeLine("if (" + this.bean.objectName + "Id == null){");
            this.writeLine("criteria.add(Restrictions.isNull(\"" + oneToManyComponent.referenceProperty.name + ".id" + '\"' + "));");
            this.writeLine("} else {");
            this.writeLine("criteria.add(Restrictions.eq(\"" + oneToManyComponent.referenceProperty.name + ".id" + '\"' + ", " + this.bean.objectName + "Id));");
            this.writeLine("}");
            List<Alias> aliases = this.getAllAliases(currentBean);
            for (Alias alias : aliases) {
                this.writeLine("Criteria " + alias.name + "Criteria = " + (alias.parentName != null ? alias.parentName + "Criteria" : "criteria") + ".createCriteria(" + '\"' + alias.propertyName + '\"' + ", JoinType.LEFT_OUTER_JOIN);");
            }
            for (ViewProperty viewProperty : currentBean.basicViewBean.properties) {
                this.writeRestriction(viewProperty);
            }
            for (ViewProperty viewProperty : currentBean.basicViewBean.properties) {
                String propertyCriteria = StringUtils.isEmpty((String)viewProperty.joinedAliasName) ? "criteria" : viewProperty.joinedAliasName + "Criteria";
                this.writeLine("addOrder(" + propertyCriteria + ", " + '\"' + viewProperty.lastPropertyName + '\"' + ", sorting.get" + viewProperty.capName + "OrderType());");
            }
            this.writeLine("if (firstResult != null){");
            this.writeLine("criteria.setFirstResult(firstResult.intValue());");
            this.writeLine("}");
            this.writeLine("if (maxResults != null){");
            this.writeLine("criteria.setMaxResults(maxResults.intValue());");
            this.writeLine("}");
            this.writeLine("return criteria.list();");
            this.writeLine("}");
            this.skipLine();
        }
    }

    private void createLoadOneToManyComponent() {
        for (OneToManyComponent oneToManyComponent : this.bean.oneToManyComponentList) {
            Bean currentBean = oneToManyComponent.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * load one to many component " + currentBean.className);
            this.writeLine(" */");
            this.writeLine("@Override");
            this.writeLine("public " + currentBean.className + " load" + currentBean.className + "(Long id) {");
            this.writeLine(currentBean.className + " " + currentBean.objectName + " = (" + currentBean.className + ")this.sessionFactory.getCurrentSession().get(" + currentBean.className + ".class,id);");
            this.writeLine("if (" + currentBean.objectName + " == null) {");
            this.writeLine("throw new ObjectNotFoundException(\"" + currentBean.className + ".notFound" + '\"' + ");");
            this.writeLine("} else {");
            this.writeLine("return " + currentBean.objectName + ";");
            this.writeLine("}");
            this.writeLine("}");
            this.skipLine();
        }
    }

    private void createExistsObject() {
        boolean start = true;
        this.writeLine("/**");
        this.writeLine(" * exists object");
        this.writeLine(" */");
        this.writeLine("@Override");
        this.write("public boolean exists(");
        for (ViewProperty property : this.bean.referenceViewProperties) {
            if (start) {
                start = false;
            } else {
                this.write(", ");
            }
            this.write(property.beanDataType + " " + property.name);
        }
        this.writeLine(") {");
        start = true;
        this.write("if (");
        for (ViewProperty property : this.bean.referenceViewProperties) {
            if (start) {
                start = false;
            } else {
                this.write(" && ");
            }
            this.write(property.name + " == null");
        }
        this.writeLine(") {");
        this.writeLine("return false;");
        this.writeLine("}");
        this.write(this.bean.className + " " + this.bean.objectName + " = (" + this.bean.className + ")this.sessionFactory.getCurrentSession().createCriteria(");
        this.writeLine(this.bean.className + ".class)");
        for (Alias alias : this.getReferenceAliases(this.bean)) {
            this.writeLine(".createAlias(\"" + alias.propertyPath + '\"' + "," + '\"' + alias.name + '\"' + ")");
        }
        for (ViewProperty property : this.bean.referenceViewProperties) {
            if (StringUtils.isEmpty((String)property.joinedAliasName)) {
                this.writeLine(".add(Restrictions.eq(\"" + property.lastPropertyName + '\"' + "," + property.name + "))");
                continue;
            }
            this.writeLine(".add(Restrictions.eq(\"" + property.joinedAliasName + "." + property.lastPropertyName + '\"' + "," + property.name + "))");
        }
        this.writeLine(".uniqueResult();");
        this.writeLine("return " + this.bean.objectName + " != null;");
        this.writeLine("}");
        this.skipLine();
    }

    private void createFindObject() {
        boolean start = true;
        List findPropertyList = this.bean.referenceViewProperties;
        this.writeLine("/**");
        this.writeLine(" * find object or null");
        this.writeLine(" */");
        this.writeLine("@Override");
        this.write("public " + this.bean.className + " findOrNull(");
        for (ViewProperty property : findPropertyList) {
            if (start) {
                start = false;
            } else {
                this.write(", ");
            }
            this.write(property.beanDataType + " " + property.name);
        }
        this.writeLine(") {");
        this.write(this.bean.className + " " + this.bean.objectName + " = (" + this.bean.className + ")this.sessionFactory.getCurrentSession().createCriteria(");
        this.writeLine(this.bean.className + ".class)");
        for (Alias alias : this.getReferenceAliases(this.bean)) {
            this.writeLine(".createAlias(\"" + alias.propertyPath + '\"' + "," + '\"' + alias.name + '\"' + ")");
        }
        for (ViewProperty property : findPropertyList) {
            if (StringUtils.isEmpty((String)property.joinedAliasName)) {
                this.writeLine(".add(Restrictions.eq(\"" + property.lastPropertyName + '\"' + "," + property.name + "))");
                continue;
            }
            this.writeLine(".add(Restrictions.eq(\"" + property.joinedAliasName + "." + property.lastPropertyName + '\"' + "," + property.name + "))");
        }
        this.writeLine(".uniqueResult();");
        this.writeLine("return " + this.bean.objectName + ";");
        this.writeLine("}");
        this.skipLine();
        start = true;
        this.writeLine("/**");
        this.writeLine(" * find object");
        this.writeLine(" */");
        this.writeLine("@Override");
        this.write("public " + this.bean.className + " find(");
        for (ViewProperty property : findPropertyList) {
            if (start) {
                start = false;
            } else {
                this.write(", ");
            }
            this.write(property.beanDataType + " " + property.name);
        }
        this.writeLine(") {");
        start = true;
        this.write("if (");
        for (ViewProperty property : findPropertyList) {
            if (start) {
                start = false;
            } else {
                this.write(" && ");
            }
            this.write(property.name + " == null");
        }
        this.writeLine(") {");
        this.writeLine("return null;");
        this.writeLine("}");
        start = true;
        this.write(this.bean.className + " " + this.bean.objectName + " = findOrNull(");
        for (ViewProperty property : findPropertyList) {
            if (start) {
                start = false;
            } else {
                this.write(", ");
            }
            this.write(property.name);
        }
        this.writeLine(");");
        this.writeLine("if (" + this.bean.objectName + " == null) {");
        this.writeLine("throw new ObjectNotFoundException(\"" + this.bean.className + ".notFound" + '\"' + ");");
        this.writeLine("} else {");
        this.writeLine("return " + this.bean.objectName + ";");
        this.writeLine("}");
        this.writeLine("}");
        this.skipLine();
    }

    private void createSearch() {
        Property targetProperty = this.bean.selectionBehavior.targetProperty;
        this.writeLine("/**");
        this.writeLine(" * search");
        this.writeLine(" */");
        this.writeLine("@Override");
        this.writeLine("@SuppressWarnings(\"unchecked\")");
        this.writeLine("public List<" + this.bean.className + "> search(String arg) {");
        this.writeLine("Criteria criteria = this.sessionFactory.getCurrentSession().createCriteria(" + this.bean.className + ".class);");
        String propertyPath = "\"{alias}." + targetProperty.column.name + '\"';
        this.writeLine("addStringContainsRestriction(criteria, " + propertyPath + ", arg);");
        this.writeLine("criteria.setMaxResults(20);");
        this.writeLine("return criteria.list();");
        this.writeLine("}");
        this.skipLine();
    }

    private void createSaveComponent() {
        Bean currentBean;
        for (OneToManyComponent oneToManyComponent : this.bean.oneToManyComponentList) {
            currentBean = oneToManyComponent.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * save one to many component " + currentBean.className);
            this.writeLine(" */");
            this.writeLine("@Override");
            this.writeLine("public void save" + currentBean.className + "(" + this.bean.className + " " + this.bean.objectName + ", " + currentBean.className + " " + currentBean.objectName + ") {");
            this.writeLine(currentBean.objectName + "." + oneToManyComponent.referenceProperty.setterName + "(" + this.bean.objectName + ");");
            this.writeLine("this.sessionFactory.getCurrentSession().save(" + currentBean.objectName + ");");
            this.writeLine("}");
            this.skipLine();
        }
        for (OneToOneComponent oneToOneComponent : this.bean.oneToOneComponentList) {
            currentBean = oneToOneComponent.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * save one to one component " + currentBean.className);
            this.writeLine(" */");
            this.writeLine("@Override");
            this.writeLine("public void save" + currentBean.className + "(" + this.bean.className + " " + this.bean.objectName + ", " + currentBean.className + " " + currentBean.objectName + ") {");
            this.writeLine(currentBean.objectName + ".set" + this.bean.className + "(" + this.bean.objectName + ");");
            this.writeLine("this.sessionFactory.getCurrentSession().save(" + currentBean.objectName + ");");
            this.writeLine("}");
            this.skipLine();
        }
    }

    private void createDeleteComponent() {
        Bean currentBean;
        for (OneToManyComponent oneToManyComponent : this.bean.oneToManyComponentList) {
            currentBean = oneToManyComponent.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * delete one to many component " + currentBean.className);
            this.writeLine(" */");
            this.writeLine("@Override");
            this.writeLine("public void delete" + currentBean.className + "(" + currentBean.className + " " + currentBean.objectName + ") {");
            this.writeLine(currentBean.objectName + "." + oneToManyComponent.referenceProperty.getterName + "().get" + currentBean.className + "Collection().remove(" + currentBean.objectName + ");");
            this.writeLine("this.sessionFactory.getCurrentSession().delete(" + currentBean.objectName + ");");
            this.writeLine("}");
            this.skipLine();
        }
        for (OneToOneComponent oneToOneComponent : this.bean.oneToOneComponentList) {
            currentBean = oneToOneComponent.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * delete one to one component " + currentBean.className);
            this.writeLine(" */");
            this.writeLine("@Override");
            this.writeLine("public void delete" + currentBean.className + "(" + currentBean.className + " " + currentBean.objectName + ") {");
            this.writeLine(this.bean.className + " " + this.bean.objectName + " = " + currentBean.objectName + ".get" + this.bean.className + "();");
            this.writeLine(this.bean.objectName + ".set" + currentBean.className + "(null);");
            this.writeLine("this.sessionFactory.getCurrentSession().delete(" + currentBean.objectName + ");");
            this.writeLine("}");
            this.skipLine();
        }
    }

    private List<Alias> getReferenceAliases(Bean bean) {
        return this.getAliases(bean, bean.cardinality);
    }

    private List<Alias> getAllAliases(Bean bean) {
        return this.getAliases(bean, bean.properties.size());
    }

    private List<Alias> getAliases(Bean bean, int size) {
        ArrayList<Alias> aliasList = new ArrayList<Alias>();
        List<Object> tempAliasList = new ArrayList();
        for (int i = 0; i < size; ++i) {
            Property currentProperty = (Property)bean.properties.get(i);
            if (!currentProperty.visibility.isListVisible() || currentProperty.referenceBean == null || currentProperty.relation.isComponentLink()) continue;
            Alias alias = new Alias();
            alias.propertyPath = currentProperty.name;
            alias.propertyName = currentProperty.name;
            alias.name = currentProperty.name;
            alias.parentName = null;
            aliasList.add(alias);
            tempAliasList = this.getAliases(currentProperty);
            for (int j = 0; j < tempAliasList.size(); ++j) {
                Alias tempAlias = (Alias)tempAliasList.get(j);
                Alias newAlias = new Alias();
                newAlias.propertyPath = alias.propertyPath + "." + tempAlias.propertyPath;
                newAlias.propertyName = tempAlias.propertyName;
                newAlias.name = alias.name + JavaClassNaming.getClassNameFromObjectName((String)tempAlias.name);
                newAlias.parentName = tempAlias.parentName == null ? alias.name : alias.name + JavaClassNaming.getClassNameFromObjectName((String)tempAlias.parentName);
                aliasList.add(newAlias);
            }
        }
        return aliasList;
    }

    private List<Alias> getAliases(Property property) {
        if (property.embedded) {
            return this.getAllAliases(property.referenceBean);
        }
        return this.getReferenceAliases(property.referenceBean);
    }

    private class Alias {
        public String propertyPath;
        public String propertyName;
        public String name;
        public String parentName;

        private Alias() {
        }
    }
}

