/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.generator.skeletons.core.commands.bc.rightmanager;

import java.io.File;
import java.io.IOException;
import org.sklsft.generator.model.domain.business.Bean;
import org.sklsft.generator.model.domain.business.OneToManyComponent;
import org.sklsft.generator.model.domain.business.OneToOneComponent;
import org.sklsft.generator.skeletons.commands.impl.typed.JavaFileWriteCommand;

public class BaseRightsManagerImplFileWriteCommand
extends JavaFileWriteCommand {
    private Bean bean;

    public BaseRightsManagerImplFileWriteCommand(Bean bean) {
        super(bean.myPackage.model.project.workspaceFolder + File.separator + bean.myPackage.model.project.projectName + "-business-component" + File.separator + "src" + File.separator + "main" + File.separator + "java" + File.separator + bean.myPackage.baseRightsManagerImplPackageName.replace(".", File.separator), bean.baseRightsManagerClassName);
        this.bean = bean;
    }

    protected void fetchSpecificImports() {
        Bean currentBean;
        this.javaImports.add("import org.sklsft.commons.api.exception.rights.AccessDeniedException;");
        this.javaImports.add("import org.sklsft.commons.api.exception.rights.OperationDeniedException;");
        this.javaImports.add("import " + this.bean.myPackage.omPackageName + "." + this.bean.className + ";");
        this.javaImports.add("import org.sklsft.commons.model.patterns.RightsManager;");
        for (OneToOneComponent oneToOneComponent : this.bean.oneToOneComponentList) {
            currentBean = oneToOneComponent.referenceBean;
            this.javaImports.add("import " + currentBean.myPackage.omPackageName + "." + currentBean.className + ";");
        }
        for (OneToManyComponent oneToManyComponent : this.bean.oneToManyComponentList) {
            currentBean = oneToManyComponent.referenceBean;
            this.javaImports.add("import " + currentBean.myPackage.omPackageName + "." + currentBean.className + ";");
        }
    }

    protected void writeContent() throws IOException {
        Bean currentBean;
        this.writeLine("package " + this.bean.myPackage.baseRightsManagerImplPackageName + ";");
        this.skipLine();
        this.writeImports();
        this.skipLine();
        this.writeLine("/**");
        this.writeLine(" * auto generated base rights manager class file");
        this.writeLine(" * <br/>no modification should be done to this file");
        this.writeLine(" * <br/>processed by skeleton-generator");
        this.writeLine(" */");
        this.writeLine("public class " + this.bean.baseRightsManagerClassName + " implements RightsManager<" + this.bean.className + ", Long> {");
        this.skipLine();
        this.writeLine("/**");
        this.writeLine(" * can access all");
        this.writeLine(" */");
        this.writeLine("public boolean canAccess() {");
        this.writeLine("return true;");
        this.writeLine("}");
        this.skipLine();
        this.writeLine("/**");
        this.writeLine(" * check can access all");
        this.writeLine(" */");
        this.writeLine("public void checkCanAccess() {");
        this.writeLine("if (!canAccess()) {");
        this.writeLine("throw new AccessDeniedException(\"" + this.bean.className + ".accessDenied" + '\"' + ");");
        this.writeLine("}");
        this.writeLine("}");
        this.skipLine();
        this.writeLine("/**");
        this.writeLine(" * can access");
        this.writeLine(" */");
        this.writeLine("public boolean canAccess(" + this.bean.className + " " + this.bean.objectName + ") {");
        this.writeLine("return true;");
        this.writeLine("}");
        this.skipLine();
        this.writeLine("/**");
        this.writeLine(" * check can access");
        this.writeLine(" */");
        this.writeLine("public void checkCanAccess(" + this.bean.className + " " + this.bean.objectName + ") {");
        this.writeLine("if (!canAccess(" + this.bean.objectName + ")) {");
        this.writeLine("throw new AccessDeniedException(\"" + this.bean.className + ".accessDenied" + '\"' + ");");
        this.writeLine("}");
        this.writeLine("}");
        this.skipLine();
        for (OneToOneComponent oneToOneComponent : this.bean.oneToOneComponentList) {
            currentBean = oneToOneComponent.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * can access one to one component " + currentBean.className);
            this.writeLine(" */");
            this.writeLine("public boolean canAccess" + currentBean.className + "(" + this.bean.className + " " + this.bean.objectName + ") {");
            this.writeLine("return canAccess(" + this.bean.objectName + ");");
            this.writeLine("}");
            this.skipLine();
            this.writeLine("/**");
            this.writeLine(" * check can access one to one component " + currentBean.className);
            this.writeLine(" */");
            this.writeLine("public void checkCanAccess" + currentBean.className + "(" + this.bean.className + " " + this.bean.objectName + ") {");
            this.writeLine("if (!canAccess" + currentBean.className + "(" + this.bean.objectName + ")) {");
            this.writeLine("throw new AccessDeniedException(\"" + currentBean.className + ".accessDenied" + '\"' + ");");
            this.writeLine("}");
            this.writeLine("}");
            this.skipLine();
        }
        for (OneToManyComponent oneToManyComponent : this.bean.oneToManyComponentList) {
            currentBean = oneToManyComponent.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * can access one to many component " + currentBean.className);
            this.writeLine(" */");
            this.writeLine("public boolean canAccess" + currentBean.className + "(" + this.bean.className + " " + this.bean.objectName + ") {");
            this.writeLine("return canAccess(" + this.bean.objectName + ");");
            this.writeLine("}");
            this.skipLine();
            this.writeLine("/**");
            this.writeLine(" * check can access one to many component " + currentBean.className);
            this.writeLine(" */");
            this.writeLine("public void checkCanAccess" + currentBean.className + "(" + this.bean.className + " " + this.bean.objectName + ") {");
            this.writeLine("if (!canAccess" + currentBean.className + "(" + this.bean.objectName + ")) {");
            this.writeLine("throw new AccessDeniedException(\"" + currentBean.className + ".accessDenied" + '\"' + ");");
            this.writeLine("}");
            this.writeLine("}");
            this.skipLine();
        }
        this.writeLine("/**");
        this.writeLine(" * can create");
        this.writeLine(" */");
        this.writeLine("public boolean canCreate() {");
        this.writeLine("return true;");
        this.writeLine("}");
        this.skipLine();
        this.writeLine("/**");
        this.writeLine(" * check can create");
        this.writeLine(" */");
        this.writeLine("public void checkCanCreate() {");
        this.writeLine("if (!canCreate()) {");
        this.writeLine("throw new OperationDeniedException(\"" + this.bean.className + ".create.operationDenied" + '\"' + ");");
        this.writeLine("}");
        this.writeLine("}");
        this.skipLine();
        for (OneToOneComponent oneToOneComponent : this.bean.oneToOneComponentList) {
            currentBean = oneToOneComponent.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * can create one to one component " + currentBean.className);
            this.writeLine(" */");
            this.writeLine("public boolean canCreate" + currentBean.className + "(" + this.bean.className + " " + this.bean.objectName + ") {");
            this.writeLine("return canUpdate(" + this.bean.objectName + ");");
            this.writeLine("}");
            this.skipLine();
            this.writeLine("/**");
            this.writeLine(" * check can create one to one component " + currentBean.className);
            this.writeLine(" */");
            this.writeLine("public void checkCanCreate" + currentBean.className + "(" + this.bean.className + " " + this.bean.objectName + ") {");
            this.writeLine("if (!canCreate" + currentBean.className + "(" + this.bean.objectName + ")) {");
            this.writeLine("throw new OperationDeniedException(\"" + currentBean.className + ".create.operationDenied" + '\"' + ");");
            this.writeLine("}");
            this.writeLine("}");
            this.skipLine();
        }
        for (OneToManyComponent oneToManyComponent : this.bean.oneToManyComponentList) {
            currentBean = oneToManyComponent.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * can create one to many component " + currentBean.className);
            this.writeLine(" */");
            this.writeLine("public boolean canCreate" + currentBean.className + "(" + this.bean.className + " " + this.bean.objectName + ") {");
            this.writeLine("return canUpdate(" + this.bean.objectName + ");");
            this.writeLine("}");
            this.skipLine();
            this.writeLine("/**");
            this.writeLine(" * check can create one to many component " + currentBean.className);
            this.writeLine(" */");
            this.writeLine("public void checkCanCreate" + currentBean.className + "(" + this.bean.className + " " + this.bean.objectName + ") {");
            this.writeLine("if (!canCreate" + currentBean.className + "(" + this.bean.objectName + ")) {");
            this.writeLine("throw new OperationDeniedException(\"" + currentBean.className + ".create.operationDenied" + '\"' + ");");
            this.writeLine("}");
            this.writeLine("}");
            this.skipLine();
        }
        this.writeLine("/**");
        this.writeLine(" * can save");
        this.writeLine(" */");
        this.writeLine("public boolean canSave(" + this.bean.className + " " + this.bean.objectName + ") {");
        this.writeLine("return true;");
        this.writeLine("}");
        this.skipLine();
        this.writeLine("/**");
        this.writeLine(" * check can save");
        this.writeLine(" */");
        this.writeLine("public void checkCanSave(" + this.bean.className + " " + this.bean.objectName + ") {");
        this.writeLine("if (!canSave(" + this.bean.objectName + ")) {");
        this.writeLine("throw new OperationDeniedException(\"" + this.bean.className + ".save.operationDenied" + '\"' + ");");
        this.writeLine("}");
        this.writeLine("}");
        this.skipLine();
        for (OneToOneComponent oneToOneComponent : this.bean.oneToOneComponentList) {
            currentBean = oneToOneComponent.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * can save one to one component " + currentBean.className);
            this.writeLine(" */");
            this.writeLine("public boolean canSave" + currentBean.className + "(" + currentBean.className + " " + currentBean.objectName + "," + this.bean.className + " " + this.bean.objectName + ") {");
            this.writeLine("return canUpdate(" + this.bean.objectName + ");");
            this.writeLine("}");
            this.skipLine();
            this.writeLine("/**");
            this.writeLine(" * check can save one to one component " + currentBean.className);
            this.writeLine(" */");
            this.writeLine("public void checkCanSave" + currentBean.className + "(" + currentBean.className + " " + currentBean.objectName + "," + this.bean.className + " " + this.bean.objectName + ") {");
            this.writeLine("if (!canSave" + currentBean.className + "(" + currentBean.objectName + ", " + this.bean.objectName + ")) {");
            this.writeLine("throw new OperationDeniedException(\"" + currentBean.className + ".save.operationDenied" + '\"' + ");");
            this.writeLine("}");
            this.writeLine("}");
            this.skipLine();
        }
        for (OneToManyComponent oneToManyComponent : this.bean.oneToManyComponentList) {
            currentBean = oneToManyComponent.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * can save one to many component " + currentBean.className);
            this.writeLine(" */");
            this.writeLine("public boolean canSave" + currentBean.className + "(" + currentBean.className + " " + currentBean.objectName + "," + this.bean.className + " " + this.bean.objectName + ") {");
            this.writeLine("return canUpdate(" + this.bean.objectName + ");");
            this.writeLine("}");
            this.skipLine();
            this.writeLine("/**");
            this.writeLine(" * check can save one to many component " + currentBean.className);
            this.writeLine(" */");
            this.writeLine("public void checkCanSave" + currentBean.className + "(" + currentBean.className + " " + currentBean.objectName + "," + this.bean.className + " " + this.bean.objectName + ") {");
            this.writeLine("if (!canSave" + currentBean.className + "(" + currentBean.objectName + ", " + this.bean.objectName + ")) {");
            this.writeLine("throw new OperationDeniedException(\"" + currentBean.className + ".save.operationDenied" + '\"' + ");");
            this.writeLine("}");
            this.writeLine("}");
            this.skipLine();
        }
        this.writeLine("/**");
        this.writeLine(" * can update");
        this.writeLine(" */");
        this.writeLine("public boolean canUpdate(" + this.bean.className + " " + this.bean.objectName + ") {");
        this.writeLine("return true;");
        this.writeLine("}");
        this.skipLine();
        this.writeLine("/**");
        this.writeLine(" * check can update");
        this.writeLine(" */");
        this.writeLine("public void checkCanUpdate(" + this.bean.className + " " + this.bean.objectName + ") {");
        this.writeLine("if (!canUpdate(" + this.bean.objectName + ")) {");
        this.writeLine("throw new OperationDeniedException(\"" + this.bean.className + ".update.operationDenied" + '\"' + ");");
        this.writeLine("}");
        this.writeLine("}");
        this.skipLine();
        for (OneToOneComponent oneToOneComponent : this.bean.oneToOneComponentList) {
            currentBean = oneToOneComponent.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * can update one to one component " + currentBean.className);
            this.writeLine(" */");
            this.writeLine("public boolean canUpdate" + currentBean.className + "(" + currentBean.className + " " + currentBean.objectName + ") {");
            this.writeLine("return canUpdate(" + currentBean.objectName + "." + oneToOneComponent.referenceProperty.getterName + "());");
            this.writeLine("}");
            this.skipLine();
            this.writeLine("/**");
            this.writeLine(" * check can update one to one component " + currentBean.className);
            this.writeLine(" */");
            this.writeLine("public void checkCanUpdate" + currentBean.className + "(" + currentBean.className + " " + currentBean.objectName + ") {");
            this.writeLine("if (!canUpdate" + currentBean.className + "(" + currentBean.objectName + ")) {");
            this.writeLine("throw new OperationDeniedException(\"" + currentBean.className + ".update.operationDenied" + '\"' + ");");
            this.writeLine("}");
            this.writeLine("}");
            this.skipLine();
        }
        for (OneToManyComponent oneToManyComponent : this.bean.oneToManyComponentList) {
            currentBean = oneToManyComponent.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * can update one to many component " + currentBean.className);
            this.writeLine(" */");
            this.writeLine("public boolean canUpdate" + currentBean.className + "(" + currentBean.className + " " + currentBean.objectName + ") {");
            this.writeLine("return canUpdate(" + currentBean.objectName + "." + oneToManyComponent.referenceProperty.getterName + "());");
            this.writeLine("}");
            this.skipLine();
            this.writeLine("/**");
            this.writeLine(" * check can update one to many component " + currentBean.className);
            this.writeLine(" */");
            this.writeLine("public void checkCanUpdate" + currentBean.className + "(" + currentBean.className + " " + currentBean.objectName + ") {");
            this.writeLine("if (!canUpdate" + currentBean.className + "(" + currentBean.objectName + ")) {");
            this.writeLine("throw new OperationDeniedException(\"" + currentBean.className + ".update.operationDenied" + '\"' + ");");
            this.writeLine("}");
            this.writeLine("}");
            this.skipLine();
        }
        this.writeLine("/**");
        this.writeLine(" * can delete");
        this.writeLine(" */");
        this.writeLine("public boolean canDelete(" + this.bean.className + " " + this.bean.objectName + ") {");
        this.writeLine("return true;");
        this.writeLine("}");
        this.skipLine();
        this.writeLine("/**");
        this.writeLine(" * check can delete");
        this.writeLine(" */");
        this.writeLine("public void checkCanDelete(" + this.bean.className + " " + this.bean.objectName + ") {");
        this.writeLine("if (!canDelete(" + this.bean.objectName + ")) {");
        this.writeLine("throw new OperationDeniedException(\"" + this.bean.className + ".delete.operationDenied" + '\"' + ");");
        this.writeLine("}");
        this.writeLine("}");
        this.skipLine();
        for (OneToOneComponent oneToOneComponent : this.bean.oneToOneComponentList) {
            currentBean = oneToOneComponent.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * can delete one to one component " + currentBean.className);
            this.writeLine(" */");
            this.writeLine("public boolean canDelete" + currentBean.className + "(" + currentBean.className + " " + currentBean.objectName + ") {");
            this.writeLine("return canUpdate(" + currentBean.objectName + "." + oneToOneComponent.referenceProperty.getterName + "());");
            this.writeLine("}");
            this.skipLine();
            this.writeLine("/**");
            this.writeLine(" * check can delete one to one component " + currentBean.className);
            this.writeLine(" */");
            this.writeLine("public void checkCanDelete" + currentBean.className + "(" + currentBean.className + " " + currentBean.objectName + ") {");
            this.writeLine("if (!canDelete" + currentBean.className + "(" + currentBean.objectName + ")) {");
            this.writeLine("throw new OperationDeniedException(\"" + currentBean.className + ".delete.operationDenied" + '\"' + ");");
            this.writeLine("}");
            this.writeLine("}");
            this.skipLine();
        }
        for (OneToManyComponent oneToManyComponent : this.bean.oneToManyComponentList) {
            currentBean = oneToManyComponent.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * can delete one to many component " + currentBean.className);
            this.writeLine(" */");
            this.writeLine("public boolean canDelete" + currentBean.className + "(" + currentBean.className + " " + currentBean.objectName + ") {");
            this.writeLine("return canUpdate(" + currentBean.objectName + "." + oneToManyComponent.referenceProperty.getterName + "());");
            this.writeLine("}");
            this.skipLine();
            this.writeLine("/**");
            this.writeLine(" * check can delete one to many component " + currentBean.className);
            this.writeLine(" */");
            this.writeLine("public void checkCanDelete" + currentBean.className + "(" + currentBean.className + " " + currentBean.objectName + ") {");
            this.writeLine("if (!canDelete" + currentBean.className + "(" + currentBean.objectName + ")) {");
            this.writeLine("throw new OperationDeniedException(\"" + currentBean.className + ".delete.operationDenied" + '\"' + ");");
            this.writeLine("}");
            this.writeLine("}");
            this.skipLine();
        }
        this.writeLine("}");
    }
}

