/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.generator.skeletons.core.commands.bc.mapper;

import java.io.File;
import java.io.IOException;
import org.sklsft.generator.model.domain.business.Bean;
import org.sklsft.generator.skeletons.commands.impl.typed.JavaFileWriteCommand;

public class BaseFullViewMapperFileWriteCommand
extends JavaFileWriteCommand {
    private Bean bean;

    public BaseFullViewMapperFileWriteCommand(Bean bean) {
        super(bean.myPackage.model.project.workspaceFolder + File.separator + bean.myPackage.model.project.projectName + "-business-component" + File.separator + "src" + File.separator + "main" + File.separator + "java" + File.separator + bean.myPackage.baseFullViewMapperPackageName.replace(".", File.separator), bean.fullViewBean.baseMapperClassName);
        this.bean = bean;
    }

    protected void fetchSpecificImports() {
        this.javaImports.add("import org.sklsft.commons.mapper.impl.FullViewMapper;");
        this.javaImports.add("import javax.inject.Inject;");
        this.javaImports.add("import " + this.bean.myPackage.omPackageName + "." + this.bean.className + ";");
        this.javaImports.add("import " + this.bean.myPackage.formsPackageName + "." + this.bean.formBean.className + ";");
        this.javaImports.add("import " + this.bean.myPackage.fullViewsPackageName + "." + this.bean.fullViewBean.className + ";");
        if (this.bean.isComponent) {
            this.javaImports.add("import " + this.bean.parentBean.myPackage.rightsManagerImplPackageName + "." + this.bean.parentBean.rightsManagerClassName + ";");
            this.javaImports.add("import " + this.bean.parentBean.myPackage.stateManagerImplPackageName + "." + this.bean.parentBean.stateManagerClassName + ";");
        } else {
            this.javaImports.add("import " + this.bean.myPackage.rightsManagerImplPackageName + "." + this.bean.rightsManagerClassName + ";");
            this.javaImports.add("import " + this.bean.myPackage.stateManagerImplPackageName + "." + this.bean.stateManagerClassName + ";");
        }
    }

    protected void writeContent() throws IOException {
        this.writeLine("package " + this.bean.myPackage.baseFullViewMapperPackageName + ";");
        this.skipLine();
        this.writeImports();
        this.skipLine();
        this.writeLine("/**");
        this.writeLine(" * auto generated mapper class file");
        this.writeLine(" * <br/>write modifications between specific code marks");
        this.writeLine(" * <br/>processed by skeleton-generator");
        this.writeLine(" */");
        this.skipLine();
        this.writeLine("public class " + this.bean.fullViewBean.baseMapperClassName + " extends FullViewMapper<" + this.bean.fullViewBean.className + ", Long, " + this.bean.formBean.className + ", " + this.bean.className + "> {");
        this.skipLine();
        if (this.bean.isComponent) {
            this.writeLine("@Inject");
            this.writeLine("protected " + this.bean.parentBean.rightsManagerClassName + " " + this.bean.parentBean.rightsManagerObjectName + ";");
            this.writeLine("@Inject");
            this.writeLine("protected " + this.bean.parentBean.stateManagerClassName + " " + this.bean.parentBean.stateManagerObjectName + ";");
        } else {
            this.writeLine("@Inject");
            this.writeLine("protected " + this.bean.rightsManagerClassName + " " + this.bean.rightsManagerObjectName + ";");
            this.writeLine("@Inject");
            this.writeLine("protected " + this.bean.stateManagerClassName + " " + this.bean.stateManagerObjectName + ";");
        }
        this.skipLine();
        this.writeLine("public " + this.bean.fullViewBean.baseMapperClassName + "() {");
        this.writeLine("super(" + this.bean.fullViewBean.className + ".class, " + this.bean.className + ".class);");
        this.writeLine("}");
        this.skipLine();
        this.writeLine("@Override");
        this.writeLine("public " + this.bean.fullViewBean.className + " mapFrom(" + this.bean.fullViewBean.className + " " + this.bean.fullViewBean.objectName + ", " + this.bean.className + " " + this.bean.objectName + ") {");
        this.writeLine(this.bean.fullViewBean.objectName + " = super.mapFrom(" + this.bean.fullViewBean.objectName + ", " + this.bean.objectName + ");");
        if (this.bean.isComponent) {
            this.writeLine(this.bean.fullViewBean.objectName + ".setCanUpdate(" + this.bean.parentBean.rightsManagerObjectName + ".canUpdate" + this.bean.className + "(" + this.bean.objectName + ") && " + this.bean.parentBean.stateManagerObjectName + ".canUpdate" + this.bean.className + "(" + this.bean.objectName + "));");
        } else {
            this.writeLine(this.bean.fullViewBean.objectName + ".setCanUpdate(" + this.bean.rightsManagerObjectName + ".canUpdate(" + this.bean.objectName + ") && " + this.bean.stateManagerObjectName + ".canUpdate(" + this.bean.objectName + "));");
        }
        this.writeLine("return " + this.bean.fullViewBean.objectName + ";");
        this.writeLine("}");
        this.skipLine();
        this.writeLine("}");
    }
}

