/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.generator.skeletons.core.commands.bc.mapper;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sklsft.generator.model.domain.business.Bean;
import org.sklsft.generator.model.domain.business.Property;
import org.sklsft.generator.model.domain.ui.ViewProperty;
import org.sklsft.generator.skeletons.commands.impl.typed.JavaFileWriteCommand;

public class BaseFormMapperFileWriteCommand
extends JavaFileWriteCommand {
    private Bean bean;
    private Set<String> daoSet;

    public BaseFormMapperFileWriteCommand(Bean bean) {
        super(bean.myPackage.model.project.workspaceFolder + File.separator + bean.myPackage.model.project.projectName + "-business-component" + File.separator + "src" + File.separator + "main" + File.separator + "java" + File.separator + bean.myPackage.baseFormMapperPackageName.replace(".", File.separator), bean.formBean.baseMapperClassName);
        this.bean = bean;
    }

    protected void fetchSpecificImports() {
        this.daoSet = new HashSet<String>();
        this.javaImports.add("import org.sklsft.commons.mapper.impl.BasicMapperImpl;");
        this.javaImports.add("import org.sklsft.commons.api.exception.repository.ObjectNotFoundException;");
        this.javaImports.add("import javax.inject.Inject;");
        this.javaImports.add("import " + this.bean.myPackage.omPackageName + "." + this.bean.className + ";");
        this.javaImports.add("import " + this.bean.myPackage.formsPackageName + "." + this.bean.formBean.className + ";");
        for (Property property : this.bean.properties) {
            if (property.referenceBean == null || !property.visibility.isDetailVisible() || property.relation.isComponentLink()) continue;
            if (!property.embedded) {
                boolean test = this.daoSet.add(property.referenceBean.daoObjectName);
                if (!test) continue;
                this.javaImports.add("import " + property.referenceBean.myPackage.DAOInterfacePackageName + "." + property.referenceBean.daoInterfaceName + ";");
                continue;
            }
            this.javaImports.add("import " + property.referenceBean.myPackage.omPackageName + "." + property.referenceBean.className + ";");
            for (Property embeddedProperty : property.referenceBean.properties) {
                boolean test;
                if (embeddedProperty.referenceBean == null || !embeddedProperty.visibility.isDetailVisible() || !(test = this.daoSet.add(embeddedProperty.referenceBean.daoObjectName))) continue;
                this.javaImports.add("import " + embeddedProperty.referenceBean.myPackage.DAOInterfacePackageName + "." + embeddedProperty.referenceBean.daoInterfaceName + ";");
            }
        }
    }

    protected void writeContent() throws IOException {
        this.writeLine("package " + this.bean.myPackage.baseFormMapperPackageName + ";");
        this.skipLine();
        this.writeImports();
        this.skipLine();
        this.writeLine("/**");
        this.writeLine(" * auto generated base mapper class file");
        this.writeLine(" * <br/>no modification should be done to this file");
        this.writeLine(" * <br/>processed by skeleton-generator");
        this.writeLine(" */");
        this.write("public class " + this.bean.formBean.baseMapperClassName);
        this.writeLine(" extends BasicMapperImpl<" + this.bean.formBean.className + ", " + this.bean.className + "> {");
        this.skipLine();
        this.writeLine("public " + this.bean.formBean.baseMapperClassName + "() {");
        this.writeLine("super(" + this.bean.formBean.className + ".class, " + this.bean.className + ".class);");
        this.writeLine("}");
        this.skipLine();
        this.writeLine("/*");
        this.writeLine(" * properties");
        this.writeLine(" */");
        this.daoSet = new HashSet<String>();
        for (Property property : this.bean.properties) {
            if (property.referenceBean == null || !property.visibility.isDetailVisible() || property.relation.isComponentLink()) continue;
            if (!property.embedded) {
                boolean test = this.daoSet.add(property.referenceBean.daoObjectName);
                if (!test) continue;
                this.writeLine("@Inject");
                this.writeLine("protected " + property.referenceBean.daoInterfaceName + " " + property.referenceBean.daoObjectName + ";");
                continue;
            }
            for (Property embeddedProperty : property.referenceBean.properties) {
                boolean test;
                if (embeddedProperty.referenceBean == null || !embeddedProperty.visibility.isDetailVisible() || !(test = this.daoSet.add(embeddedProperty.referenceBean.daoObjectName))) continue;
                this.writeLine("@Inject");
                this.writeLine("protected " + embeddedProperty.referenceBean.daoInterfaceName + " " + embeddedProperty.referenceBean.daoObjectName + ";");
            }
        }
        this.skipLine();
        this.createMappingFrom();
        this.createMappingTo();
        this.writeLine("}");
    }

    private void createMappingFrom() {
        this.writeLine("/**");
        this.writeLine(" * mapping form from object");
        this.writeLine(" */");
        this.writeLine("@Override");
        this.writeLine("public " + this.bean.formBean.className + " mapFrom(" + this.bean.formBean.className + " " + this.bean.formBean.objectName + ", " + this.bean.className + " " + this.bean.objectName + ") {");
        this.writeLine(this.bean.formBean.objectName + " = super.mapFrom(" + this.bean.formBean.objectName + ", " + this.bean.objectName + ");");
        for (Property property : this.bean.properties) {
            if (property.referenceBean == null || !property.visibility.isDetailVisible() || property.relation.isComponentLink()) continue;
            if (property.embedded) {
                this.writeMapEmbeddedToView(property);
                continue;
            }
            this.writeMapReferenceToView(property);
        }
        this.writeLine("return " + this.bean.formBean.objectName + ";");
        this.writeLine("}");
        this.skipLine();
    }

    private void writeMapReferenceToView(Property property) {
        List referencePropertyList = property.referenceBean.referenceViewProperties;
        if (property.nullable) {
            this.writeLine("if (" + this.bean.objectName + "." + property.getterName + "() != null) {");
            for (ViewProperty referenceProperty : referencePropertyList) {
                this.writeLine(this.bean.formBean.objectName + "." + property.setterName + referenceProperty.capName + "(" + this.bean.objectName + "." + property.getterName + "()." + referenceProperty.mappingPath + ");");
            }
            this.writeLine("}");
        } else {
            for (ViewProperty findProperty : referencePropertyList) {
                this.writeLine(this.bean.formBean.objectName + "." + property.setterName + findProperty.capName + "(" + this.bean.objectName + "." + property.getterName + "()." + findProperty.mappingPath + ");");
            }
        }
    }

    private void writeMapEmbeddedToView(Property property) {
        Bean embeddedBean = property.referenceBean;
        for (Property embeddedProperty : embeddedBean.properties) {
            if (!embeddedProperty.visibility.isDetailVisible()) continue;
            if (embeddedProperty.referenceBean != null) {
                List referencePropertyList = embeddedProperty.referenceBean.referenceViewProperties;
                if (embeddedProperty.nullable) {
                    this.writeLine("if (" + this.bean.objectName + "." + property.getterName + "()." + embeddedProperty.getterName + "() != null) {");
                    for (ViewProperty referenceProperty : referencePropertyList) {
                        this.writeLine(this.bean.formBean.objectName + "." + embeddedProperty.setterName + referenceProperty.capName + "(" + this.bean.objectName + "." + property.getterName + "()." + embeddedProperty.getterName + "()." + referenceProperty.mappingPath + ");");
                    }
                    this.writeLine("}");
                    continue;
                }
                for (ViewProperty referenceProperty : referencePropertyList) {
                    this.writeLine(this.bean.formBean.objectName + "." + embeddedProperty.setterName + referenceProperty.capName + "(" + this.bean.objectName + "." + property.getterName + "()." + embeddedProperty.getterName + "()." + referenceProperty.mappingPath + ");");
                }
                continue;
            }
            this.writeLine(this.bean.formBean.objectName + "." + embeddedProperty.setterName + "(" + this.bean.objectName + "." + property.getterName + "()." + embeddedProperty.getterName + "());");
        }
    }

    private void createMappingTo() {
        this.writeLine("/**");
        this.writeLine(" * mapping view to object");
        this.writeLine(" */");
        this.writeLine("@Override");
        this.writeLine("public " + this.bean.className + " mapTo(" + this.bean.formBean.className + " " + this.bean.formBean.objectName + ", " + this.bean.className + " " + this.bean.objectName + ") {");
        this.writeLine(this.bean.objectName + " = super.mapTo(" + this.bean.formBean.objectName + ", " + this.bean.objectName + ");");
        for (Property property : this.bean.properties) {
            if (property.referenceBean == null || !property.visibility.isDetailVisible() || property.relation.isComponentLink()) continue;
            if (property.embedded) {
                this.writeMapEmbeddedToObject(property);
                continue;
            }
            this.writeMapReferenceToObject(property);
        }
        this.writeLine("return " + this.bean.objectName + ";");
        this.writeLine("}");
        this.skipLine();
    }

    private void writeMapReferenceToObject(Property property) {
        boolean start = true;
        this.write(this.bean.objectName + "." + property.setterName + "(" + property.referenceBean.daoObjectName + ".find(");
        for (ViewProperty refProperty : property.referenceBean.referenceViewProperties) {
            if (start) {
                start = false;
            } else {
                this.write(", ");
            }
            this.write(this.bean.formBean.objectName + "." + property.getterName + refProperty.capName + "()");
        }
        this.writeLine("));");
    }

    private void writeMapEmbeddedToObject(Property property) {
        Bean embeddedBean = property.referenceBean;
        this.writeLine(embeddedBean.className + " " + embeddedBean.objectName + " = " + this.bean.objectName + "." + property.getterName + "();");
        this.writeLine("if (" + embeddedBean.objectName + " == null) {");
        this.writeLine(embeddedBean.objectName + " = new " + embeddedBean.className + "();");
        this.writeLine(this.bean.objectName + "." + property.setterName + "(" + embeddedBean.objectName + ");");
        this.writeLine("}");
        for (Property embeddedProperty : embeddedBean.properties) {
            if (!embeddedProperty.visibility.isDetailVisible()) continue;
            if (embeddedProperty.referenceBean != null) {
                List referencePropertyList = embeddedProperty.referenceBean.referenceViewProperties;
                this.write(embeddedBean.objectName + "." + embeddedProperty.setterName + "(" + embeddedProperty.referenceBean.daoObjectName + ".find(");
                boolean start = true;
                for (ViewProperty refProperty : referencePropertyList) {
                    if (start) {
                        start = false;
                    } else {
                        this.write(", ");
                    }
                    this.write(this.bean.formBean.objectName + "." + embeddedProperty.getterName + refProperty.capName + "()");
                }
                this.writeLine("));");
                continue;
            }
            this.writeLine(embeddedBean.objectName + "." + embeddedProperty.setterName + "(" + this.bean.formBean.objectName + "." + embeddedProperty.getterName + "());");
        }
    }
}

