/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.generator.skeletons.core.commands.bc.mapper;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sklsft.generator.model.domain.business.Bean;
import org.sklsft.generator.model.domain.business.Property;
import org.sklsft.generator.model.domain.ui.ViewProperty;
import org.sklsft.generator.skeletons.commands.impl.typed.JavaFileWriteCommand;

public class BaseBasicViewMapperFileWriteCommand
extends JavaFileWriteCommand {
    private Bean bean;
    private Set<String> daoSet;

    public BaseBasicViewMapperFileWriteCommand(Bean bean) {
        super(bean.myPackage.model.project.workspaceFolder + File.separator + bean.myPackage.model.project.projectName + "-business-component" + File.separator + "src" + File.separator + "main" + File.separator + "java" + File.separator + bean.myPackage.baseBasicViewMapperPackageName.replace(".", File.separator), bean.basicViewBean.baseMapperClassName);
        this.bean = bean;
    }

    protected void fetchSpecificImports() {
        this.daoSet = new HashSet<String>();
        this.javaImports.add("import org.sklsft.commons.mapper.impl.BasicMapperImpl;");
        this.javaImports.add("import org.sklsft.commons.api.exception.repository.ObjectNotFoundException;");
        this.javaImports.add("import javax.inject.Inject;");
        this.javaImports.add("import " + this.bean.myPackage.omPackageName + "." + this.bean.className + ";");
        this.javaImports.add("import " + this.bean.myPackage.basicViewsPackageName + "." + this.bean.basicViewBean.className + ";");
        if (this.bean.isComponent) {
            this.javaImports.add("import " + this.bean.parentBean.myPackage.rightsManagerImplPackageName + "." + this.bean.parentBean.rightsManagerClassName + ";");
            this.javaImports.add("import " + this.bean.parentBean.myPackage.stateManagerImplPackageName + "." + this.bean.parentBean.stateManagerClassName + ";");
        } else {
            this.javaImports.add("import " + this.bean.myPackage.rightsManagerImplPackageName + "." + this.bean.rightsManagerClassName + ";");
            this.javaImports.add("import " + this.bean.myPackage.stateManagerImplPackageName + "." + this.bean.stateManagerClassName + ";");
        }
        for (Property property : this.bean.properties) {
            if (property.referenceBean == null || !property.visibility.isListVisible() || property.relation.isComponentLink()) continue;
            if (!property.embedded) {
                boolean test = this.daoSet.add(property.referenceBean.daoObjectName);
                if (!test) continue;
                this.javaImports.add("import " + property.referenceBean.myPackage.DAOInterfacePackageName + "." + property.referenceBean.daoInterfaceName + ";");
                continue;
            }
            this.javaImports.add("import " + property.referenceBean.myPackage.omPackageName + "." + property.referenceBean.className + ";");
            for (Property embeddedProperty : property.referenceBean.properties) {
                boolean test;
                if (embeddedProperty.referenceBean == null || !embeddedProperty.visibility.isListVisible() || !(test = this.daoSet.add(embeddedProperty.referenceBean.daoObjectName))) continue;
                this.javaImports.add("import " + embeddedProperty.referenceBean.myPackage.DAOInterfacePackageName + "." + embeddedProperty.referenceBean.daoInterfaceName + ";");
            }
        }
    }

    protected void writeContent() throws IOException {
        this.writeLine("package " + this.bean.myPackage.baseBasicViewMapperPackageName + ";");
        this.skipLine();
        this.writeImports();
        this.skipLine();
        this.writeLine("/**");
        this.writeLine(" * auto generated base mapper class file");
        this.writeLine(" * <br/>no modification should be done to this file");
        this.writeLine(" * <br/>processed by skeleton-generator");
        this.writeLine(" */");
        this.write("public class " + this.bean.basicViewBean.baseMapperClassName);
        this.writeLine(" extends BasicMapperImpl<" + this.bean.basicViewBean.className + ", " + this.bean.className + "> {");
        this.skipLine();
        this.writeLine("public " + this.bean.basicViewBean.baseMapperClassName + "() {");
        this.writeLine("super(" + this.bean.basicViewBean.className + ".class, " + this.bean.className + ".class);");
        this.writeLine("}");
        this.skipLine();
        this.writeLine("/*");
        this.writeLine(" * properties");
        this.writeLine(" */");
        this.daoSet = new HashSet<String>();
        for (Property property : this.bean.properties) {
            if (property.referenceBean == null || !property.visibility.isListVisible() || property.relation.isComponentLink()) continue;
            if (!property.embedded) {
                boolean test = this.daoSet.add(property.referenceBean.daoObjectName);
                if (!test) continue;
                this.writeLine("@Inject");
                this.writeLine("protected " + property.referenceBean.daoInterfaceName + " " + property.referenceBean.daoObjectName + ";");
                continue;
            }
            for (Property embeddedProperty : property.referenceBean.properties) {
                boolean test;
                if (embeddedProperty.referenceBean == null || !embeddedProperty.visibility.isListVisible() || !(test = this.daoSet.add(embeddedProperty.referenceBean.daoObjectName))) continue;
                this.writeLine("@Inject");
                this.writeLine("protected " + embeddedProperty.referenceBean.daoInterfaceName + " " + embeddedProperty.referenceBean.daoObjectName + ";");
            }
        }
        this.skipLine();
        if (this.bean.isComponent) {
            this.writeLine("@Inject");
            this.writeLine("protected " + this.bean.parentBean.rightsManagerClassName + " " + this.bean.parentBean.rightsManagerObjectName + ";");
            this.writeLine("@Inject");
            this.writeLine("protected " + this.bean.parentBean.stateManagerClassName + " " + this.bean.parentBean.stateManagerObjectName + ";");
        } else {
            this.writeLine("@Inject");
            this.writeLine("protected " + this.bean.rightsManagerClassName + " " + this.bean.rightsManagerObjectName + ";");
            this.writeLine("@Inject");
            this.writeLine("protected " + this.bean.stateManagerClassName + " " + this.bean.stateManagerObjectName + ";");
        }
        this.skipLine();
        this.createMappingFrom();
        this.createMappingTo();
        this.writeLine("}");
    }

    private void createMappingFrom() {
        this.writeLine("/**");
        this.writeLine(" * mapping view from object");
        this.writeLine(" */");
        this.writeLine("@Override");
        this.writeLine("public " + this.bean.basicViewBean.className + " mapFrom(" + this.bean.basicViewBean.className + " " + this.bean.basicViewBean.objectName + ", " + this.bean.className + " " + this.bean.objectName + ") {");
        this.writeLine(this.bean.basicViewBean.objectName + " = super.mapFrom(" + this.bean.basicViewBean.objectName + ", " + this.bean.objectName + ");");
        this.writeLine(this.bean.basicViewBean.objectName + ".setSelected(false);");
        if (this.bean.isComponent) {
            this.writeLine(this.bean.basicViewBean.objectName + ".setCanDelete(" + this.bean.parentBean.rightsManagerObjectName + ".canDelete" + this.bean.className + "(" + this.bean.objectName + ") && " + this.bean.parentBean.stateManagerObjectName + ".canDelete" + this.bean.className + "(" + this.bean.objectName + "));");
        } else {
            this.writeLine(this.bean.basicViewBean.objectName + ".setCanDelete(" + this.bean.rightsManagerObjectName + ".canDelete(" + this.bean.objectName + ") && " + this.bean.stateManagerObjectName + ".canDelete(" + this.bean.objectName + "));");
        }
        for (Property property : this.bean.properties) {
            if (property.referenceBean == null || !property.visibility.isListVisible() || property.relation.isComponentLink()) continue;
            if (property.embedded) {
                this.writeMapEmbeddedToView(property);
                continue;
            }
            this.writeMapReferenceToView(property);
        }
        this.writeLine("return " + this.bean.basicViewBean.objectName + ";");
        this.writeLine("}");
        this.skipLine();
    }

    private void writeMapReferenceToView(Property property) {
        List referencePropertyList = property.referenceBean.referenceViewProperties;
        if (property.nullable) {
            this.writeLine("if (" + this.bean.objectName + "." + property.getterName + "() != null) {");
            for (ViewProperty viewProperty : referencePropertyList) {
                this.writeLine(this.bean.basicViewBean.objectName + "." + property.setterName + viewProperty.capName + "(" + this.bean.objectName + "." + property.getterName + "()." + viewProperty.mappingPath + ");");
            }
            this.writeLine("}");
        } else {
            for (ViewProperty ViewProperty2 : referencePropertyList) {
                this.writeLine(this.bean.basicViewBean.objectName + "." + property.setterName + ViewProperty2.capName + "(" + this.bean.objectName + "." + property.getterName + "()." + ViewProperty2.mappingPath + ");");
            }
        }
    }

    private void writeMapEmbeddedToView(Property property) {
        Bean embeddedBean = property.referenceBean;
        for (Property embeddedProperty : embeddedBean.properties) {
            if (!embeddedProperty.visibility.isListVisible()) continue;
            if (embeddedProperty.referenceBean != null) {
                List referencePropertyList = embeddedProperty.referenceBean.referenceViewProperties;
                if (embeddedProperty.nullable) {
                    this.writeLine("if (" + this.bean.objectName + "." + property.getterName + "()." + embeddedProperty.getterName + "() != null) {");
                    for (ViewProperty viewProperty : referencePropertyList) {
                        this.writeLine(this.bean.basicViewBean.objectName + "." + embeddedProperty.setterName + viewProperty.capName + "(" + this.bean.objectName + "." + property.getterName + "()." + embeddedProperty.getterName + "()." + viewProperty.mappingPath + ");");
                    }
                    this.writeLine("}");
                    continue;
                }
                for (ViewProperty viewProperty : referencePropertyList) {
                    this.writeLine(this.bean.basicViewBean.objectName + "." + embeddedProperty.setterName + viewProperty.capName + "(" + this.bean.objectName + "." + property.getterName + "()." + embeddedProperty.getterName + "()." + viewProperty.mappingPath + ");");
                }
                continue;
            }
            this.writeLine(this.bean.basicViewBean.objectName + "." + embeddedProperty.setterName + "(" + this.bean.objectName + "." + property.getterName + "()." + embeddedProperty.getterName + "());");
        }
    }

    private void createMappingTo() {
        this.writeLine("/**");
        this.writeLine(" * mapping view to object");
        this.writeLine(" */");
        this.writeLine("@Override");
        this.writeLine("public " + this.bean.className + " mapTo(" + this.bean.basicViewBean.className + " " + this.bean.basicViewBean.objectName + ", " + this.bean.className + " " + this.bean.objectName + ") {");
        this.writeLine(this.bean.objectName + " = super.mapTo(" + this.bean.basicViewBean.objectName + ", " + this.bean.objectName + ");");
        for (Property property : this.bean.properties) {
            if (property.referenceBean == null || !property.visibility.isListVisible() || property.relation.isComponentLink()) continue;
            if (property.embedded) {
                this.writeMapEmbeddedToObject(property);
                continue;
            }
            this.writeMapReferenceToObject(property);
        }
        this.writeLine("return " + this.bean.objectName + ";");
        this.writeLine("}");
        this.skipLine();
    }

    private void writeMapReferenceToObject(Property property) {
        boolean start = true;
        this.write(this.bean.objectName + "." + property.setterName + "(" + property.referenceBean.daoObjectName + ".find(");
        for (ViewProperty refProperty : property.referenceBean.referenceViewProperties) {
            if (start) {
                start = false;
            } else {
                this.write(", ");
            }
            this.write(this.bean.basicViewBean.objectName + "." + property.getterName + refProperty.capName + "()");
        }
        this.writeLine("));");
    }

    private void writeMapEmbeddedToObject(Property property) {
        Bean embeddedBean = property.referenceBean;
        this.writeLine(embeddedBean.className + " " + embeddedBean.objectName + " = " + this.bean.objectName + "." + property.getterName + "();");
        this.writeLine("if (" + embeddedBean.objectName + " == null) {");
        this.writeLine(embeddedBean.objectName + " = new " + embeddedBean.className + "();");
        this.writeLine(this.bean.objectName + "." + property.setterName + "(" + embeddedBean.objectName + ");");
        this.writeLine("}");
        for (Property embeddedProperty : embeddedBean.properties) {
            if (!embeddedProperty.visibility.isListVisible()) continue;
            if (embeddedProperty.referenceBean != null) {
                List referencePropertyList = embeddedProperty.referenceBean.referenceViewProperties;
                this.write(embeddedBean.objectName + "." + embeddedProperty.setterName + "(" + embeddedProperty.referenceBean.daoObjectName + ".find(");
                boolean start = true;
                for (ViewProperty refProperty : referencePropertyList) {
                    if (start) {
                        start = false;
                    } else {
                        this.write(", ");
                    }
                    this.write(this.bean.basicViewBean.objectName + "." + embeddedProperty.getterName + refProperty.capName + "()");
                }
                this.writeLine("));");
                continue;
            }
            this.writeLine(embeddedBean.objectName + "." + embeddedProperty.setterName + "(" + this.bean.basicViewBean.objectName + "." + embeddedProperty.getterName + "());");
        }
    }
}

