/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.generator.skeletons.core.commands.api.model;

import java.io.File;
import java.io.IOException;
import org.sklsft.generator.model.domain.business.Bean;
import org.sklsft.generator.model.domain.ui.ViewProperty;
import org.sklsft.generator.skeletons.commands.impl.typed.JavaFileWriteCommand;

public class SortingFileWriteCommand
extends JavaFileWriteCommand {
    private Bean bean;

    public SortingFileWriteCommand(Bean bean) {
        super(bean.myPackage.model.project.workspaceFolder + File.separator + bean.myPackage.model.project.projectName + "-api" + File.separator + "src" + File.separator + "main" + File.separator + "java" + File.separator + bean.myPackage.sortingsPackageName.replace(".", File.separator), bean.basicViewBean.sortingClassName);
        this.bean = bean;
    }

    protected void fetchSpecificImports() {
        this.javaImports.add("import java.util.Date;");
        this.javaImports.add("import java.math.BigDecimal;");
        this.javaImports.add("import java.io.Serializable;");
        this.javaImports.add("import org.sklsft.commons.api.model.OrderType;");
    }

    protected void writeContent() throws IOException {
        this.writeLine("package " + this.bean.myPackage.sortingsPackageName + ";");
        this.skipLine();
        this.writeImports();
        this.skipLine();
        this.writeLine("/**");
        this.writeLine(" * auto generated ordering class file");
        this.writeLine(" * <br/>basic representation of filter used along with jsf datatable");
        this.writeLine(" * <br/>write modifications between specific code marks");
        this.writeLine(" * <br/>processed by skeleton-generator");
        this.writeLine(" */");
        this.writeLine("public class " + this.bean.basicViewBean.sortingClassName + " implements Serializable {");
        this.skipLine();
        this.writeLine("private static final long serialVersionUID = 1L;");
        this.skipLine();
        this.createProperties();
        this.createGettersAndSetters();
        this.writeNotOverridableContent();
        this.writeLine("}");
    }

    private void createProperties() {
        this.writeLine("/*");
        this.writeLine(" * properties");
        this.writeLine(" */");
        for (ViewProperty property : this.bean.basicViewBean.properties) {
            this.writeLine("private OrderType " + property.name + "OrderType;");
        }
        this.skipLine();
    }

    private void createGettersAndSetters() {
        this.writeLine("/*");
        this.writeLine(" * getters and setters");
        this.writeLine(" */");
        for (ViewProperty property : this.bean.basicViewBean.properties) {
            this.writeLine("public OrderType get" + property.capName + "OrderType() {");
            this.writeLine("return this." + property.name + "OrderType;");
            this.writeLine("}");
            this.skipLine();
            this.writeLine("public void set" + property.capName + "OrderType(OrderType " + property.name + "OrderType) {");
            this.writeLine("this." + property.name + "OrderType = " + property.name + "OrderType;");
            this.writeLine("}");
            this.skipLine();
        }
        this.skipLine();
    }
}

