/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.generator.skeletons.core.commands.api.model;

import java.io.File;
import java.io.IOException;
import org.sklsft.generator.model.domain.business.Bean;
import org.sklsft.generator.model.domain.ui.ViewProperty;
import org.sklsft.generator.skeletons.commands.impl.typed.JavaFileWriteCommand;

public class FormBeanFileWriteCommand
extends JavaFileWriteCommand {
    private Bean bean;

    public FormBeanFileWriteCommand(Bean bean) {
        super(bean.myPackage.model.project.workspaceFolder + File.separator + bean.myPackage.model.project.projectName + "-api" + File.separator + "src" + File.separator + "main" + File.separator + "java" + File.separator + bean.myPackage.formsPackageName.replace(".", File.separator), bean.formBean.className);
        this.bean = bean;
    }

    protected void fetchSpecificImports() {
        this.javaImports.add("import java.util.Date;");
        this.javaImports.add("import java.math.BigDecimal;");
        this.javaImports.add("import java.io.Serializable;");
        this.javaImports.add("import javax.validation.constraints.NotNull;");
    }

    protected void writeContent() throws IOException {
        this.writeLine("package " + this.bean.myPackage.formsPackageName + ";");
        this.skipLine();
        this.writeImports();
        this.skipLine();
        this.writeLine("/**");
        this.writeLine(" * auto generated form bean class file");
        this.writeLine(" * <br/>basic representation of what is going to be considered as model in MVC patterns");
        this.writeLine(" * <br/>write modifications between specific code marks");
        this.writeLine(" * <br/>processed by skeleton-generator");
        this.writeLine(" */");
        this.writeLine("public class " + this.bean.formBean.className + " implements Serializable {");
        this.skipLine();
        this.writeLine("private static final long serialVersionUID = 1L;");
        this.skipLine();
        this.createProperties();
        this.createGettersAndSetters();
        this.writeNotOverridableContent();
        this.writeLine("}");
    }

    private void createProperties() {
        this.writeLine("/*");
        this.writeLine(" * properties");
        this.writeLine(" */");
        for (ViewProperty property : this.bean.formBean.properties) {
            if (!property.nullable) {
                this.writeLine("@NotNull");
            }
            this.writeLine("private " + property.beanDataType + " " + property.name + ";");
        }
        this.skipLine();
    }

    private void createGettersAndSetters() {
        this.writeLine("/*");
        this.writeLine(" * getters and setters");
        this.writeLine(" */");
        for (ViewProperty property : this.bean.formBean.properties) {
            this.writeLine("public " + property.beanDataType + " get" + property.capName + "() {");
            this.writeLine("return this." + property.name + ";");
            this.writeLine("}");
            this.writeLine("public void set" + property.capName + "(" + property.beanDataType + " " + property.name + ") {");
            this.writeLine("this." + property.name + " = " + property.name + ";");
            this.writeLine("}");
        }
        this.skipLine();
    }
}

