/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.generator.skeletons.core.commands.api.model;

import java.io.File;
import java.io.IOException;
import org.sklsft.generator.model.domain.business.Bean;
import org.sklsft.generator.model.domain.ui.ViewProperty;
import org.sklsft.generator.skeletons.commands.impl.typed.JavaFileWriteCommand;

public class BasicViewBeanFileWriteCommand
extends JavaFileWriteCommand {
    private Bean bean;

    public BasicViewBeanFileWriteCommand(Bean bean) {
        super(bean.myPackage.model.project.workspaceFolder + File.separator + bean.myPackage.model.project.projectName + "-api" + File.separator + "src" + File.separator + "main" + File.separator + "java" + File.separator + bean.myPackage.basicViewsPackageName.replace(".", File.separator), bean.basicViewBean.className);
        this.bean = bean;
    }

    protected void fetchSpecificImports() {
        this.javaImports.add("import java.util.Date;");
        this.javaImports.add("import java.math.BigDecimal;");
        this.javaImports.add("import java.io.Serializable;");
    }

    protected void writeContent() throws IOException {
        this.writeLine("package " + this.bean.myPackage.basicViewsPackageName + ";");
        this.skipLine();
        this.writeImports();
        this.skipLine();
        this.writeLine("/**");
        this.writeLine(" * auto generated view bean class file");
        this.writeLine(" * <br/>basic representation of what is going to be considered as model in MVC patterns");
        this.writeLine(" * <br/>write modifications between specific code marks");
        this.writeLine(" * <br/>processed by skeleton-generator");
        this.writeLine(" */");
        this.writeLine("public class " + this.bean.basicViewBean.className + " implements Serializable {");
        this.skipLine();
        this.writeLine("private static final long serialVersionUID = 1L;");
        this.skipLine();
        this.createProperties();
        this.createGettersAndSetters();
        this.writeNotOverridableContent();
        this.writeLine("}");
    }

    private void createProperties() {
        this.writeLine("/*");
        this.writeLine(" * properties");
        this.writeLine(" */");
        this.writeLine("private Long id;");
        this.writeLine("private boolean selected;");
        this.writeLine("private boolean canDelete;");
        for (ViewProperty property : this.bean.basicViewBean.properties) {
            this.writeLine("private " + property.beanDataType + " " + property.name + ";");
        }
        this.skipLine();
    }

    private void createGettersAndSetters() {
        this.writeLine("/*");
        this.writeLine(" * getters and setters");
        this.writeLine(" */");
        this.writeLine("public Long getId() {");
        this.writeLine("return this.id;");
        this.writeLine("}");
        this.skipLine();
        this.writeLine("public void setId(Long id) {");
        this.writeLine("this.id = id;");
        this.writeLine("}");
        this.skipLine();
        this.writeLine("public boolean getSelected() {");
        this.writeLine("return this.selected;");
        this.writeLine("}");
        this.skipLine();
        this.writeLine("public void setSelected(boolean selected) {");
        this.writeLine("this.selected = selected;");
        this.writeLine("}");
        this.skipLine();
        this.writeLine("public boolean getCanDelete() {");
        this.writeLine("return this.canDelete;");
        this.writeLine("}");
        this.skipLine();
        this.writeLine("public void setCanDelete(boolean canDelete) {");
        this.writeLine("this.canDelete = canDelete;");
        this.writeLine("}");
        this.skipLine();
        for (ViewProperty property : this.bean.basicViewBean.properties) {
            this.writeLine("public " + property.beanDataType + " get" + property.capName + "() {");
            this.writeLine("return this." + property.name + ";");
            this.writeLine("}");
            this.skipLine();
            this.writeLine("public void set" + property.capName + "(" + property.beanDataType + " " + property.name + ") {");
            this.writeLine("this." + property.name + " = " + property.name + ";");
            this.writeLine("}");
            this.skipLine();
        }
        this.skipLine();
    }
}

