/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.generator.skeletons.core.commands.api.interfaces;

import java.io.File;
import java.io.IOException;
import org.sklsft.generator.model.domain.business.Bean;
import org.sklsft.generator.model.domain.business.OneToManyComponent;
import org.sklsft.generator.model.domain.business.OneToOneComponent;
import org.sklsft.generator.model.domain.business.Property;
import org.sklsft.generator.model.domain.ui.ViewProperty;
import org.sklsft.generator.model.metadata.RelationType;
import org.sklsft.generator.model.metadata.SelectionMode;
import org.sklsft.generator.skeletons.commands.impl.typed.JavaFileWriteCommand;

public class BaseServiceInterfaceFileWriteCommand
extends JavaFileWriteCommand {
    private Bean bean;

    public BaseServiceInterfaceFileWriteCommand(Bean bean) {
        super(bean.myPackage.model.project.workspaceFolder + File.separator + bean.myPackage.model.project.projectName + "-api" + File.separator + "src" + File.separator + "main" + File.separator + "java" + File.separator + bean.myPackage.baseServiceInterfacePackageName.replace(".", File.separator), bean.baseServiceInterfaceName);
        this.bean = bean;
    }

    protected void fetchSpecificImports() {
        Bean currentBean;
        this.javaImports.add("import java.util.Date;");
        this.javaImports.add("import java.math.BigDecimal;");
        this.javaImports.add("import java.util.List;");
        this.javaImports.add("import org.sklsft.commons.api.model.ScrollForm;");
        this.javaImports.add("import org.sklsft.commons.api.model.ScrollView;");
        this.javaImports.add("import org.sklsft.commons.api.model.SelectItem;");
        this.javaImports.add("import " + this.bean.myPackage.basicViewsPackageName + "." + this.bean.basicViewBean.className + ";");
        this.javaImports.add("import " + this.bean.myPackage.fullViewsPackageName + "." + this.bean.fullViewBean.className + ";");
        this.javaImports.add("import " + this.bean.myPackage.formsPackageName + "." + this.bean.formBean.className + ";");
        this.javaImports.add("import " + this.bean.myPackage.filtersPackageName + "." + this.bean.basicViewBean.filterClassName + ";");
        this.javaImports.add("import " + this.bean.myPackage.sortingsPackageName + "." + this.bean.basicViewBean.sortingClassName + ";");
        for (OneToOneComponent OneToOneComponent2 : this.bean.oneToOneComponentList) {
            currentBean = OneToOneComponent2.referenceBean;
            this.javaImports.add("import " + currentBean.myPackage.fullViewsPackageName + "." + currentBean.fullViewBean.className + ";");
            this.javaImports.add("import " + currentBean.myPackage.formsPackageName + "." + currentBean.formBean.className + ";");
        }
        for (OneToManyComponent oneToManyComponent : this.bean.oneToManyComponentList) {
            currentBean = oneToManyComponent.referenceBean;
            this.javaImports.add("import " + currentBean.myPackage.basicViewsPackageName + "." + currentBean.basicViewBean.className + ";");
            this.javaImports.add("import " + currentBean.myPackage.fullViewsPackageName + "." + currentBean.fullViewBean.className + ";");
            this.javaImports.add("import " + currentBean.myPackage.formsPackageName + "." + currentBean.formBean.className + ";");
            this.javaImports.add("import " + currentBean.myPackage.filtersPackageName + "." + currentBean.basicViewBean.filterClassName + ";");
            this.javaImports.add("import " + currentBean.myPackage.sortingsPackageName + "." + currentBean.basicViewBean.sortingClassName + ";");
        }
    }

    protected void writeContent() throws IOException {
        this.writeLine("package " + this.bean.myPackage.baseServiceInterfacePackageName + ";");
        this.skipLine();
        this.writeImports();
        this.skipLine();
        this.writeLine("/**");
        this.writeLine(" * auto generated base service interface file");
        this.writeLine(" * <br/>no modification should be done to this file");
        this.writeLine(" * <br/>processed by skeleton-generator");
        this.writeLine(" */");
        this.writeLine("public interface " + this.bean.baseServiceInterfaceName + " {");
        this.skipLine();
        if (this.bean.selectable) {
            this.createGetOptions();
        }
        this.createLoadObjectList();
        this.createScroll();
        this.createLoadObject();
        if (this.bean.cardinality > 0) {
            this.createFindObject();
        }
        this.createLoadOneToOneComponent();
        this.createLoadOneToManyComponentList();
        this.createScrollOneToManyComponent();
        this.createLoadOneToManyComponent();
        this.createCreateObject();
        this.createCreateOneToManyComponent();
        this.createSaveObject();
        this.createSaveOneToOneComponent();
        this.createSaveOneToManyComponent();
        this.createUpdateObject();
        this.createUpdateOneToOneComponent();
        this.createUpdateOneToManyComponent();
        this.createDeleteObject();
        this.createDeleteOneToOneComponent();
        this.createDeleteOneToManyComponent();
        this.createDeleteObjectList();
        this.createDeleteOneToManyComponentList();
        this.writeLine("}");
    }

    private void createGetOptions() {
        if (this.bean.selectionBehavior.selectionMode.equals((Object)SelectionMode.DROPDOWN_OPTIONS)) {
            this.writeLine("/**");
            this.writeLine(" * get options");
            this.writeLine(" */");
            this.writeLine("List<SelectItem> getOptions();");
            this.writeLine("public static final String GET_OPTIONS_URL = \"/" + this.bean.urlPiece + "/options\";");
            this.skipLine();
        }
        if (this.bean.selectionBehavior.selectionMode.equals((Object)SelectionMode.AUTO_COMPLETE)) {
            this.writeLine("/**");
            this.writeLine(" * search options");
            this.writeLine(" */");
            this.writeLine("List<SelectItem> searchOptions(String arg);");
            this.writeLine("public static final String SEARCH_OPTIONS_URL = \"/" + this.bean.urlPiece + "/options/search\";");
            this.skipLine();
        }
    }

    private void createLoadObjectList() {
        this.writeLine("/**");
        this.writeLine(" * load object list");
        this.writeLine(" */");
        this.writeLine("List<" + this.bean.basicViewBean.className + "> loadList();");
        this.writeLine("public static final String GET_LIST_URL = \"/" + this.bean.urlPiece + "/list\";");
        this.skipLine();
        for (Property property : this.bean.properties) {
            if (property.referenceBean == null || !property.relation.equals((Object)RelationType.MANY_TO_ONE)) continue;
            this.writeLine("/**");
            this.writeLine(" * load object list from " + property.name);
            this.writeLine(" */");
            this.writeLine("List<" + this.bean.basicViewBean.className + "> loadListFrom" + property.capName + " (Long " + property.name + "Id);");
            this.writeLine("public static final String GET_" + this.bean.table.originalName + "_LIST_fROM_" + property.referenceBean.table.originalName + "_URL = \"/" + property.referenceBean.urlPiece + "/{" + property.name + "Id}/" + this.bean.urlPiece + "/list\";");
            this.skipLine();
        }
    }

    private void createScroll() {
        this.writeLine("/**");
        this.writeLine(" * scroll object list");
        this.writeLine(" */");
        this.writeLine("ScrollView<" + this.bean.basicViewBean.className + "> scroll(ScrollForm<" + this.bean.basicViewBean.filterClassName + ", " + this.bean.basicViewBean.sortingClassName + "> form);");
        this.writeLine("public static final String SCROLL_URL = \"/" + this.bean.urlPiece + "/scroll\";");
        this.skipLine();
        for (Property property : this.bean.properties) {
            if (property.referenceBean == null || !property.relation.equals((Object)RelationType.MANY_TO_ONE)) continue;
            this.writeLine("/**");
            this.writeLine(" * scroll object list from " + property.name);
            this.writeLine(" */");
            this.writeLine("ScrollView<" + this.bean.basicViewBean.className + "> scrollFrom" + property.capName + " (Long " + property.name + "Id, ScrollForm<" + this.bean.basicViewBean.filterClassName + ", " + this.bean.basicViewBean.sortingClassName + "> form);");
            this.writeLine("public static final String SCROLL_" + this.bean.table.originalName + "_fROM_" + property.referenceBean.table.originalName + "_URL = \"/" + property.referenceBean.urlPiece + "/{" + property.name + "Id}/" + this.bean.urlPiece + "/scroll\";");
            this.skipLine();
        }
    }

    private void createLoadObject() {
        this.writeLine("/**");
        this.writeLine(" * load object");
        this.writeLine(" */");
        this.writeLine(this.bean.fullViewBean.className + " load(Long id);");
        this.writeLine("public static final String GET_URL = \"/" + this.bean.urlPiece + "/{id}\";");
        this.skipLine();
    }

    private void createFindObject() {
        boolean start = true;
        this.writeLine("/**");
        this.writeLine(" * find object");
        this.writeLine(" */");
        this.writeLine("public static final String FIND_URL = \"/" + this.bean.urlPiece + "/find\";");
        this.write(this.bean.fullViewBean.className + " find(");
        for (ViewProperty property : this.bean.referenceViewProperties) {
            if (start) {
                start = false;
            } else {
                this.write(", ");
            }
            this.write(property.beanDataType + " " + property.name);
        }
        this.writeLine(");");
        this.skipLine();
    }

    private void createLoadOneToOneComponent() {
        for (OneToOneComponent oneToOneComponent : this.bean.oneToOneComponentList) {
            Bean currentBean = oneToOneComponent.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * load one to one component " + currentBean.objectName);
            this.writeLine(" */");
            this.writeLine(currentBean.fullViewBean.className + " load" + currentBean.className + "(Long id);");
            this.writeLine("public static final String GET_" + currentBean.table.originalName + "_URL = \"/" + this.bean.urlPiece + "/{id}/" + currentBean.urlPiece + "\";");
            this.skipLine();
        }
    }

    private void createLoadOneToManyComponentList() {
        for (OneToManyComponent oneToManyComponent : this.bean.oneToManyComponentList) {
            Bean currentBean = oneToManyComponent.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * load one to many component " + currentBean.objectName + " list");
            this.writeLine(" */");
            this.writeLine("List<" + currentBean.basicViewBean.className + "> load" + currentBean.className + "List(Long id);");
            this.writeLine("public static final String GET_" + currentBean.table.originalName + "_LIST_URL = \"/" + this.bean.urlPiece + "/{id}/" + currentBean.urlPiece + "/list\";");
            this.skipLine();
        }
    }

    private void createScrollOneToManyComponent() {
        for (OneToManyComponent oneToManyComponent : this.bean.oneToManyComponentList) {
            Bean currentBean = oneToManyComponent.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * scroll one to many component " + currentBean.objectName);
            this.writeLine(" */");
            this.writeLine("ScrollView<" + currentBean.basicViewBean.className + "> scroll" + currentBean.className + " (Long " + this.bean.objectName + "Id, ScrollForm<" + currentBean.basicViewBean.filterClassName + ", " + currentBean.basicViewBean.sortingClassName + "> form);");
            this.writeLine("public static final String SCROLL_" + currentBean.table.originalName + "_URL = \"/" + this.bean.urlPiece + "/{id}/" + currentBean.urlPiece + "/scroll\";");
            this.skipLine();
        }
    }

    private void createLoadOneToManyComponent() {
        for (OneToManyComponent oneToManyComponent : this.bean.oneToManyComponentList) {
            Bean currentBean = oneToManyComponent.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * load one to many component " + currentBean.objectName);
            this.writeLine(" */");
            this.writeLine(currentBean.fullViewBean.className + " load" + currentBean.className + "(Long id);");
            this.writeLine("public static final String GET_" + currentBean.table.originalName + "_URL = \"/" + currentBean.urlPiece + "/{id}\";");
            this.skipLine();
        }
    }

    private void createCreateObject() {
        this.writeLine("/**");
        this.writeLine(" * create object");
        this.writeLine(" */");
        this.writeLine(this.bean.fullViewBean.className + " create();");
        this.writeLine("public static final String GET_NEW_URL = \"/" + this.bean.urlPiece + "/new\";");
        this.skipLine();
    }

    private void createCreateOneToManyComponent() {
        for (OneToManyComponent oneToManyComponent : this.bean.oneToManyComponentList) {
            Bean currentBean = oneToManyComponent.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * create one to many component " + currentBean.objectName);
            this.writeLine(" */");
            this.writeLine(currentBean.fullViewBean.className + " create" + currentBean.className + "(Long id);");
            this.writeLine("public static final String GET_NEW_" + currentBean.table.originalName + "_URL = \"/" + this.bean.urlPiece + "/{id}/" + currentBean.urlPiece + "/new\";");
            this.skipLine();
        }
    }

    private void createSaveObject() {
        this.writeLine("/**");
        this.writeLine(" * save object");
        this.writeLine(" */");
        this.writeLine("Long save(" + this.bean.formBean.className + " " + this.bean.formBean.objectName + ");");
        this.writeLine("public static final String SAVE_URL = \"/" + this.bean.urlPiece + "\";");
        this.skipLine();
        for (Property property : this.bean.properties) {
            if (property.referenceBean == null || !property.relation.equals((Object)RelationType.MANY_TO_ONE)) continue;
            Bean parentBean = property.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * save object from parent " + parentBean.className);
            this.writeLine(" */");
            this.writeLine("Long saveFrom" + parentBean.className + "(Long " + parentBean.objectName + "Id, " + this.bean.formBean.className + " " + this.bean.formBean.objectName + ");");
            this.writeLine("public static final String SAVE_FROM_" + parentBean.table.originalName + "_URL = \"/" + parentBean.urlPiece + "/{" + parentBean.objectName + "Id}/" + this.bean.urlPiece + "\";");
            this.skipLine();
        }
    }

    private void createSaveOneToOneComponent() {
        for (OneToOneComponent oneToOneComponent : this.bean.oneToOneComponentList) {
            Bean currentBean = oneToOneComponent.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * save one to one component " + currentBean.objectName);
            this.writeLine(" */");
            this.writeLine("public void save" + currentBean.className + "(Long id, " + currentBean.formBean.className + " " + currentBean.formBean.objectName + ");");
            this.writeLine("public static final String SAVE_" + currentBean.table.originalName + "_URL = \"/" + this.bean.urlPiece + "/{id}/" + currentBean.urlPiece + "\";");
            this.skipLine();
        }
    }

    private void createSaveOneToManyComponent() {
        for (OneToManyComponent oneToManyComponent : this.bean.oneToManyComponentList) {
            Bean currentBean = oneToManyComponent.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * save one to many component " + currentBean.objectName);
            this.writeLine(" */");
            this.writeLine("void save" + currentBean.className + "(Long id, " + currentBean.formBean.className + " " + currentBean.formBean.objectName + ");");
            this.writeLine("public static final String SAVE_" + currentBean.table.originalName + "_URL = \"/" + this.bean.urlPiece + "/{id}/" + currentBean.urlPiece + "\";");
            this.skipLine();
        }
    }

    private void createUpdateObject() {
        this.writeLine("/**");
        this.writeLine(" * update object");
        this.writeLine(" */");
        this.writeLine("void update(Long id, " + this.bean.formBean.className + " " + this.bean.formBean.objectName + ");");
        this.writeLine("public static final String UPDATE_URL = \"/" + this.bean.urlPiece + "/{id}\";");
        this.skipLine();
    }

    private void createUpdateOneToOneComponent() {
        for (OneToOneComponent oneToOneComponent : this.bean.oneToOneComponentList) {
            Bean currentBean = oneToOneComponent.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * update one to one component " + currentBean.objectName);
            this.writeLine(" */");
            this.writeLine("void update" + currentBean.className + "(Long id, " + currentBean.formBean.className + " " + currentBean.formBean.objectName + ");");
            this.writeLine("public static final String UPDATE_" + currentBean.table.originalName + "_URL = \"/" + this.bean.urlPiece + "/{id}/" + currentBean.urlPiece + "\";");
            this.skipLine();
        }
    }

    private void createUpdateOneToManyComponent() {
        for (OneToManyComponent oneToManyComponent : this.bean.oneToManyComponentList) {
            Bean currentBean = oneToManyComponent.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * update one to many component " + currentBean.objectName);
            this.writeLine(" */");
            this.writeLine("void update" + currentBean.className + "(Long id, " + currentBean.formBean.className + " " + currentBean.formBean.objectName + ");");
            this.writeLine("public static final String UPDATE_" + currentBean.table.originalName + "_URL = \"/" + currentBean.urlPiece + "/{id}\";");
            this.skipLine();
        }
    }

    private void createDeleteObject() {
        this.writeLine("/**");
        this.writeLine(" * delete object");
        this.writeLine(" */");
        this.writeLine("void delete(Long id);");
        this.writeLine("public static final String DELETE_URL = \"/" + this.bean.urlPiece + "/{id}\";");
        this.skipLine();
    }

    private void createDeleteOneToOneComponent() {
        for (OneToOneComponent oneToOneComponent : this.bean.oneToOneComponentList) {
            Bean currentBean = oneToOneComponent.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * delete one to one component " + currentBean.objectName);
            this.writeLine(" */");
            this.writeLine("public void delete" + currentBean.className + "(Long id);");
            this.writeLine("public static final String DELETE_" + currentBean.table.originalName + "_URL = \"/" + this.bean.urlPiece + "/{id}/" + currentBean.urlPiece + "\";");
            this.skipLine();
        }
    }

    private void createDeleteOneToManyComponent() {
        for (OneToManyComponent oneToManyComponent : this.bean.oneToManyComponentList) {
            Bean currentBean = oneToManyComponent.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * delete one to many component " + currentBean.objectName);
            this.writeLine(" */");
            this.writeLine("void delete" + currentBean.className + "(Long id);");
            this.writeLine("public static final String DELETE_" + currentBean.table.originalName + "_URL = \"/" + currentBean.urlPiece + "/{id}\";");
            this.skipLine();
        }
    }

    private void createDeleteObjectList() {
        this.writeLine("/**");
        this.writeLine(" * delete object list");
        this.writeLine(" */");
        this.writeLine("void deleteList(List<Long> idList);");
        this.writeLine("public static final String DELETE_LIST_URL = \"/" + this.bean.urlPiece + "/delete\";");
        this.skipLine();
    }

    private void createDeleteOneToManyComponentList() {
        for (OneToManyComponent oneToManyComponent : this.bean.oneToManyComponentList) {
            Bean currentBean = oneToManyComponent.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * delete one to many component " + currentBean.objectName + " list");
            this.writeLine(" */");
            this.writeLine("void delete" + currentBean.className + "List(List<Long> idList);");
            this.writeLine("public static final String DELETE_" + currentBean.table.originalName + "_LIST_URL = \"/" + currentBean.urlPiece + "/delete\";");
            this.skipLine();
        }
    }
}

