/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.generator.repository.build;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.sklsft.generator.repository.build.Command;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcRawCommand
implements Command {
    private static final Logger logger = LoggerFactory.getLogger(JdbcRawCommand.class);
    private DataSource dataSource;
    private String script;

    public JdbcRawCommand(DataSource dataSource, String script) {
        this.dataSource = dataSource;
        this.script = script;
    }

    @Override
    public void execute() {
        try (Connection connection = this.dataSource.getConnection();
             Statement statement = connection.createStatement();){
            String[] tokens;
            connection.setAutoCommit(true);
            for (String token : tokens = this.script.split("/")) {
                logger.info("executing statement : " + token);
                statement.executeUpdate(token);
            }
        }
        catch (SQLException e) {
            logger.error("statement failed : " + e.getClass().getSimpleName() + " - " + e.getMessage());
        }
    }
}

