/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.generator.repository.backup.reader.impl;

import java.io.IOException;
import java.util.List;
import javax.sql.DataSource;
import org.sklsft.generator.exception.DataSourceNotFoundException;
import org.sklsft.generator.exception.ReadBackupFailureException;
import org.sklsft.generator.model.backup.SourceAndScript;
import org.sklsft.generator.repository.backup.datasource.interfaces.InputDataSourceProvider;
import org.sklsft.generator.repository.backup.reader.impl.SourceAndScriptBackupReader;
import org.sklsft.generator.repository.backup.reader.impl.XmlFileSourceAndScriptSimpleParser;
import org.sklsft.generator.repository.backup.reader.interfaces.BackupArgumentReader;
import org.sklsft.generator.repository.backup.reader.model.BackupArguments;

public class XmlFileBackupReader
implements BackupArgumentReader {
    private InputDataSourceProvider inputSourceProvider;
    private XmlFileSourceAndScriptSimpleParser xmlFileSourceAndScriptParser = new XmlFileSourceAndScriptSimpleParser();
    private SourceAndScriptBackupReader sourceAndScriptBackupReader;

    public XmlFileBackupReader(InputDataSourceProvider inputSourceProvider) {
        this.inputSourceProvider = inputSourceProvider;
    }

    @Override
    public BackupArguments readBackupArgs(String backupFilePath) throws ReadBackupFailureException {
        SourceAndScript sourceAndScript;
        try {
            sourceAndScript = this.xmlFileSourceAndScriptParser.parse(backupFilePath);
        }
        catch (IOException e) {
            throw new ReadBackupFailureException("Failed to read source and script", (Throwable)e);
        }
        BackupArguments result = new BackupArguments();
        result.setArguments(this.readArguments(sourceAndScript));
        result.setArgumentsTyped(true);
        return result;
    }

    private List<Object[]> readArguments(SourceAndScript sourceAndScript) {
        DataSource inputSource;
        try {
            inputSource = this.inputSourceProvider.getDataSource(sourceAndScript.getSource());
        }
        catch (DataSourceNotFoundException e) {
            throw new ReadBackupFailureException("Invalid backup source", (Throwable)e);
        }
        this.sourceAndScriptBackupReader = new SourceAndScriptBackupReader(inputSource);
        return this.sourceAndScriptBackupReader.readBackupArgs(sourceAndScript.getScript());
    }
}

