/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.generator.repository.backup.reader.impl;

import org.sklsft.generator.exception.UnhandledPersistenceModeException;
import org.sklsft.generator.model.metadata.PersistenceMode;
import org.sklsft.generator.repository.backup.datasource.interfaces.InputDataSourceProvider;
import org.sklsft.generator.repository.backup.reader.impl.TextDelimitedFileBackupReader;
import org.sklsft.generator.repository.backup.reader.impl.XmlFileBackupReader;
import org.sklsft.generator.repository.backup.reader.interfaces.BackupArgumentReader;
import org.springframework.stereotype.Component;

@Component
public class BackupArgumentReaderFactory {
    public BackupArgumentReader getBackupArgumentReader(PersistenceMode type, InputDataSourceProvider inputSourceProvider) {
        switch (type) {
            case CSV: {
                return new TextDelimitedFileBackupReader();
            }
            case XML: {
                return new XmlFileBackupReader(inputSourceProvider);
            }
        }
        throw new UnhandledPersistenceModeException("Unhandled persistenceMode " + type + " for reading backup arguments");
    }
}

