/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.generator.repository.backup.file.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.sklsft.generator.exception.InvalidFileException;
import org.sklsft.generator.repository.backup.file.interfaces.CsvFileParser;
import org.sklsft.generator.repository.backup.file.model.CsvFile;

public class CsvFileParserImpl
implements CsvFileParser {
    private Charset charset;
    private String separator;

    public CsvFileParserImpl() {
        this.charset = StandardCharsets.ISO_8859_1;
        this.separator = "\\$";
    }

    public CsvFileParserImpl(Charset charset) {
        this.charset = charset;
        this.separator = "\\$";
    }

    public CsvFileParserImpl(Charset charset, String separator) {
        this.charset = charset;
        this.separator = separator;
    }

    @Override
    public CsvFile readData(String filePath) throws IOException, InvalidFileException {
        Path path = Paths.get(filePath, new String[0]);
        ArrayList<Object[]> tokensList = new ArrayList<Object[]>();
        try (BufferedReader reader = Files.newBufferedReader(path, this.charset);){
            String line = null;
            while (!StringUtils.isEmpty((String)(line = reader.readLine()))) {
                String[] tokens = line.split(this.separator, -1);
                tokensList.add(tokens);
            }
        }
        CsvFile result = new CsvFile();
        result.setData(tokensList);
        return result;
    }
}

