/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.generator.repository.backup.file.impl;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.sklsft.generator.model.domain.database.Table;
import org.sklsft.generator.model.metadata.PersistenceMode;
import org.springframework.stereotype.Component;

@Component
public class BackupFileLocator {
    public PersistenceMode resolvePersistenceModeOrNull(String backupPath, int step, Table table) {
        if (this.existsFileForType(backupPath, step, table, PersistenceMode.CMD)) {
            return PersistenceMode.CMD;
        }
        if (this.existsFileForType(backupPath, step, table, PersistenceMode.XML)) {
            return PersistenceMode.XML;
        }
        if (this.existsFileForType(backupPath, step, table, PersistenceMode.CSV)) {
            return PersistenceMode.CSV;
        }
        return null;
    }

    public String getBackupFilePath(String backupPath, int step, Table table, PersistenceMode mode) {
        return this.getPathPrefix(backupPath, step, table) + mode.getExtension();
    }

    public boolean existsFileForTable(String backupPath, int maxStep, Table table) {
        for (int step = 1; step <= maxStep; ++step) {
            for (PersistenceMode mode : PersistenceMode.values()) {
                if (!this.existsFileForType(backupPath, step, table, mode)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean existsFileForType(String backupPath, int step, Table table, PersistenceMode type) {
        String backupFilePath = this.getBackupFilePath(backupPath, step, table, type);
        Path path = Paths.get(backupFilePath, new String[0]);
        return Files.exists(path, new LinkOption[0]);
    }

    private String getPathPrefix(String backupPath, int step, Table table) {
        return backupPath + File.separator + step + File.separator + table.myPackage.name.toUpperCase().replace(".", File.separator) + File.separator + table.originalName;
    }
}

