/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.generator.repository.backup.command.impl;

import java.io.IOException;
import javax.inject.Inject;
import org.sklsft.generator.exception.InvalidFileException;
import org.sklsft.generator.repository.backup.command.interfaces.BackupCommand;
import org.sklsft.generator.repository.backup.file.interfaces.SimpleScriptFileReader;
import org.sklsft.generator.repository.build.Command;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class BackupCommandRawImpl
implements BackupCommand,
ApplicationContextAware {
    @Inject
    private SimpleScriptFileReader reader;
    private ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Override
    public void execute(String path) {
        try {
            String className = this.reader.readScript(path);
            Class<?> clazz = Class.forName(className);
            ((Command)this.applicationContext.getBean(clazz)).execute();
        }
        catch (IOException | ClassNotFoundException e) {
            throw new InvalidFileException("failed to read raw file at path : " + path, (Throwable)e);
        }
    }
}

