/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.generator.repository.backup.command.impl;

import javax.inject.Inject;
import org.sklsft.generator.model.domain.database.Table;
import org.sklsft.generator.model.metadata.PersistenceMode;
import org.sklsft.generator.repository.backup.command.impl.BackupArgumentsCommandFactory;
import org.sklsft.generator.repository.backup.command.impl.BackupCommandRawImpl;
import org.sklsft.generator.repository.backup.command.impl.BackupCommandWithArgumentsImpl;
import org.sklsft.generator.repository.backup.command.interfaces.BackupArgumentsCommand;
import org.sklsft.generator.repository.backup.command.interfaces.BackupCommand;
import org.sklsft.generator.repository.backup.datasource.interfaces.InputDataSourceProvider;
import org.sklsft.generator.repository.backup.reader.impl.BackupArgumentReaderFactory;
import org.sklsft.generator.repository.backup.reader.interfaces.BackupArgumentReader;
import org.sklsft.generator.util.naming.JavaClassNaming;
import org.springframework.stereotype.Component;

@Component
public class BackupCommandFactory {
    @Inject
    private BackupArgumentReaderFactory readerFactory;
    @Inject
    private BackupArgumentsCommandFactory backupArgumentsCommandFactory;
    @Inject
    private BackupCommandRawImpl backupCommandRawImpl;

    public BackupCommand getBackupCommand(Table table, PersistenceMode mode, InputDataSourceProvider inputDataSourceProvider) {
        switch (mode) {
            case CMD: {
                return this.backupCommandRawImpl;
            }
        }
        return this.getBackupArgumentCommand(table, mode, inputDataSourceProvider);
    }

    private BackupCommand getBackupArgumentCommand(Table table, PersistenceMode mode, InputDataSourceProvider inputDataSourceProvider) {
        BackupArgumentReader argumentReader = this.readerFactory.getBackupArgumentReader(mode, inputDataSourceProvider);
        BackupArgumentsCommand command = this.backupArgumentsCommandFactory.getCommand(JavaClassNaming.getObjectName((String)table.originalName) + "Command");
        return new BackupCommandWithArgumentsImpl(argumentReader, command);
    }
}

