/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.generator.skeletons.rest.layers;

import javax.swing.tree.MutableTreeNode;
import org.sklsft.generator.model.domain.Package;
import org.sklsft.generator.model.domain.Project;
import org.sklsft.generator.model.domain.business.Bean;
import org.sklsft.generator.skeletons.commands.interfaces.FileWriteCommand;
import org.sklsft.generator.skeletons.layers.AbstractLayer;
import org.sklsft.generator.skeletons.rest.commands.SpringRestBaseControllerCommand;
import org.sklsft.generator.skeletons.rest.commands.SpringRestControllerCommand;
import org.sklsft.generator.skeletons.rest.commands.configuration.SpringRestLogbackFileWriteCommand;
import org.sklsft.generator.skeletons.rest.commands.configuration.SpringRestProjectPropertiesFileWriteCommand;
import org.sklsft.generator.skeletons.rest.commands.configuration.SpringRestRootPomFileWriteCommand;
import org.sklsft.generator.skeletons.rest.commands.configuration.SpringRestSpringContextFileWriteCommand;
import org.sklsft.generator.skeletons.rest.commands.configuration.SpringRestWarPomFileWriteCommand;
import org.sklsft.generator.skeletons.rest.commands.configuration.SpringRestWebXmlFileWriteCommand;
import org.sklsft.generator.skeletons.tree.FileWriteCommandTreeNode;

public class SpringRestControllerLayer
extends AbstractLayer {
    public SpringRestControllerLayer() {
        super("Spring REST Controllers");
    }

    public FileWriteCommandTreeNode getResourcesNode(Project project) {
        FileWriteCommandTreeNode resourcesTreeNode = new FileWriteCommandTreeNode();
        return resourcesTreeNode;
    }

    public FileWriteCommandTreeNode getConfigurationNode(Project project) {
        FileWriteCommandTreeNode configurationTreeNode = new FileWriteCommandTreeNode();
        FileWriteCommandTreeNode propertiesTreeNode = new FileWriteCommandTreeNode((FileWriteCommand)new SpringRestProjectPropertiesFileWriteCommand(project));
        configurationTreeNode.add((MutableTreeNode)propertiesTreeNode);
        FileWriteCommandTreeNode logbackTreeNode = new FileWriteCommandTreeNode((FileWriteCommand)new SpringRestLogbackFileWriteCommand(project));
        configurationTreeNode.add((MutableTreeNode)logbackTreeNode);
        FileWriteCommandTreeNode rootPomTreeNode = new FileWriteCommandTreeNode((FileWriteCommand)new SpringRestRootPomFileWriteCommand(project));
        configurationTreeNode.add((MutableTreeNode)rootPomTreeNode);
        FileWriteCommandTreeNode webappPomTreeNode = new FileWriteCommandTreeNode((FileWriteCommand)new SpringRestWarPomFileWriteCommand(project));
        configurationTreeNode.add((MutableTreeNode)webappPomTreeNode);
        FileWriteCommandTreeNode webXmlPomTreeNode = new FileWriteCommandTreeNode((FileWriteCommand)new SpringRestWebXmlFileWriteCommand(project));
        configurationTreeNode.add((MutableTreeNode)webXmlPomTreeNode);
        FileWriteCommandTreeNode springWebappTreeNode = new FileWriteCommandTreeNode((FileWriteCommand)new SpringRestSpringContextFileWriteCommand(project));
        configurationTreeNode.add((MutableTreeNode)springWebappTreeNode);
        return configurationTreeNode;
    }

    public FileWriteCommandTreeNode getGenerationNode(Project project) {
        FileWriteCommandTreeNode controllersLayerTreeNode = new FileWriteCommandTreeNode();
        FileWriteCommandTreeNode baseControllerTreeNode = new FileWriteCommandTreeNode("REST Base Controllers");
        controllersLayerTreeNode.add((MutableTreeNode)baseControllerTreeNode);
        for (Package myPackage : project.model.packages) {
            FileWriteCommandTreeNode packageTreeNode = new FileWriteCommandTreeNode(myPackage.name);
            baseControllerTreeNode.add((MutableTreeNode)packageTreeNode);
            for (Bean bean : myPackage.beans) {
                if (bean.isComponent) continue;
                FileWriteCommandTreeNode beanBaseControllerTreeNode = new FileWriteCommandTreeNode((FileWriteCommand)new SpringRestBaseControllerCommand(bean));
                packageTreeNode.add((MutableTreeNode)beanBaseControllerTreeNode);
            }
        }
        FileWriteCommandTreeNode controllerTreeNode = new FileWriteCommandTreeNode("REST Controllers");
        controllersLayerTreeNode.add((MutableTreeNode)controllerTreeNode);
        for (Package myPackage : project.model.packages) {
            FileWriteCommandTreeNode packageTreeNode = new FileWriteCommandTreeNode(myPackage.name);
            controllerTreeNode.add((MutableTreeNode)packageTreeNode);
            for (Bean bean : myPackage.beans) {
                if (bean.isComponent) continue;
                FileWriteCommandTreeNode beanControllerTreeNode = new FileWriteCommandTreeNode((FileWriteCommand)new SpringRestControllerCommand(bean));
                packageTreeNode.add((MutableTreeNode)beanControllerTreeNode);
            }
        }
        return controllersLayerTreeNode;
    }
}

