/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.generator.skeletons.rest.commands;

import java.io.File;
import java.io.IOException;
import org.sklsft.generator.model.domain.business.Bean;
import org.sklsft.generator.model.domain.business.OneToManyComponent;
import org.sklsft.generator.model.domain.business.OneToOneComponent;
import org.sklsft.generator.model.domain.business.Property;
import org.sklsft.generator.model.domain.ui.ViewProperty;
import org.sklsft.generator.model.metadata.RelationType;
import org.sklsft.generator.model.metadata.SelectionMode;
import org.sklsft.generator.skeletons.commands.impl.typed.JavaFileWriteCommand;

public class SpringRestBaseControllerCommand
extends JavaFileWriteCommand {
    private Bean bean;

    public SpringRestBaseControllerCommand(Bean bean) {
        super(bean.myPackage.model.project.workspaceFolder + File.separator + bean.myPackage.model.project.projectName + "-rest" + File.separator + "src" + File.separator + "main" + File.separator + "java" + File.separator + bean.myPackage.baseRestControllerPackageName.replace(".", File.separator), bean.baseRestControllerClassName);
        this.bean = bean;
    }

    protected void fetchSpecificImports() {
        Bean currentBean;
        this.javaImports.add("import java.util.Date;");
        this.javaImports.add("import java.math.BigDecimal;");
        this.javaImports.add("import java.util.List;");
        this.javaImports.add("import javax.inject.Inject;");
        this.javaImports.add("import org.sklsft.commons.api.model.ScrollForm;");
        this.javaImports.add("import org.sklsft.commons.api.model.ScrollView;");
        this.javaImports.add("import org.sklsft.commons.api.model.SelectItem;");
        this.javaImports.add("import " + this.bean.myPackage.serviceInterfacePackageName + "." + this.bean.serviceInterfaceName + ";");
        this.javaImports.add("import " + this.bean.myPackage.basicViewsPackageName + "." + this.bean.basicViewBean.className + ";");
        this.javaImports.add("import " + this.bean.myPackage.fullViewsPackageName + "." + this.bean.fullViewBean.className + ";");
        this.javaImports.add("import " + this.bean.myPackage.formsPackageName + "." + this.bean.formBean.className + ";");
        this.javaImports.add("import " + this.bean.myPackage.filtersPackageName + "." + this.bean.basicViewBean.filterClassName + ";");
        this.javaImports.add("import " + this.bean.myPackage.sortingsPackageName + "." + this.bean.basicViewBean.sortingClassName + ";");
        for (OneToOneComponent OneToOneComponent2 : this.bean.oneToOneComponentList) {
            currentBean = OneToOneComponent2.referenceBean;
            this.javaImports.add("import " + currentBean.myPackage.fullViewsPackageName + "." + currentBean.fullViewBean.className + ";");
            this.javaImports.add("import " + currentBean.myPackage.formsPackageName + "." + currentBean.formBean.className + ";");
        }
        for (OneToManyComponent oneToManyComponent : this.bean.oneToManyComponentList) {
            currentBean = oneToManyComponent.referenceBean;
            this.javaImports.add("import " + this.bean.myPackage.serviceInterfacePackageName + "." + this.bean.serviceInterfaceName + ";");
            this.javaImports.add("import " + currentBean.myPackage.basicViewsPackageName + "." + currentBean.basicViewBean.className + ";");
            this.javaImports.add("import " + currentBean.myPackage.fullViewsPackageName + "." + currentBean.fullViewBean.className + ";");
            this.javaImports.add("import " + currentBean.myPackage.formsPackageName + "." + currentBean.formBean.className + ";");
            this.javaImports.add("import " + currentBean.myPackage.filtersPackageName + "." + currentBean.basicViewBean.filterClassName + ";");
            this.javaImports.add("import " + currentBean.myPackage.sortingsPackageName + "." + currentBean.basicViewBean.sortingClassName + ";");
        }
        this.javaImports.add("import org.springframework.web.bind.annotation.PathVariable;");
        this.javaImports.add("import org.springframework.web.bind.annotation.RequestBody;");
        this.javaImports.add("import org.springframework.web.bind.annotation.RequestMapping;");
        this.javaImports.add("import org.springframework.web.bind.annotation.RequestMethod;");
        this.javaImports.add("import org.springframework.web.bind.annotation.RequestParam;");
        this.javaImports.add("import org.springframework.web.bind.annotation.ResponseBody;");
    }

    protected void writeContent() throws IOException {
        this.writeLine("package " + this.bean.myPackage.baseRestControllerPackageName + ";");
        this.skipLine();
        this.writeImports();
        this.skipLine();
        this.writeLine("/**");
        this.writeLine(" * auto generated base rest controller file");
        this.writeLine(" * <br/>no modification should be done to this file");
        this.writeLine(" * <br/>processed by skeleton-generator");
        this.writeLine(" */");
        this.writeLine("public class " + this.bean.baseRestControllerClassName + " {");
        this.skipLine();
        this.writeLine("/*");
        this.writeLine(" * services injected by spring");
        this.writeLine(" */");
        this.writeLine("@Inject");
        this.writeLine("protected " + this.bean.serviceInterfaceName + " " + this.bean.serviceObjectName + ";");
        this.skipLine();
        if (this.bean.selectable) {
            this.createGetOptions();
        }
        this.createLoadObjectList();
        this.createScroll();
        this.createLoadObject();
        if (this.bean.cardinality > 0) {
            this.createFindObject();
        }
        this.createLoadOneToOneComponent();
        this.createLoadOneToManyComponentList();
        this.createScrollOneToManyComponent();
        this.createLoadOneToManyComponent();
        this.createCreateObject();
        this.createCreateOneToManyComponent();
        this.createSaveObject();
        this.createSaveOneToOneComponent();
        this.createSaveOneToManyComponent();
        this.createUpdateObject();
        this.createUpdateUniqueComponent();
        this.createUpdateOneToManyComponent();
        this.createDeleteObject();
        this.createDeleteOneToOneComponent();
        this.createDeleteOneToManyComponent();
        this.createDeleteObjectList();
        this.createDeleteOneToManyComponentList();
        this.writeLine("}");
    }

    private void createGetOptions() {
        if (this.bean.selectionBehavior.selectionMode.equals((Object)SelectionMode.DROPDOWN_OPTIONS)) {
            this.writeLine("/**");
            this.writeLine(" * get options");
            this.writeLine(" */");
            this.writeLine("@RequestMapping(value = {" + this.bean.serviceInterfaceName + ".GET_OPTIONS_URL}, method = RequestMethod.GET)");
            this.writeLine("public @ResponseBody List<SelectItem> getOptions() {");
            this.writeLine("return " + this.bean.serviceObjectName + ".getOptions();");
            this.writeLine("}");
            this.skipLine();
        }
        if (this.bean.selectionBehavior.selectionMode.equals((Object)SelectionMode.AUTO_COMPLETE)) {
            this.writeLine("/**");
            this.writeLine(" * search options");
            this.writeLine(" */");
            this.writeLine("@RequestMapping(value = {" + this.bean.serviceInterfaceName + ".SEARCH_OPTIONS_URL }, method = RequestMethod.POST)");
            this.writeLine("public @ResponseBody List<SelectItem> searchOptions(@RequestBody String arg) {");
            this.writeLine("return " + this.bean.serviceObjectName + ".searchOptions(arg);");
            this.writeLine("}");
            this.skipLine();
        }
    }

    private void createLoadObjectList() {
        this.writeLine("/**");
        this.writeLine(" * load object list");
        this.writeLine(" */");
        this.writeLine("@RequestMapping(value = {" + this.bean.serviceInterfaceName + ".GET_LIST_URL}, method = RequestMethod.GET)");
        this.writeLine("public @ResponseBody List<" + this.bean.basicViewBean.className + "> loadList() {");
        this.writeLine("return " + this.bean.serviceObjectName + ".loadList();");
        this.writeLine("}");
        this.skipLine();
        for (Property property : this.bean.properties) {
            if (property.referenceBean == null || !property.relation.equals((Object)RelationType.MANY_TO_ONE)) continue;
            this.writeLine("/**");
            this.writeLine(" * load object list from " + property.name);
            this.writeLine(" */");
            this.writeLine("@RequestMapping(value = {" + this.bean.serviceInterfaceName + ".GET_" + this.bean.table.originalName + "_LIST_fROM_" + property.referenceBean.table.originalName + "_URL}, method = RequestMethod.GET)");
            this.writeLine("public @ResponseBody List<" + this.bean.basicViewBean.className + "> loadListFrom" + property.capName + " (@PathVariable(\"" + property.name + "Id\") Long " + property.name + "Id) {");
            this.writeLine("return " + this.bean.serviceObjectName + ".loadListFrom" + property.capName + "(" + property.name + "Id);");
            this.writeLine("}");
        }
    }

    private void createScroll() {
        this.writeLine("/**");
        this.writeLine(" * scroll object list");
        this.writeLine(" */");
        this.writeLine("@RequestMapping(value = {" + this.bean.serviceInterfaceName + ".SCROLL_URL}, method = RequestMethod.POST)");
        this.writeLine("public @ResponseBody ScrollView<" + this.bean.basicViewBean.className + "> scroll(@RequestBody ScrollForm<" + this.bean.basicViewBean.filterClassName + ", " + this.bean.basicViewBean.sortingClassName + "> form) {");
        this.writeLine("return " + this.bean.serviceObjectName + ".scroll(form);");
        this.writeLine("}");
        this.skipLine();
        for (Property property : this.bean.properties) {
            if (property.referenceBean == null || !property.relation.equals((Object)RelationType.MANY_TO_ONE)) continue;
            this.writeLine("/**");
            this.writeLine(" * scroll object list from " + property.name);
            this.writeLine(" */");
            this.writeLine("@RequestMapping(value = {" + this.bean.serviceInterfaceName + ".SCROLL_" + this.bean.table.originalName + "_fROM_" + property.referenceBean.table.originalName + "_URL}, method = RequestMethod.POST)");
            this.writeLine("public @ResponseBody ScrollView<" + this.bean.basicViewBean.className + "> scrollFrom" + property.capName + " (@PathVariable(\"" + property.name + "Id\") Long " + property.name + "Id, @RequestBody ScrollForm<" + this.bean.basicViewBean.filterClassName + ", " + this.bean.basicViewBean.sortingClassName + "> form) {");
            this.writeLine("return " + this.bean.serviceObjectName + ".scrollFrom" + property.capName + "(" + property.name + "Id, form);");
            this.writeLine("}");
        }
    }

    private void createLoadObject() {
        this.writeLine("/**");
        this.writeLine(" * load object");
        this.writeLine(" */");
        this.writeLine("@RequestMapping(value = {" + this.bean.serviceInterfaceName + ".GET_URL}, method = RequestMethod.GET)");
        this.writeLine("public @ResponseBody " + this.bean.fullViewBean.className + " load(@PathVariable(\"id\") Long id) {");
        this.writeLine("return " + this.bean.serviceObjectName + ".load(id);");
        this.writeLine("}");
    }

    private void createFindObject() {
        boolean start = true;
        this.writeLine("/**");
        this.writeLine(" * find object");
        this.writeLine(" */");
        this.writeLine("@RequestMapping(value = {" + this.bean.serviceInterfaceName + ".FIND_URL}, method = RequestMethod.GET)");
        this.write("@ResponseBody " + this.bean.fullViewBean.className + " find(");
        for (ViewProperty property : this.bean.referenceViewProperties) {
            if (start) {
                start = false;
            } else {
                this.write(", ");
            }
            this.write("@RequestParam(\"" + property.name + "\") " + property.beanDataType + " " + property.name);
        }
        start = true;
        this.writeLine(") {");
        this.write("return " + this.bean.serviceObjectName + ".find(");
        for (ViewProperty property : this.bean.referenceViewProperties) {
            if (start) {
                start = false;
            } else {
                this.write(", ");
            }
            this.write(property.name);
        }
        this.writeLine(");");
        this.writeLine("}");
        this.skipLine();
    }

    private void createLoadOneToOneComponent() {
        for (OneToOneComponent oneToOneComponent : this.bean.oneToOneComponentList) {
            Bean currentBean = oneToOneComponent.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * load one to one component " + currentBean.objectName);
            this.writeLine(" */");
            this.writeLine("@RequestMapping(value = {" + this.bean.serviceInterfaceName + ".GET_" + currentBean.table.originalName + "_URL}, method = RequestMethod.GET)");
            this.writeLine("public @ResponseBody " + currentBean.fullViewBean.className + " load" + currentBean.className + "(@PathVariable(\"id\") Long id) {");
            this.writeLine("return " + this.bean.serviceObjectName + ".load" + currentBean.className + "(id);");
            this.writeLine("}");
            this.skipLine();
        }
    }

    private void createLoadOneToManyComponentList() {
        for (OneToManyComponent oneToManyComponent : this.bean.oneToManyComponentList) {
            Bean currentBean = oneToManyComponent.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * load one to many component " + currentBean.objectName + " list");
            this.writeLine(" */");
            this.writeLine("@RequestMapping(value = {" + this.bean.serviceInterfaceName + ".GET_" + currentBean.table.originalName + "_LIST_URL}, method = RequestMethod.GET)");
            this.writeLine("public @ResponseBody List<" + currentBean.basicViewBean.className + "> load" + currentBean.className + "List(@PathVariable(\"id\") Long id) {");
            this.writeLine("return " + this.bean.serviceObjectName + ".load" + currentBean.className + "List(id);");
            this.writeLine("}");
            this.skipLine();
        }
    }

    private void createScrollOneToManyComponent() {
        for (OneToManyComponent oneToManyComponent : this.bean.oneToManyComponentList) {
            Bean currentBean = oneToManyComponent.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * scroll one to many component " + currentBean.objectName);
            this.writeLine(" */");
            this.writeLine("@RequestMapping(value = {" + this.bean.serviceInterfaceName + ".SCROLL_" + currentBean.table.originalName + "_URL}, method = RequestMethod.POST)");
            this.writeLine("public @ResponseBody ScrollView<" + currentBean.basicViewBean.className + "> scroll" + currentBean.className + " (@PathVariable(\"" + this.bean.objectName + "Id\") Long " + this.bean.objectName + "Id, @RequestBody ScrollForm<" + currentBean.basicViewBean.filterClassName + ", " + currentBean.basicViewBean.sortingClassName + "> form) {");
            this.writeLine("return " + this.bean.serviceObjectName + ".scroll" + currentBean.className + "(" + this.bean.objectName + "Id, form);");
            this.writeLine("}");
            this.skipLine();
        }
    }

    private void createLoadOneToManyComponent() {
        for (OneToManyComponent oneToManyComponent : this.bean.oneToManyComponentList) {
            Bean currentBean = oneToManyComponent.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * load one to many component " + currentBean.objectName);
            this.writeLine(" */");
            this.writeLine("@RequestMapping(value = {" + this.bean.serviceInterfaceName + ".GET_" + currentBean.table.originalName + "_URL}, method = RequestMethod.GET)");
            this.writeLine("public @ResponseBody " + currentBean.fullViewBean.className + " load" + currentBean.className + "(@PathVariable(\"id\") Long id) {");
            this.writeLine("return " + this.bean.serviceObjectName + ".load" + currentBean.className + "(id);");
            this.writeLine("}");
            this.skipLine();
        }
    }

    private void createCreateObject() {
        this.writeLine("/**");
        this.writeLine(" * create object");
        this.writeLine(" */");
        this.writeLine("@RequestMapping(value = {" + this.bean.serviceInterfaceName + ".GET_NEW_URL}, method = RequestMethod.GET)");
        this.writeLine("public @ResponseBody " + this.bean.fullViewBean.className + " create() {");
        this.writeLine("return " + this.bean.serviceObjectName + ".create();");
        this.writeLine("}");
        this.skipLine();
    }

    private void createCreateOneToManyComponent() {
        for (OneToManyComponent oneToManyComponent : this.bean.oneToManyComponentList) {
            Bean currentBean = oneToManyComponent.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * create one to many component " + currentBean.objectName);
            this.writeLine(" */");
            this.writeLine("@RequestMapping(value = {" + this.bean.serviceInterfaceName + ".GET_NEW_" + currentBean.table.originalName + "_URL}, method = RequestMethod.GET)");
            this.writeLine("public @ResponseBody " + currentBean.fullViewBean.className + " create" + currentBean.className + "(@PathVariable(\"id\") Long id) {");
            this.writeLine("return " + this.bean.serviceObjectName + ".create" + currentBean.className + "(id);");
            this.writeLine("}");
            this.skipLine();
        }
    }

    private void createSaveObject() {
        this.writeLine("/**");
        this.writeLine(" * save object");
        this.writeLine(" */");
        this.writeLine("@RequestMapping(value = {" + this.bean.serviceInterfaceName + ".SAVE_URL}, method = RequestMethod.POST)");
        this.writeLine("public @ResponseBody Long save(@RequestBody " + this.bean.formBean.className + " form) {");
        this.writeLine("return " + this.bean.serviceObjectName + ".save(form);");
        this.writeLine("}");
        this.skipLine();
        for (Property property : this.bean.properties) {
            if (property.referenceBean == null || !property.relation.equals((Object)RelationType.MANY_TO_ONE)) continue;
            Bean parentBean = property.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * save object from parent " + parentBean.className);
            this.writeLine(" */");
            this.writeLine("@RequestMapping(value = {" + this.bean.serviceInterfaceName + ".SAVE_FROM_" + parentBean.table.originalName + "_URL}, method = RequestMethod.POST)");
            this.writeLine("public @ResponseBody Long saveFrom" + parentBean.className + "(@PathVariable(\"" + parentBean.objectName + "Id\") Long " + parentBean.objectName + "Id, @RequestBody " + this.bean.formBean.className + " form) {");
            this.writeLine("return " + this.bean.serviceObjectName + ".saveFrom" + parentBean.className + "(" + parentBean.objectName + "Id, form);");
            this.writeLine("}");
            this.skipLine();
        }
    }

    private void createSaveOneToOneComponent() {
        for (OneToOneComponent oneToOneComponent : this.bean.oneToOneComponentList) {
            Bean currentBean = oneToOneComponent.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * save one to one component " + currentBean.objectName);
            this.writeLine(" */");
            this.writeLine("@RequestMapping(value = {" + this.bean.serviceInterfaceName + ".SAVE_" + currentBean.table.originalName + "_URL}, method = RequestMethod.POST)");
            this.writeLine("@ResponseBody public void save" + currentBean.className + "(@PathVariable(\"id\") Long id, @RequestBody " + currentBean.formBean.className + " form) {");
            this.writeLine(this.bean.serviceObjectName + ".save" + currentBean.className + "(id, form);");
            this.writeLine("}");
            this.skipLine();
        }
    }

    private void createSaveOneToManyComponent() {
        for (OneToManyComponent oneToManyComponent : this.bean.oneToManyComponentList) {
            Bean currentBean = oneToManyComponent.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * save one to many component " + currentBean.objectName);
            this.writeLine(" */");
            this.writeLine("@RequestMapping(value = {" + this.bean.serviceInterfaceName + ".SAVE_" + currentBean.table.originalName + "_URL}, method = RequestMethod.POST)");
            this.writeLine("@ResponseBody public void save" + currentBean.className + "(@PathVariable(\"id\") Long id, @RequestBody " + currentBean.formBean.className + " form) {");
            this.writeLine(this.bean.serviceObjectName + ".save" + currentBean.className + "(id, form);");
            this.writeLine("}");
            this.skipLine();
        }
    }

    private void createUpdateObject() {
        this.writeLine("/**");
        this.writeLine(" * update object");
        this.writeLine(" */");
        this.writeLine("@RequestMapping(value = {" + this.bean.serviceInterfaceName + ".UPDATE_URL}, method = RequestMethod.PUT)");
        this.writeLine("public void update(@PathVariable(\"id\") Long id, @RequestBody " + this.bean.formBean.className + " form) {");
        this.writeLine(this.bean.serviceObjectName + ".update(id, form);");
        this.writeLine("}");
        this.skipLine();
    }

    private void createUpdateUniqueComponent() {
        for (OneToOneComponent oneToOneComponent : this.bean.oneToOneComponentList) {
            Bean currentBean = oneToOneComponent.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * update one to one component " + currentBean.objectName);
            this.writeLine(" */");
            this.writeLine("@RequestMapping(value = {" + this.bean.serviceInterfaceName + ".UPDATE_" + currentBean.table.originalName + "_URL}, method = RequestMethod.PUT)");
            this.writeLine("void update" + currentBean.className + "(Long id, " + currentBean.formBean.className + " form) {");
            this.writeLine(this.bean.serviceObjectName + ".update" + currentBean.className + "(id, form);");
            this.writeLine("}");
            this.skipLine();
        }
    }

    private void createUpdateOneToManyComponent() {
        for (OneToManyComponent oneToManyComponent : this.bean.oneToManyComponentList) {
            Bean currentBean = oneToManyComponent.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * update one to many component " + currentBean.objectName);
            this.writeLine(" */");
            this.writeLine("@RequestMapping(value = {" + this.bean.serviceInterfaceName + ".UPDATE_" + currentBean.table.originalName + "_URL}, method = RequestMethod.PUT)");
            this.writeLine("void update" + currentBean.className + "(Long id, " + currentBean.formBean.className + " form) {");
            this.writeLine(this.bean.serviceObjectName + ".update" + currentBean.className + "(id, form);");
            this.writeLine("}");
            this.skipLine();
        }
    }

    private void createDeleteObject() {
        this.writeLine("/**");
        this.writeLine(" * delete object");
        this.writeLine(" */");
        this.writeLine("@RequestMapping(value = {" + this.bean.serviceInterfaceName + ".DELETE_URL}, method = RequestMethod.DELETE)");
        this.writeLine("void delete(@PathVariable(\"id\") Long id) {");
        this.writeLine(this.bean.serviceObjectName + ".delete(id);");
        this.writeLine("}");
        this.skipLine();
    }

    private void createDeleteOneToOneComponent() {
        for (OneToOneComponent oneToOneComponent : this.bean.oneToOneComponentList) {
            Bean currentBean = oneToOneComponent.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * delete one to one component " + currentBean.objectName);
            this.writeLine(" */");
            this.writeLine("@RequestMapping(value = {" + this.bean.serviceInterfaceName + ".DELETE_" + currentBean.table.originalName + "_URL}, method = RequestMethod.DELETE)");
            this.writeLine("public void delete" + currentBean.className + "(@PathVariable(\"id\")Long id) {");
            this.writeLine(this.bean.serviceObjectName + ".delete" + currentBean.className + "(id);");
            this.writeLine("}");
            this.skipLine();
        }
    }

    private void createDeleteOneToManyComponent() {
        for (OneToManyComponent oneToManyComponent : this.bean.oneToManyComponentList) {
            Bean currentBean = oneToManyComponent.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * delete one to many component " + currentBean.objectName);
            this.writeLine(" */");
            this.writeLine("@RequestMapping(value = {" + this.bean.serviceInterfaceName + ".DELETE_" + currentBean.table.originalName + "_URL}, method = RequestMethod.DELETE)");
            this.writeLine("public void delete" + currentBean.className + "(@PathVariable(\"id\")Long id) {");
            this.writeLine(this.bean.serviceObjectName + ".delete" + currentBean.className + "(id);");
            this.writeLine("}");
            this.skipLine();
        }
    }

    private void createDeleteObjectList() {
        this.writeLine("/**");
        this.writeLine(" * delete object list");
        this.writeLine(" */");
        this.writeLine("@RequestMapping(value = {" + this.bean.serviceInterfaceName + ".DELETE_LIST_URL}, method = RequestMethod.POST)");
        this.writeLine("@ResponseBody void deleteList(@RequestBody List<Long> idList) {");
        this.writeLine(this.bean.serviceObjectName + ".deleteList(idList);");
        this.writeLine("}");
        this.skipLine();
    }

    private void createDeleteOneToManyComponentList() {
        for (OneToManyComponent oneToManyComponent : this.bean.oneToManyComponentList) {
            Bean currentBean = oneToManyComponent.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * delete one to many component " + currentBean.objectName + " list");
            this.writeLine(" */");
            this.writeLine("@RequestMapping(value = {" + this.bean.serviceInterfaceName + ".DELETE_" + currentBean.table.originalName + "_LIST_URL}, method = RequestMethod.POST)");
            this.writeLine("@ResponseBody void delete" + currentBean.className + "List(List<Long> idList) {");
            this.writeLine(this.bean.serviceObjectName + ".delete" + currentBean.className + "List(idList);");
            this.writeLine("}");
            this.skipLine();
        }
    }
}

