/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.generator.bc.validation.rules.impl;

import java.util.HashMap;
import org.sklsft.generator.bc.validation.rules.ProjectMetaDataRuleChecker;
import org.sklsft.generator.model.metadata.ColumnMetaData;
import org.sklsft.generator.model.metadata.PackageMetaData;
import org.sklsft.generator.model.metadata.ProjectMetaData;
import org.sklsft.generator.model.metadata.RelationType;
import org.sklsft.generator.model.metadata.TableMetaData;
import org.sklsft.generator.model.metadata.validation.ProjectValidationReport;

public class ZeroCardinalityReferenceTableChecker
implements ProjectMetaDataRuleChecker {
    @Override
    public ProjectValidationReport checkRules(ProjectMetaData project, ProjectValidationReport report) {
        HashMap<String, TableMetaData> tablesMap = new HashMap<String, TableMetaData>();
        for (PackageMetaData packageMetaData : project.getPackages()) {
            if (packageMetaData.getTables() == null) continue;
            for (TableMetaData table : packageMetaData.getTables()) {
                tablesMap.put(table.getName(), table);
            }
        }
        for (PackageMetaData packageMetaData : project.getPackages()) {
            if (packageMetaData.getTables() == null) continue;
            for (TableMetaData table : packageMetaData.getTables()) {
                for (ColumnMetaData column : table.getColumns()) {
                    TableMetaData referenceTable;
                    if (column.getReferenceTableName() == null || (referenceTable = (TableMetaData)tablesMap.get(column.getReferenceTableName())) == null || referenceTable.getCardinality() != 0 || RelationType.EMBEDDED.equals((Object)column.getReferenceTableRelation())) continue;
                    report.addError(table, column, "Reference to a zero cardinality table");
                }
            }
        }
        return report;
    }
}

