/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.generator.bc.validation.rules.impl;

import java.util.HashMap;
import org.sklsft.generator.bc.validation.rules.ProjectMetaDataRuleChecker;
import org.sklsft.generator.model.metadata.PackageMetaData;
import org.sklsft.generator.model.metadata.ProjectMetaData;
import org.sklsft.generator.model.metadata.TableMetaData;
import org.sklsft.generator.model.metadata.validation.ProjectValidationReport;

public class NoDuplicateTableChecker
implements ProjectMetaDataRuleChecker {
    @Override
    public ProjectValidationReport checkRules(ProjectMetaData project, ProjectValidationReport report) {
        HashMap<String, TableMetaData> tablesMap = new HashMap<String, TableMetaData>();
        for (PackageMetaData packageMetaData : project.getAllPackages()) {
            if (packageMetaData.getTables() == null) continue;
            for (TableMetaData table : packageMetaData.getTables()) {
                if (tablesMap.containsKey(table.getName().toLowerCase())) {
                    report.addError(table, null, "Duplicate table");
                }
                tablesMap.put(table.getName().toLowerCase(), table);
            }
        }
        return report;
    }
}

