/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.generator.bc.resolvers;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.ResourceBundle;
import org.sklsft.generator.model.domain.Project;
import org.sklsft.generator.skeletons.database.DatabaseHandler;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.TypeFilter;

public class DatabaseHandlerResolver {
    public static Map<String, DatabaseHandler> handlers = new HashMap<String, DatabaseHandler>();

    public static DatabaseHandler getDatabaseHandler(Project project) {
        return handlers.get(project.getDatabaseEngine());
    }

    static {
        ClassPathScanningCandidateComponentProvider provider = new ClassPathScanningCandidateComponentProvider(false);
        provider.addIncludeFilter((TypeFilter)new AssignableTypeFilter(DatabaseHandler.class));
        String[] packagesToScan = ResourceBundle.getBundle("generator").getString("database.handlers.path").split(",");
        HashSet defs = new HashSet();
        for (String packageToScan : packagesToScan) {
            defs.addAll(provider.findCandidateComponents(packageToScan.trim()));
        }
        for (BeanDefinition def : defs) {
            try {
                DatabaseHandler handler = (DatabaseHandler)Class.forName(def.getBeanClassName()).newInstance();
                handlers.put(handler.getName(), handler);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Invalid DatabaseHandler : " + def.getBeanClassName(), e);
            }
        }
    }
}

