/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.generator.bc.metadata.factory.impl;

import java.util.ArrayList;
import org.sklsft.generator.bc.metadata.factory.interfaces.TableFactory;
import org.sklsft.generator.bc.resolvers.DatabaseHandlerResolver;
import org.sklsft.generator.model.domain.Model;
import org.sklsft.generator.model.domain.Package;
import org.sklsft.generator.model.domain.database.Column;
import org.sklsft.generator.model.domain.database.Table;
import org.sklsft.generator.model.domain.database.UniqueConstraint;
import org.sklsft.generator.model.metadata.ColumnMetaData;
import org.sklsft.generator.model.metadata.RelationType;
import org.sklsft.generator.model.metadata.TableMetaData;
import org.sklsft.generator.model.metadata.UniqueConstraintMetaData;
import org.sklsft.generator.model.metadata.Visibility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class TableFactoryImpl
implements TableFactory {
    private static final Logger logger = LoggerFactory.getLogger(TableFactory.class);

    @Override
    public Table scanTable(TableMetaData tableMetaData, Package myPackage) {
        Table table = new Table();
        table.myPackage = myPackage;
        table.originalName = tableMetaData.getName();
        table.name = DatabaseHandlerResolver.getDatabaseHandler(myPackage.model.project).rename(table.originalName);
        table.cardinality = tableMetaData.getCardinality();
        logger.trace("Table found : " + tableMetaData.getName());
        return table;
    }

    @Override
    public Table fillTable(TableMetaData tableMetaData, Model model) {
        Table table = model.findTable(tableMetaData.getName());
        for (ColumnMetaData columnMetaData : tableMetaData.getColumns()) {
            Column column = new Column();
            column.originalName = columnMetaData.getName();
            column.name = DatabaseHandlerResolver.getDatabaseHandler(model.project).rename(column.originalName);
            column.dataType = columnMetaData.getDataType();
            column.nullable = columnMetaData.getNullable();
            column.relation = columnMetaData.getReferenceTableRelation() != null ? columnMetaData.getReferenceTableRelation() : RelationType.PROPERTY;
            column.deleteCascade = column.relation.equals((Object)RelationType.MANY_TO_ONE_COMPONENT);
            column.referenceTable = model.findTable(columnMetaData.getReferenceTableName());
            column.unique = columnMetaData.getUnique() != false || column.relation.isUnique();
            column.editable = columnMetaData.getEditable();
            column.visibility = columnMetaData.getVisibility() != null ? columnMetaData.getVisibility() : Visibility.VISIBLE;
            column.rendering = columnMetaData.getRendering();
            column.annotations = columnMetaData.getAnnotations();
            table.columns.add(column);
        }
        if (tableMetaData.getUniqueConstraints() != null && !tableMetaData.getUniqueConstraints().isEmpty()) {
            table.uniqueConstraints = new ArrayList();
            for (UniqueConstraintMetaData uniqueConstraintMetaData : tableMetaData.getUniqueConstraints()) {
                UniqueConstraint uniqueConstraint = new UniqueConstraint();
                uniqueConstraint.name = uniqueConstraintMetaData.getName();
                for (String columnName : uniqueConstraintMetaData.getFields()) {
                    uniqueConstraint.columns.add(table.findColumnByName(columnName));
                }
                table.uniqueConstraints.add(uniqueConstraint);
            }
        }
        return table;
    }
}

