/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.generator.bc.metadata.factory.impl;

import java.util.ArrayList;
import java.util.List;
import org.sklsft.generator.bc.metadata.factory.interfaces.ViewPropertiesFactory;
import org.sklsft.generator.model.domain.business.Bean;
import org.sklsft.generator.model.domain.business.OneToMany;
import org.sklsft.generator.model.domain.business.Property;
import org.sklsft.generator.model.domain.ui.ViewProperty;
import org.sklsft.generator.model.metadata.Visibility;
import org.sklsft.generator.util.naming.JavaClassNaming;
import org.springframework.stereotype.Component;

@Component(value="javaViewPropertiesFactory")
public class JavaViewPropertiesFactory
implements ViewPropertiesFactory {
    @Override
    public List<ViewProperty> getViewProperties(Property myProperty) {
        ArrayList<ViewProperty> result = new ArrayList<ViewProperty>();
        if (myProperty.referenceBean == null) {
            ViewProperty viewProperty = new ViewProperty();
            viewProperty.name = myProperty.name;
            viewProperty.capName = myProperty.capName;
            viewProperty.mappingPath = myProperty.getterName + "()";
            viewProperty.beanDataType = myProperty.beanDataType;
            viewProperty.dataType = myProperty.dataType;
            viewProperty.nullable = myProperty.nullable;
            viewProperty.visibility = myProperty.visibility;
            viewProperty.editable = myProperty.editable;
            viewProperty.lastPropertyName = myProperty.name;
            viewProperty.lastColumnName = myProperty.column.name;
            viewProperty.joinedAliasName = "";
            viewProperty.rendering = myProperty.rendering;
            result.add(viewProperty);
        } else {
            int limit = myProperty.embedded ? myProperty.referenceBean.properties.size() : myProperty.referenceBean.cardinality;
            for (int i = 0; i < limit; ++i) {
                Property property = (Property)myProperty.referenceBean.properties.get(i);
                if (property.referenceBean != null) {
                    List<ViewProperty> tempPropertyList = this.getViewProperties(property);
                    for (ViewProperty tempProperty : tempPropertyList) {
                        ViewProperty viewProperty = new ViewProperty();
                        if (myProperty.embedded) {
                            viewProperty.name = tempProperty.name;
                            viewProperty.capName = tempProperty.capName;
                        } else {
                            viewProperty.name = myProperty.name + tempProperty.capName;
                            viewProperty.capName = myProperty.capName + tempProperty.capName;
                        }
                        viewProperty.mappingPath = myProperty.getterName + "()." + tempProperty.mappingPath;
                        viewProperty.beanDataType = tempProperty.beanDataType;
                        viewProperty.dataType = tempProperty.dataType;
                        viewProperty.nullable = myProperty.nullable || tempProperty.nullable;
                        viewProperty.visibility = Visibility.min((Visibility)myProperty.visibility, (Visibility)tempProperty.visibility);
                        viewProperty.editable = myProperty.embedded ? tempProperty.editable : myProperty.editable;
                        viewProperty.lastPropertyName = tempProperty.lastPropertyName;
                        viewProperty.lastColumnName = tempProperty.lastColumnName;
                        viewProperty.joinedAliasName = myProperty.name + JavaClassNaming.getClassNameFromObjectName((String)tempProperty.joinedAliasName);
                        viewProperty.selectableBean = tempProperty.selectableBean;
                        viewProperty.rendering = tempProperty.rendering;
                        result.add(viewProperty);
                    }
                    continue;
                }
                ViewProperty viewProperty = new ViewProperty();
                if (myProperty.embedded) {
                    viewProperty.name = property.name;
                    viewProperty.capName = property.capName;
                } else {
                    viewProperty.name = myProperty.name + property.capName;
                    viewProperty.capName = myProperty.capName + property.capName;
                }
                viewProperty.mappingPath = myProperty.getterName + "()." + property.getterName + "()";
                viewProperty.beanDataType = property.beanDataType;
                viewProperty.dataType = property.dataType;
                viewProperty.nullable = myProperty.nullable || property.nullable;
                viewProperty.visibility = Visibility.min((Visibility)myProperty.visibility, (Visibility)property.visibility);
                viewProperty.editable = myProperty.embedded ? property.editable : myProperty.editable;
                viewProperty.lastPropertyName = property.name;
                viewProperty.lastColumnName = property.column.name;
                viewProperty.joinedAliasName = myProperty.name;
                if (myProperty.referenceBean.selectable) {
                    viewProperty.selectableBean = myProperty.referenceBean;
                }
                viewProperty.rendering = myProperty.referenceBean.cardinality == 1 ? myProperty.rendering : (myProperty.embedded ? property.rendering : myProperty.rendering + "(" + property.rendering + ")");
                result.add(viewProperty);
            }
        }
        return result;
    }

    @Override
    public List<ViewProperty> getReferenceProperties(Bean bean) {
        ArrayList<ViewProperty> result = new ArrayList<ViewProperty>();
        for (int i = 0; i < bean.cardinality; ++i) {
            Property property = (Property)bean.properties.get(i);
            result.addAll(property.viewProperties);
        }
        return result;
    }

    private List<ViewProperty> getViewProperties(Bean bean) {
        return this.getViewPropertiesExcludingField(bean, null);
    }

    private List<ViewProperty> getViewPropertiesExcludingField(Bean bean, String excludedFieldName) {
        ArrayList<ViewProperty> result = new ArrayList<ViewProperty>();
        for (Property property : bean.properties) {
            if (property.relation.isComponentLink() || property.name.equals(excludedFieldName)) continue;
            result.addAll(property.viewProperties);
        }
        return result;
    }

    @Override
    public List<ViewProperty> getBasicViewProperties(Bean bean) {
        ArrayList<ViewProperty> result = new ArrayList<ViewProperty>();
        for (ViewProperty property : this.getViewProperties(bean)) {
            if (!property.visibility.isListVisible()) continue;
            result.add(property);
        }
        return result;
    }

    @Override
    public List<ViewProperty> getFormProperties(Bean bean) {
        ArrayList<ViewProperty> result = new ArrayList<ViewProperty>();
        for (ViewProperty property : this.getViewProperties(bean)) {
            if (!property.visibility.isDetailVisible()) continue;
            result.add(property);
        }
        return result;
    }

    private List<ViewProperty> getVisibleProperties(OneToMany oneToMany) {
        return this.getViewPropertiesExcludingField(oneToMany.referenceBean, oneToMany.referenceProperty.name);
    }

    @Override
    public List<ViewProperty> getBasicViewProperties(OneToMany oneToMany) {
        ArrayList<ViewProperty> result = new ArrayList<ViewProperty>();
        for (ViewProperty property : this.getVisibleProperties(oneToMany)) {
            if (!property.visibility.isListVisible()) continue;
            result.add(property);
        }
        return result;
    }

    @Override
    public List<ViewProperty> getFormProperties(OneToMany oneToMany) {
        ArrayList<ViewProperty> result = new ArrayList<ViewProperty>();
        for (ViewProperty property : this.getVisibleProperties(oneToMany)) {
            if (!property.visibility.isDetailVisible()) continue;
            result.add(property);
        }
        return result;
    }
}

