/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.generator.bc.metadata.factory.impl;

import javax.annotation.Resource;
import org.sklsft.generator.bc.metadata.factory.interfaces.ModelFactory;
import org.sklsft.generator.bc.metadata.factory.interfaces.ProjectFactory;
import org.sklsft.generator.model.domain.Project;
import org.sklsft.generator.model.metadata.ProjectMetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="javaProjectFactory")
public class JavaProjectFactory
implements ProjectFactory {
    private static final Logger logger = LoggerFactory.getLogger(ProjectFactory.class);
    @Resource(name="javaModelFactory")
    private ModelFactory modelFactory;

    @Override
    public Project buildProject(ProjectMetaData projectMetaData) {
        Project project = new Project();
        project.domainName = projectMetaData.getDomainName();
        project.projectName = projectMetaData.getProjectName();
        project.sourceFolder = projectMetaData.getSourceFolder();
        project.workspaceFolder = projectMetaData.getWorkspaceFolder();
        project.skeleton = projectMetaData.getSkeleton();
        project.databaseEngine = projectMetaData.getDatabaseEngine();
        project.databaseName = projectMetaData.getDatabaseName();
        project.databaseDNS = projectMetaData.getDatabaseDNS();
        project.databasePort = projectMetaData.getDatabasePort();
        project.databaseUserName = projectMetaData.getDatabaseUserName();
        project.databasePassword = projectMetaData.getDatabasePassword();
        project.audited = projectMetaData.getAudited();
        logger.trace("start building model");
        project.model = this.modelFactory.buildModel(projectMetaData, project);
        logger.trace("end building model");
        return project;
    }
}

