/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.generator.bc.metadata.factory.impl;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.sklsft.generator.bc.metadata.factory.interfaces.BasicViewBeanFactory;
import org.sklsft.generator.bc.metadata.factory.interfaces.FormBeanFactory;
import org.sklsft.generator.bc.metadata.factory.interfaces.FullViewBeanFactory;
import org.sklsft.generator.bc.metadata.factory.interfaces.ModelFactory;
import org.sklsft.generator.bc.metadata.factory.interfaces.PackageFactory;
import org.sklsft.generator.bc.metadata.factory.interfaces.ProjectFactory;
import org.sklsft.generator.bc.metadata.factory.interfaces.ViewPropertiesFactory;
import org.sklsft.generator.model.domain.Model;
import org.sklsft.generator.model.domain.Package;
import org.sklsft.generator.model.domain.Project;
import org.sklsft.generator.model.domain.business.Bean;
import org.sklsft.generator.model.domain.business.OneToMany;
import org.sklsft.generator.model.domain.business.Property;
import org.sklsft.generator.model.metadata.DetailMode;
import org.sklsft.generator.model.metadata.PackageMetaData;
import org.sklsft.generator.model.metadata.ProjectMetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="javaModelFactory")
public class JavaModelFactory
implements ModelFactory {
    private static final Logger logger = LoggerFactory.getLogger(ProjectFactory.class);
    @Resource(name="javaPackageFactory")
    private PackageFactory packageFactory;
    @Resource(name="javaBasicViewBeanFactory")
    private BasicViewBeanFactory basicViewBeanFactory;
    @Resource(name="javaFullViewBeanFactory")
    private FullViewBeanFactory fullViewBeanFactory;
    @Resource(name="javaFormBeanFactory")
    private FormBeanFactory formBeanFactory;
    @Resource(name="javaViewPropertiesFactory")
    private ViewPropertiesFactory viewPropertiesFactory;

    @Override
    public Model buildModel(ProjectMetaData projectMetaData, Project project) {
        Model model = this.setUpModel(project);
        if (projectMetaData.getPackages() != null) {
            this.scanPackages(projectMetaData, model);
            this.fillPackages(projectMetaData, model);
            this.buildViewProperties(model);
            this.buildViews(model);
        }
        return model;
    }

    private Model setUpModel(Project project) {
        Model model = new Model();
        model.project = project;
        model.apiModelPackageName = project.domainName + "." + project.projectName + ".api.model";
        model.serviceInterfacePackageName = project.domainName + "." + project.projectName + ".api.interfaces";
        model.modelPackageName = project.domainName + "." + project.projectName + ".model";
        model.enversPackageName = project.domainName + "." + project.projectName + ".model.envers";
        model.daoImplPackageName = project.domainName + "." + project.projectName + ".repository.dao.impl";
        model.daoInterfacePackageName = project.domainName + "." + project.projectName + ".repository.dao.interfaces";
        model.mapperPackageName = project.domainName + "." + project.projectName + ".bc.mapper";
        model.stateManagerPackageName = project.domainName + "." + project.projectName + ".bc.statemanager";
        model.rightsManagerPackageName = project.domainName + "." + project.projectName + ".bc.rightsmanager";
        model.processorPackageName = project.domainName + "." + project.projectName + ".bc.processor";
        model.serviceImplPackageName = project.domainName + "." + project.projectName + ".bl.impl";
        model.restControllerPackageName = project.domainName + "." + project.projectName + ".rest.controller";
        model.controllerPackageName = project.domainName + "." + project.projectName + ".mvc.controller";
        model.mvcModelPackageName = project.domainName + "." + project.projectName + ".mvc.model";
        model.mvcFilterPackageName = project.domainName + "." + project.projectName + ".mvc.filter";
        model.commandPackageName = project.domainName + "." + project.projectName + ".populator.command";
        model.builderPackageName = project.domainName + "." + project.projectName + ".populator.builder";
        model.executorPackageName = project.domainName + "." + project.projectName + ".populator.executor";
        model.junitPackageName = project.domainName + "." + project.projectName + ".junit";
        model.junitDataPackageName = model.junitPackageName + ".data";
        model.packages = new ArrayList();
        return model;
    }

    private void scanPackages(ProjectMetaData projectMetaData, Model model) {
        logger.trace("Scanning packages");
        for (PackageMetaData packageMetaData : projectMetaData.getPackages()) {
            List<Package> myPackages = this.packageFactory.scanPackages(packageMetaData, model, null);
            model.packages.addAll(myPackages);
        }
    }

    private void fillPackages(ProjectMetaData projectMetaData, Model model) {
        for (PackageMetaData packageMetaData : projectMetaData.getPackages()) {
            this.packageFactory.fillPackage(packageMetaData, model);
        }
    }

    private void buildViewProperties(Model model) {
        for (Package pack : model.getPackages()) {
            for (Bean bean : pack.beans) {
                for (Property property : bean.properties) {
                    property.viewProperties = this.viewPropertiesFactory.getViewProperties(property);
                }
            }
        }
    }

    private void buildViews(Model model) {
        for (Package pack : model.getPackages()) {
            for (Bean bean : pack.beans) {
                for (Property property : bean.properties) {
                    property.viewProperties = this.viewPropertiesFactory.getViewProperties(property);
                }
                if (bean.detailMode == null) {
                    boolean hasTabsInDetailView = this.hasTabsInDetailView(bean);
                    bean.detailMode = hasTabsInDetailView ? DetailMode.PAGE : DetailMode.MODAL;
                }
                bean.basicViewBean = this.basicViewBeanFactory.getBasicViewBean(bean);
                bean.fullViewBean = this.fullViewBeanFactory.getFullViewBean(bean);
                bean.formBean = this.formBeanFactory.getFormBean(bean);
                bean.referenceViewProperties = this.viewPropertiesFactory.getReferenceProperties(bean);
                for (OneToMany oneToMany : bean.oneToManyList) {
                    oneToMany.basicViewBean = this.basicViewBeanFactory.getBasicViewBean(oneToMany);
                    oneToMany.formBean = this.formBeanFactory.getFormBean(oneToMany);
                }
            }
        }
    }

    private boolean hasTabsInDetailView(Bean bean) {
        return bean.oneToManyComponentList.size() > 0 || bean.oneToManyList.size() > 0 || bean.oneToOneComponentList.size() > 0 || bean.oneToOneList.size() > 0;
    }
}

