/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.generator.bc.checker;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.sklsft.generator.model.backup.check.BackupPlanPreExecutionWarning;
import org.sklsft.generator.model.backup.check.BackupPlanWarningType;
import org.sklsft.generator.model.domain.Package;
import org.sklsft.generator.model.domain.Project;
import org.sklsft.generator.model.domain.database.Table;
import org.sklsft.generator.model.metadata.PersistenceMode;
import org.sklsft.generator.repository.backup.datasource.interfaces.InputDataSourceProvider;
import org.sklsft.generator.repository.backup.file.impl.BackupFileLocator;
import org.sklsft.generator.util.folder.FolderUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class BackupPreExecutionChecker {
    private static final Logger logger = LoggerFactory.getLogger(BackupPreExecutionChecker.class);
    @Inject
    private BackupFileLocator backupLocator;

    public List<BackupPlanPreExecutionWarning> checkPlan(InputDataSourceProvider inputDataSourceProvider, Project project, Set<String> tables, String backupPath) throws IOException {
        ArrayList<BackupPlanPreExecutionWarning> result = new ArrayList<BackupPlanPreExecutionWarning>();
        int maxStep = FolderUtil.resolveMaxStep((String)backupPath);
        for (Package myPackage : project.model.packages) {
            for (Table table : myPackage.tables) {
                if (tables == null || tables.contains(table.originalName)) {
                    logger.info("start pre checking table : " + table.name);
                    BackupPlanPreExecutionWarning noPlanWarning = this.checkTableHasPlan(backupPath, maxStep, table);
                    if (noPlanWarning != null) {
                        result.add(noPlanWarning);
                        continue;
                    }
                    result.addAll(this.checkHardCodedBackup(backupPath, maxStep, table, inputDataSourceProvider));
                    continue;
                }
                logger.info("table : " + table.name + " skipped");
            }
        }
        return result;
    }

    private BackupPlanPreExecutionWarning checkTableHasPlan(String backupPath, int maxStep, Table table) {
        if (!this.tableHasPlan(backupPath, maxStep, table)) {
            return new BackupPlanPreExecutionWarning(BackupPlanWarningType.NO_PLAN, -1, table);
        }
        return null;
    }

    private boolean tableHasPlan(String backupPath, int maxSteps, Table table) {
        return this.backupLocator.existsFileForTable(backupPath, maxSteps, table);
    }

    private List<BackupPlanPreExecutionWarning> checkHardCodedBackup(String backupPath, int maxStep, Table table, InputDataSourceProvider inputDataSourceProvider) throws IOException {
        LinkedList<BackupPlanPreExecutionWarning> result = new LinkedList<BackupPlanPreExecutionWarning>();
        for (int step = 1; step <= maxStep; ++step) {
            result.addAll(this.checkHardCodedBackupForStep(backupPath, step, table, inputDataSourceProvider));
        }
        return result;
    }

    private List<BackupPlanPreExecutionWarning> checkHardCodedBackupForStep(String backupPath, int step, Table table, InputDataSourceProvider inputDataSourceProvider) throws IOException {
        LinkedList<BackupPlanPreExecutionWarning> result = new LinkedList<BackupPlanPreExecutionWarning>();
        PersistenceMode mode = this.backupLocator.resolvePersistenceModeOrNull(backupPath, step, table);
        if (mode != null) {
            switch (mode) {
                case CSV: {
                    result.add(new BackupPlanPreExecutionWarning(BackupPlanWarningType.HARDCODED_VALUES, step, table));
                    break;
                }
            }
        }
        return result;
    }
}

