/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.generator.skeletons.jsf.commands.presentation.primefaces;

import java.io.File;
import java.io.IOException;
import org.sklsft.generator.model.domain.business.Bean;
import org.sklsft.generator.model.domain.ui.ViewProperty;
import org.sklsft.generator.model.metadata.DetailMode;
import org.sklsft.generator.skeletons.jsf.commands.presentation.primefaces.PrimefacesXhtmlFileWriteCommand;

public class PrimefacesListViewFileWriteCommand
extends PrimefacesXhtmlFileWriteCommand {
    private Bean bean;

    public PrimefacesListViewFileWriteCommand(Bean bean) {
        super(bean.myPackage.model.project.workspaceFolder + File.separator + bean.myPackage.model.project.projectName + "-webapp" + File.separator + "src" + File.separator + "main" + File.separator + "webapp" + File.separator + "sections" + File.separator + bean.myPackage.urlPiece + File.separator + bean.urlPiece, "list");
        this.bean = bean;
    }

    protected void writeContent() throws IOException {
        this.writeLine("<ui:composition xmlns=\"http://www.w3.org/1999/xhtml\"");
        this.writeLine("xmlns:ui=\"http://java.sun.com/jsf/facelets\"");
        this.writeLine("xmlns:f = \"http://java.sun.com/jsf/core\"");
        this.writeLine("xmlns:h = \"http://java.sun.com/jsf/html\"");
        this.writeLine("xmlns:p=\"http://primefaces.org/ui\"");
        this.writeLine("xmlns:cc=\"http://java.sun.com/jsf/composite/components\"");
        this.writeLine("xmlns:s=\"http://commons.sklsft.org/ui/components\"");
        this.writeLine("template=\"/templates/template.xhtml\">");
        this.skipLine();
        this.writeLine("<!-- -->");
        this.writeLine("<!-- auto generated jsf file -->");
        this.writeLine("<!-- write modifications between specific code marks -->");
        this.writeLine("<!-- processed by skeleton generator -->");
        this.writeLine("<!-- -->");
        this.skipLine();
        this.writeLine("<f:metadata>");
        this.writeLine("<f:viewAction action=\"#{" + this.bean.listControllerObjectName + ".load}\"/>");
        this.writeLine("</f:metadata>");
        this.writeLine("<ui:define name=\"content\">");
        this.skipLine();
        this.writeLine("<h:form id=\"" + this.bean.objectName + "ListForm\">");
        this.writeLine("<h:panelGroup id=\"" + this.bean.objectName + "PanelGroup\">");
        this.writeLine("<h2>");
        this.writeLine("#{i18n." + this.bean.objectName + "List} (#{" + this.bean.listViewObjectName + ".scrollView.size})");
        this.writeLine("</h2>");
        this.writeLine("<div class=\"filter-panel\">");
        this.writeLine("<h3>");
        this.writeLine("#{i18n.filters}");
        this.writeLine("<p:commandLink action=\"#{" + this.bean.listControllerObjectName + ".reset}\" process=\"@this\" update=\"@form:" + this.bean.objectName + "PanelGroup\">");
        this.writeLine("<h:graphicImage url=\"/resources/images/icons/refresh.png\" styleClass=\"imageIcon\" title=\"#{i18n.resetFilter}\"/>");
        this.writeLine("</p:commandLink>");
        this.writeLine("</h3>");
        this.writeLine("<div class=\"row row-eq-height\">");
        for (ViewProperty property : this.bean.basicViewBean.properties) {
            this.writeLine("<div class=\"col-xs-3\">");
            this.writeFilter(property, this.bean);
            this.writeLine("</div>");
            this.skipLine();
        }
        this.writeLine("</div>");
        this.writeLine("</div>");
        this.writeLine("<div class=\"results-panel\">");
        this.writeLine("<h:panelGroup id=\"resultsPanelGroup\">");
        this.writeLine("<ui:fragment rendered=\"#{" + this.bean.listViewObjectName + ".scrollView.elements.size() == 0}\">");
        this.writeLine("#{i18n.noDataFound}<br/>");
        this.writeLine("</ui:fragment>");
        this.skipLine();
        this.writeLine("<ui:fragment rendered=\"#{" + this.bean.listViewObjectName + ".scrollView.elements.size() > 0}\">");
        this.writeLine("<s:tooltip for=\".truncated-text\"/>");
        this.skipLine();
        this.writeLine("<p:dataTable rows=\"10\"");
        this.writeLine("id=\"" + this.bean.objectName + "List\" var=\"" + this.bean.objectName + "\" name=\"datatable\"");
        this.writeLine("value=\"#{" + this.bean.listViewObjectName + ".scrollView.elements}\" headerClass=\"datatable-header\" rowClasses=\"datatable-row, datatable-row-light\">");
        this.skipLine();
        this.writeLine("<p:column>");
        this.writeLine("<f:facet name=\"header\">");
        this.writeLine("<h:selectBooleanCheckbox id=\"selectUnselectAll\" onclick=\"selectUnselectAll(this)\" value=\"false\"/>");
        this.writeLine("<script>$(function(){displaySelectUnselectAll();});</script>");
        this.writeLine("</f:facet>");
        this.writeLine("<h:selectBooleanCheckbox rendered=\"#{" + this.bean.objectName + ".canDelete}\" id=\"selectUnselect\" value=\"#{" + this.bean.objectName + ".selected}\" onclick=\"selectUnselect('" + this.bean.objectName + "ListForm:" + this.bean.objectName + "List:selectUnselectAll')\"/>");
        this.writeLine("</p:column>");
        this.skipLine();
        this.writeLine("<p:column>");
        this.writeLine("<f:facet name=\"header\">");
        this.writeLine("<h:outputText value=\"Actions\" />");
        this.writeLine("<div class=\"drop-list\" id=\"drop-list\">");
        if (this.bean.deleteEnabled) {
            this.writeLine("<p:commandLink title=\"#{i18n.deleteSelection}\" action=\"#{" + this.bean.listControllerObjectName + ".deleteList}\"");
            this.writeLine("onclick=\"if (!confirm('#{i18n.confirmDeleteSelection}')) return false\" process=\"@form:" + this.bean.objectName + "PanelGroup\" update=\":messages, @form:" + this.bean.objectName + "PanelGroup\">");
            this.writeLine("<span class=\"glyphicon glyphicon-trash\"/>");
            this.writeLine("</p:commandLink>");
        }
        this.writeLine("</div>");
        this.writeLine("</f:facet>");
        this.writeLine("<h:panelGrid styleClass=\"actions-grid\" columns=\"2\">");
        if (this.bean.detailMode.equals((Object)DetailMode.PAGE)) {
            this.writeLine("<h:link outcome=\"/sections/" + this.bean.myPackage.urlPiece + "/" + this.bean.urlPiece + "/details.jsf\">");
            this.writeLine("<h:graphicImage url=\"/resources/images/icons/edit.png\" styleClass=\"imageIcon\" title=\"#{i18n.edit}\"/>");
            this.writeLine("<f:param name=\"id\" value=\"#{" + this.bean.objectName + ".id}\" />");
            this.writeLine("</h:link>");
        } else {
            this.writeLine("<p:commandLink action=\"#{" + this.bean.listControllerObjectName + ".edit" + this.bean.className + "(" + this.bean.objectName + ".id)}\" oncomplete=\"$('#" + this.bean.objectName + "Modal').modal('show')\" process=\"@this\" update=\"@form:" + this.bean.objectName + "DetailPanelGroup\">");
            this.writeLine("<h:graphicImage url=\"/resources/images/icons/edit.png\" styleClass=\"imageIcon\" title=\"#{i18n.edit}\"/>");
            this.writeLine("</p:commandLink>");
        }
        if (this.bean.deleteEnabled) {
            this.writeLine("<p:commandLink rendered=\"#{" + this.bean.objectName + ".canDelete}\" action=\"#{" + this.bean.listControllerObjectName + ".delete(" + this.bean.objectName + ".id)}\"");
            this.writeLine("onclick=\"if (!confirm('#{i18n.confirmDelete}')) return false\" process=\"@this\" update=\":messages, @form:" + this.bean.objectName + "PanelGroup\">");
            this.writeLine("<h:graphicImage url=\"/resources/images/icons/delete.png\" styleClass=\"imageIcon\" title=\"#{i18n.delete}\"/>");
            this.writeLine("</p:commandLink>");
        }
        this.writeLine("</h:panelGrid>");
        this.writeLine("</p:column>");
        this.skipLine();
        for (ViewProperty property : this.bean.basicViewBean.properties) {
            this.writeLine("<p:column>");
            this.writeLine("<f:facet name=\"header\">");
            this.writeLine("<cc:datatableHeader");
            this.writeLine("label=\"#{i18n." + this.bean.objectName + property.capName + "}\"");
            this.writeLine("orderType=\"#{" + this.bean.listViewObjectName + ".scrollForm.sorting." + property.name + "OrderType}\"");
            this.writeLine("action=\"#{" + this.bean.listControllerObjectName + ".refresh}\"");
            this.writeLine("render=\"@form:" + this.bean.objectName + "PanelGroup\"/>");
            this.writeLine("</f:facet>");
            this.writeListComponent(property, this.bean);
            this.writeLine("</p:column>");
            this.skipLine();
        }
        this.writeLine("</p:dataTable>");
        this.skipLine();
        this.writeLine("<cc:datatableScroller");
        this.writeLine("page=\"#{" + this.bean.listViewObjectName + ".scrollForm.page}\"");
        this.writeLine("numberOfPages=\"#{" + this.bean.listViewObjectName + ".scrollView.numberOfPages}\"");
        this.writeLine("action=\"#{" + this.bean.listControllerObjectName + ".refresh}\"");
        this.writeLine("render=\"@form:" + this.bean.objectName + "PanelGroup\"/>");
        this.skipLine();
        this.writeLine("</ui:fragment>");
        this.skipLine();
        this.writeLine("</h:panelGroup>");
        this.skipLine();
        this.writeLine("</div>");
        this.skipLine();
        if (this.bean.createEnabled) {
            this.writeLine("<p:commandButton value=\"#{i18n.create}\" action=\"#{" + this.bean.listControllerObjectName + ".create" + this.bean.className + "}\" styleClass=\"btn btn-info\" oncomplete=\"onSuccess(args, function(){$('#" + this.bean.objectName + "Modal').modal('show')});\" process=\"@this\" update=\"" + this.bean.objectName + "DetailPanelGroup\"/>");
            this.skipLine();
        }
        this.writeNotOverridableContent();
        this.writeLine("</h:panelGroup>");
        this.skipLine();
        this.writeLine("<div class=\"modal modal-default\" id=\"" + this.bean.objectName + "Modal\" tabindex=\"-1\" aria-hidden=\"true\">");
        this.writeLine("<div class=\"modal-dialog modal-lg\">");
        this.writeLine("<div class=\"modal-content\">");
        this.writeLine("<ui:include src=\"/sections/" + this.bean.myPackage.urlPiece + "/" + this.bean.urlPiece + "/modal.xhtml\"/>");
        this.writeLine("</div>");
        this.writeLine("</div>");
        this.writeLine("</div>");
        this.writeLine("</h:form>");
        this.writeLine("</ui:define>");
        this.writeLine("</ui:composition>");
    }
}

