/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.generator.bl.services.impl;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Set;
import javax.inject.Inject;
import org.sklsft.generator.model.domain.Package;
import org.sklsft.generator.model.domain.Project;
import org.sklsft.generator.model.domain.business.Bean;
import org.sklsft.generator.model.metadata.PersistenceMode;
import org.sklsft.generator.repository.backup.command.impl.BackupCommandFactory;
import org.sklsft.generator.repository.backup.command.interfaces.BackupCommand;
import org.sklsft.generator.repository.backup.file.impl.BackupFileLocator;
import org.sklsft.generator.util.folder.FolderUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class JunitPopulator {
    private static final Logger logger = LoggerFactory.getLogger(JunitPopulator.class);
    @Inject
    private BackupCommandFactory commandFactory;
    @Inject
    private BackupFileLocator backupLocator;

    public void populate(Project project, Set<String> packages, String backupPath) {
        logger.info("start populating database");
        int maxSteps = FolderUtil.resolveMaxStep((String)backupPath);
        for (int step = 1; step <= maxSteps; ++step) {
            logger.info("start bulding step " + step);
            for (Package myPackage : project.model.packages) {
                if (packages == null || packages.isEmpty() || packages.contains(myPackage.name)) {
                    logger.info("start populating package : " + myPackage.name);
                    for (Bean bean : myPackage.beans) {
                        if (bean.isEmbedded) continue;
                        logger.info("start populating table : " + bean.table.name);
                        BackupCommand command = this.commandFactory.getBackupCommand(bean.table, PersistenceMode.CSV, null);
                        String path = this.backupLocator.getBackupFilePath(backupPath, step, bean.table, PersistenceMode.CSV);
                        if (Files.exists(Paths.get(path, new String[0]), new LinkOption[0])) {
                            command.execute(path);
                            logger.info("populating table : " + bean.table.name + " completed");
                            continue;
                        }
                        logger.warn("populating table : " + bean.table.name + " : no backup found");
                    }
                    logger.info("populating package " + myPackage.name + " completed");
                    continue;
                }
                logger.info("package : " + myPackage.name + " skipped");
            }
        }
        logger.info("populating database completed");
    }
}

