/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.generator.command;

import org.sklsft.generator.bc.file.executor.FileWriteCommandTree;
import org.sklsft.generator.bl.services.interfaces.CodeGenerator;
import org.sklsft.generator.bl.services.interfaces.ProjectLoader;
import org.sklsft.generator.bl.services.interfaces.ProjectMetaDataService;
import org.sklsft.generator.model.domain.Project;
import org.sklsft.generator.model.metadata.ProjectMetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.FileSystemXmlApplicationContext;

public class CodeGeneratorLauncher {
    private static final Logger logger = LoggerFactory.getLogger(CodeGeneratorLauncher.class);

    public static void main(String[] args) {
        if (args.length < 1) {
            throw new IllegalArgumentException("Path is Mandatory");
        }
        String folderPath = args[0];
        try (FileSystemXmlApplicationContext appContext = new FileSystemXmlApplicationContext("classpath:applicationContext-generator-command.xml");){
            Project project;
            logger.info("Context loaded");
            try {
                logger.info("start loading project");
                ProjectMetaDataService projectMetaDataService = (ProjectMetaDataService)appContext.getBean(ProjectMetaDataService.class);
                ProjectLoader projectLoader = (ProjectLoader)appContext.getBean(ProjectLoader.class);
                ProjectMetaData projectMetaData = projectMetaDataService.loadProjectMetaData(folderPath);
                project = projectLoader.loadProject(projectMetaData);
                logger.info("loading project " + project.projectName + " completed");
            }
            catch (Exception e) {
                logger.error("failed", (Throwable)e);
                if (appContext != null) {
                    if (var3_3 != null) {
                        try {
                            appContext.close();
                        }
                        catch (Throwable x2) {
                            var3_3.addSuppressed(x2);
                        }
                    } else {
                        appContext.close();
                    }
                }
                return;
            }
            try {
                logger.info("start executing code writing");
                CodeGenerator codeGenerator = (CodeGenerator)appContext.getBean(CodeGenerator.class);
                FileWriteCommandTree tree = codeGenerator.buildFileWriteCommandTree(project);
                codeGenerator.generateCode(tree);
                logger.info("executing code writing completed");
            }
            catch (Exception e) {
                logger.error("failed", (Throwable)e);
                if (appContext != null) {
                    if (var3_3 != null) {
                        try {
                            appContext.close();
                        }
                        catch (Throwable x2) {
                            var3_3.addSuppressed(x2);
                        }
                    } else {
                        appContext.close();
                    }
                }
                return;
            }
        }
    }
}

