/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.generator.repository.metadata.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.sklsft.generator.exception.InvalidProjectMetaDataException;
import org.sklsft.generator.exception.ProjectAlreadyConfiguredException;
import org.sklsft.generator.exception.ProjectInitFailureException;
import org.sklsft.generator.exception.ProjectNotFoundException;
import org.sklsft.generator.model.metadata.ProjectMetaData;
import org.sklsft.generator.repository.metadata.interfaces.ProjectMetaDataDao;
import org.springframework.stereotype.Component;
import org.xml.sax.SAXException;

@Component(value="projectMetaDataXmlDao")
public class ProjectMetaDataXMLDaoImpl
implements ProjectMetaDataDao {
    private static final String SCHEMA_LOCATION = "skeleton-metadata-2.0.xsd";

    @Override
    public ProjectMetaData loadProjectMetaData(String workspacePath) {
        String sourcePath = workspacePath + File.separator + "data-model";
        Path parametersPath = Paths.get(sourcePath + File.separator + "skeleton.xml", new String[0]);
        if (!Files.exists(parametersPath, new LinkOption[0])) {
            throw new ProjectNotFoundException("Unable to find project in folder : " + sourcePath);
        }
        File file = parametersPath.toFile();
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ProjectMetaData.class});
            Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = schemaFactory.newSchema(this.getClass().getClassLoader().getResource(SCHEMA_LOCATION));
            jaxbUnmarshaller.setSchema(schema);
            ProjectMetaData projectMetaData = (ProjectMetaData)jaxbUnmarshaller.unmarshal(file);
            projectMetaData.setWorkspaceFolder(workspacePath);
            projectMetaData.setSourceFolder(sourcePath);
            return projectMetaData;
        }
        catch (JAXBException | SAXException e) {
            throw new InvalidProjectMetaDataException("Unable to parse skeleton.xml file", e);
        }
    }

    @Override
    public void persistProjectMetaData(ProjectMetaData projectMetaData) {
        String sourcePath = projectMetaData.getSourceFolder();
        Path parametersPath = Paths.get(sourcePath + File.separator + "skeleton.xml", new String[0]);
        File file = parametersPath.toFile();
        try {
            if (Files.exists(Paths.get(sourcePath + File.separator + SCHEMA_LOCATION, new String[0]), new LinkOption[0])) {
                Files.delete(Paths.get(sourcePath + File.separator + SCHEMA_LOCATION, new String[0]));
            }
            this.copyXsd(sourcePath);
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ProjectMetaData.class});
            Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = schemaFactory.newSchema(this.getClass().getClassLoader().getResource(SCHEMA_LOCATION));
            jaxbMarshaller.setSchema(schema);
            jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)true);
            jaxbMarshaller.setProperty("jaxb.schemaLocation", (Object)"http://generator.sklsft.org/schema/model/metadata skeleton-metadata-2.0.xsd");
            jaxbMarshaller.marshal((Object)projectMetaData, file);
        }
        catch (JAXBException | SAXException e) {
            throw new InvalidProjectMetaDataException("Failed to write skeleton.xml file", e);
        }
        catch (IOException e) {
            throw new InvalidProjectMetaDataException("Failed to write xsd file", (Throwable)e);
        }
    }

    private void copyXsd(String sourcePath) throws IOException {
        try (InputStream inputStream = this.getClass().getResourceAsStream("/skeleton-metadata-2.0.xsd");
             FileOutputStream outputStream = new FileOutputStream(Files.createFile(Paths.get(sourcePath + File.separator + SCHEMA_LOCATION, new String[0]), new FileAttribute[0]).toFile());){
            int read = 0;
            byte[] bytes = new byte[1024];
            while ((read = inputStream.read(bytes)) != -1) {
                ((OutputStream)outputStream).write(bytes, 0, read);
            }
        }
    }

    @Override
    public void initProject(ProjectMetaData projectMetaData) {
        projectMetaData.setSourceFolder(projectMetaData.getWorkspaceFolder() + File.separator + "data-model");
        Path sourcePath = Paths.get(projectMetaData.getSourceFolder(), new String[0]);
        if (Files.exists(sourcePath, new LinkOption[0])) {
            throw new ProjectAlreadyConfiguredException("A project has already been configured at : " + projectMetaData.getWorkspaceFolder());
        }
        try {
            Files.createDirectories(sourcePath, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new ProjectInitFailureException("Failed to initialize project at : " + projectMetaData.getWorkspaceFolder(), (Throwable)e);
        }
    }
}

