/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.generator.repository.backup.datasource.impl;

import java.io.IOException;
import java.nio.file.Paths;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.sklsft.generator.model.backup.PopulateCommandType;
import org.sklsft.generator.model.backup.SourceAndScript;
import org.springframework.stereotype.Component;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Component
public class XmlFileSourceAndScriptSimpleParser {
    public SourceAndScript parse(String scriptFilePath) throws IOException {
        String source = null;
        String script = null;
        PopulateCommandType type = PopulateCommandType.INSERT;
        Document document = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.parse(Paths.get(scriptFilePath, new String[0]).toFile());
            Element element = document.getDocumentElement();
            source = element.getElementsByTagName("source").item(0).getTextContent();
            script = element.getElementsByTagName("script").item(0).getTextContent();
            Node typeElem = element.getElementsByTagName("type").item(0);
            if (typeElem != null) {
                type = PopulateCommandType.valueOf((String)typeElem.getTextContent());
            }
        }
        catch (Exception e) {
            throw new IOException("failed to read xml file : " + scriptFilePath, e);
        }
        SourceAndScript sourceAndScript = new SourceAndScript();
        sourceAndScript.setScript(script);
        sourceAndScript.setSource(source);
        sourceAndScript.setType(type);
        return sourceAndScript;
    }
}

