/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.generator.repository.backup.datasource.impl;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.sklsft.generator.exception.BackupFileNotFoundException;
import org.sklsft.generator.exception.InvalidXmlBackupFileException;
import org.sklsft.generator.model.backup.SourceAndScript;
import org.xml.sax.SAXException;

public class XmlFileSourceAndScriptParser {
    private static final String SCHEMA_LOCATION = "backup-1.0.xsd";

    public SourceAndScript parse(String scriptFilePath) throws IOException {
        Path path = Paths.get(scriptFilePath, new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            throw new BackupFileNotFoundException("Unable to find backup file : " + scriptFilePath);
        }
        File file = path.toFile();
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{SourceAndScript.class});
            Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = schemaFactory.newSchema(this.getClass().getClassLoader().getResource(SCHEMA_LOCATION));
            jaxbUnmarshaller.setSchema(schema);
            SourceAndScript sourceAndScript = (SourceAndScript)jaxbUnmarshaller.unmarshal(file);
            return sourceAndScript;
        }
        catch (JAXBException | SAXException e) {
            throw new InvalidXmlBackupFileException("Unable to parse backup file : " + scriptFilePath, e);
        }
    }
}

