/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.generator.repository.backup.datasource.impl;

import java.io.IOException;
import java.util.List;
import javax.sql.DataSource;
import org.sklsft.generator.exception.DataSourceNotFoundException;
import org.sklsft.generator.exception.ReadBackupFailureException;
import org.sklsft.generator.model.backup.SourceAndScript;
import org.sklsft.generator.repository.backup.datasource.impl.BackupCommandArguments;
import org.sklsft.generator.repository.backup.datasource.impl.SourceAndScriptBackupReader;
import org.sklsft.generator.repository.backup.datasource.impl.XmlFileSourceAndScriptSimpleParser;
import org.sklsft.generator.repository.backup.datasource.interfaces.BackupArgumentReader;
import org.sklsft.generator.repository.backup.datasource.interfaces.InputDataSourceProvider;

public class XmlFileBackupReader
implements BackupArgumentReader {
    private InputDataSourceProvider inputSourceProvider;
    private XmlFileSourceAndScriptSimpleParser xmlFileSourceAndScriptParser = new XmlFileSourceAndScriptSimpleParser();
    private SourceAndScriptBackupReader sourceAndScriptBackupReader;

    public XmlFileBackupReader(InputDataSourceProvider inputSourceProvider) {
        this.inputSourceProvider = inputSourceProvider;
    }

    @Override
    public BackupCommandArguments readBackupArgs(String backupFilePath) throws ReadBackupFailureException {
        SourceAndScript sourceAndScript;
        try {
            sourceAndScript = this.xmlFileSourceAndScriptParser.parse(backupFilePath);
        }
        catch (IOException e) {
            throw new ReadBackupFailureException("Failed to read source and script", (Throwable)e);
        }
        BackupCommandArguments result = new BackupCommandArguments();
        result.setArguments(this.readArguments(sourceAndScript));
        result.setType(sourceAndScript.getType());
        result.setArgumentsTyped(true);
        return result;
    }

    private List<Object[]> readArguments(SourceAndScript sourceAndScript) {
        DataSource inputSource;
        try {
            inputSource = this.inputSourceProvider.getDataSource(sourceAndScript.getSource());
        }
        catch (DataSourceNotFoundException e) {
            throw new ReadBackupFailureException("Invalid backup source", (Throwable)e);
        }
        this.sourceAndScriptBackupReader = new SourceAndScriptBackupReader(inputSource);
        return this.sourceAndScriptBackupReader.readBackupArgs(sourceAndScript.getScript());
    }
}

