/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.generator.repository.backup.datasource.impl;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.sklsft.generator.exception.InvalidFileException;
import org.sklsft.generator.exception.ReadBackupFailureException;
import org.sklsft.generator.model.backup.PopulateCommandType;
import org.sklsft.generator.repository.backup.datasource.impl.BackupCommandArguments;
import org.sklsft.generator.repository.backup.datasource.interfaces.BackupArgumentReader;
import org.sklsft.generator.repository.backup.file.impl.CsvFileParserImpl;
import org.sklsft.generator.repository.backup.file.interfaces.CsvFileParser;
import org.sklsft.generator.repository.backup.file.model.CsvFile;

public class TextDelimitedFileBackupReader
implements BackupArgumentReader {
    private CsvFileParser csvFileParser = new CsvFileParserImpl(StandardCharsets.UTF_8);

    @Override
    public BackupCommandArguments readBackupArgs(String backupFilePath) {
        BackupCommandArguments result = new BackupCommandArguments();
        result.setArguments(this.readArgs(backupFilePath));
        result.setType(this.readType());
        result.setArgumentsTyped(false);
        return result;
    }

    private PopulateCommandType readType() {
        return PopulateCommandType.INSERT;
    }

    private List<Object[]> readArgs(String backupFilePath) {
        try {
            CsvFile csvFile = this.csvFileParser.readData(backupFilePath);
            return csvFile.getData();
        }
        catch (IOException | InvalidFileException e) {
            throw new ReadBackupFailureException("failed to read backup", e);
        }
    }
}

