/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.generator.repository.backup.datasource.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.sklsft.generator.exception.ReadBackupFailureException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public class SourceAndScriptBackupReader {
    private JdbcTemplate jdbcTemplate;

    public SourceAndScriptBackupReader(DataSource dataSource) {
        this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    public List<Object[]> readBackupArgs(String script) throws ReadBackupFailureException {
        return this.jdbcTemplate.query(script, (RowMapper)new BasicRowMapper());
    }

    private class BasicRowMapper
    implements RowMapper<Object[]> {
        private BasicRowMapper() {
        }

        public Object[] mapRow(ResultSet resultSet, int rowNum) throws SQLException {
            ArrayList<Object> objectList = new ArrayList<Object>();
            for (int i = 1; i <= resultSet.getMetaData().getColumnCount(); ++i) {
                objectList.add(resultSet.getObject(i));
            }
            return objectList.toArray();
        }
    }
}

