/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.generator.repository.backup.command;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcRawCommand {
    private static final Logger logger = LoggerFactory.getLogger(JdbcRawCommand.class);
    private DataSource dataSource;
    private String script;

    public JdbcRawCommand(DataSource dataSource, String script) {
        this.dataSource = dataSource;
        this.script = script;
    }

    public void execute() throws SQLException {
        try (Connection connection = this.dataSource.getConnection();){
            String[] tokens;
            connection.setAutoCommit(true);
            Statement statement = connection.createStatement();
            for (String token : tokens = this.script.split("/")) {
                try {
                    logger.info("executing statement : " + token);
                    statement.executeUpdate(token);
                }
                catch (SQLException e) {
                    logger.error("statement failed : " + e.getClass().getSimpleName() + " - " + e.getMessage());
                }
            }
        }
    }
}

