/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.generator.model.metadata;

import javax.xml.bind.annotation.XmlEnum;

@XmlEnum(value=String.class)
public enum DataType {
    TEXT,
    STRING,
    LONG,
    DOUBLE,
    DATETIME,
    BOOLEAN;


    public static String getJavaType(DataType dataType) {
        switch (dataType) {
            case TEXT: {
                return "String";
            }
            case STRING: {
                return "String";
            }
            case LONG: {
                return "Long";
            }
            case DOUBLE: {
                return "Double";
            }
            case DATETIME: {
                return "Date";
            }
            case BOOLEAN: {
                return "Boolean";
            }
        }
        throw new IllegalArgumentException("Unhandled data type " + (Object)((Object)dataType));
    }

    public static String getPostgresqlType(DataType dataType) {
        switch (dataType) {
            case TEXT: {
                return "TEXT";
            }
            case STRING: {
                return "VARCHAR(255)";
            }
            case LONG: {
                return "BIGINT";
            }
            case DOUBLE: {
                return "DOUBLE PRECISION";
            }
            case DATETIME: {
                return "TIMESTAMP WITHOUT TIME ZONE";
            }
            case BOOLEAN: {
                return "BOOLEAN";
            }
        }
        throw new IllegalArgumentException("Unhandled data type " + (Object)((Object)dataType));
    }

    public static String getOracleType(DataType dataType) {
        switch (dataType) {
            case TEXT: {
                return "CLOB";
            }
            case STRING: {
                return "VARCHAR2(255)";
            }
            case LONG: {
                return "NUMBER(19,0)";
            }
            case DOUBLE: {
                return "FLOAT(24)";
            }
            case DATETIME: {
                return "DATE";
            }
            case BOOLEAN: {
                return "NUMBER(1,0)";
            }
        }
        throw new IllegalArgumentException("Unhandled data type " + (Object)((Object)dataType));
    }

    public static String getPlOracleType(DataType dataType) {
        switch (dataType) {
            case TEXT: {
                return "CLOB";
            }
            case STRING: {
                return "VARCHAR2";
            }
            case LONG: {
                return "NUMBER";
            }
            case DOUBLE: {
                return "FLOAT";
            }
            case DATETIME: {
                return "DATE";
            }
            case BOOLEAN: {
                return "NUMBER";
            }
        }
        throw new IllegalArgumentException("Unhandled data type " + (Object)((Object)dataType));
    }

    public static String stringToBuildArg(String value, DataType dataType) {
        switch (dataType) {
            case DATETIME: {
                return "new SimpleDateFormat(\"yyyy-MM-dd\").parse(" + value + ")";
            }
            case DOUBLE: {
                return "Double.valueOf(" + value + ")";
            }
            case LONG: {
                return "Long.valueOf(" + value + ")";
            }
            case BOOLEAN: {
                return "Boolean.valueOf(" + value + ")";
            }
        }
        return value;
    }
}

