/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.generator.model.domain.database;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sklsft.generator.model.domain.Package;
import org.sklsft.generator.model.domain.database.Column;
import org.sklsft.generator.model.domain.database.QualifiedColumn;

public class Table {
    public Package myPackage;
    public String name;
    public String originalName;
    public int cardinality;
    public List<Column> columns;

    public List<Column> getFindColumnList() {
        ArrayList<Column> findColumnList = new ArrayList<Column>();
        List<Object> tempColumnList = new ArrayList();
        for (int i = 1; i <= this.cardinality; ++i) {
            if (this.columns.get((int)i).referenceTable != null) {
                tempColumnList = this.columns.get((int)i).referenceTable.getFindColumnList();
                for (int j = 0; j < tempColumnList.size(); ++j) {
                    Column column = new Column();
                    column.name = this.columns.get((int)i).name.replace("_ID", "_").replace("_id", "_") + ((Column)tempColumnList.get((int)j)).name;
                    column.dataType = ((Column)tempColumnList.get((int)j)).dataType;
                    column.nullable = this.columns.get((int)i).nullable;
                    findColumnList.add(column);
                }
                continue;
            }
            Column column = new Column();
            column.name = this.columns.get((int)i).name;
            column.dataType = this.columns.get((int)i).dataType;
            column.nullable = this.columns.get((int)i).nullable;
            findColumnList.add(column);
        }
        return findColumnList;
    }

    public List<Column> getInsertColumnList() {
        ArrayList<Column> insertColumnList = new ArrayList<Column>();
        List<Object> tempColumnList = new ArrayList();
        for (int i = 1; i < this.columns.size(); ++i) {
            if (this.columns.get((int)i).referenceTable != null) {
                tempColumnList = this.columns.get((int)i).referenceTable.getFindColumnList();
                for (int j = 0; j < tempColumnList.size(); ++j) {
                    Column column = new Column();
                    column.name = this.columns.get((int)i).name.replace("_ID", "_").replace("_id", "_") + ((Column)tempColumnList.get((int)j)).name;
                    column.dataType = ((Column)tempColumnList.get((int)j)).dataType;
                    column.nullable = this.columns.get((int)i).nullable;
                    insertColumnList.add(column);
                }
                continue;
            }
            Column column = new Column();
            column.name = this.columns.get((int)i).name;
            column.dataType = this.columns.get((int)i).dataType;
            column.nullable = this.columns.get((int)i).nullable;
            insertColumnList.add(column);
        }
        return insertColumnList;
    }

    public List<QualifiedColumn> getQualifiedColumns() {
        HashSet<String> tableAliases = new HashSet<String>();
        String alias = this.name;
        tableAliases.add(alias);
        ArrayList<QualifiedColumn> result = new ArrayList<QualifiedColumn>();
        for (int i = 1; i < this.columns.size(); ++i) {
            if (this.columns.get((int)i).referenceTable != null) {
                result.add(this.getReferenceQualifiedColumn(alias, this.columns.get(i), tableAliases));
                continue;
            }
            result.add(new QualifiedColumn(this, alias, this.columns.get(i)));
        }
        return result;
    }

    private QualifiedColumn getReferenceQualifiedColumn(String alias, Column column, Set<String> tableAliases) {
        QualifiedColumn qualifiedColumn = new QualifiedColumn(this, alias, column);
        qualifiedColumn.children = column.referenceTable.getReferenceQualifiedChildren(qualifiedColumn, tableAliases);
        return qualifiedColumn;
    }

    private List<QualifiedColumn> getReferenceQualifiedChildren(QualifiedColumn parent, Set<String> tableAliases) {
        ArrayList<QualifiedColumn> result = new ArrayList<QualifiedColumn>();
        int j = 1;
        while (tableAliases.contains(this.name + j)) {
            ++j;
        }
        String alias = this.name + j;
        tableAliases.add(alias);
        for (int i = 1; i <= this.cardinality; ++i) {
            if (this.columns.get((int)i).referenceTable != null) {
                result.add(this.getReferenceQualifiedColumn(alias, this.columns.get(i), tableAliases));
                continue;
            }
            result.add(new QualifiedColumn(parent, this, alias, this.columns.get(i)));
        }
        return result;
    }
}

