/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.generator.model.domain.business;

import java.util.ArrayList;
import java.util.List;
import org.sklsft.generator.model.domain.Package;
import org.sklsft.generator.model.domain.business.Alias;
import org.sklsft.generator.model.domain.business.OneToMany;
import org.sklsft.generator.model.domain.business.OneToManyComponent;
import org.sklsft.generator.model.domain.business.OneToOne;
import org.sklsft.generator.model.domain.business.OneToOneComponent;
import org.sklsft.generator.model.domain.business.Property;
import org.sklsft.generator.model.domain.database.Table;
import org.sklsft.generator.model.domain.ui.BasicViewBean;
import org.sklsft.generator.model.domain.ui.FullViewBean;
import org.sklsft.generator.model.domain.ui.OptionBean;
import org.sklsft.generator.model.metadata.DetailMode;
import org.sklsft.generator.model.metadata.Visibility;

public class Bean {
    public Table table;
    public Package myPackage;
    public String className;
    public String objectName;
    public String baseDaoClassName;
    public String daoClassName;
    public String baseDaoInterfaceName;
    public String daoInterfaceName;
    public String daoObjectName;
    public String baseServiceClassName;
    public String serviceClassName;
    public String baseServiceInterfaceName;
    public String serviceInterfaceName;
    public String serviceObjectName;
    public String baseStateManagerClassName;
    public String stateManagerClassName;
    public String stateManagerObjectName;
    public String baseProcessorClassName;
    public String processorClassName;
    public String processorObjectName;
    public String baseListControllerClassName;
    public String baseDetailControllerClassName;
    public String listControllerClassName;
    public String listControllerObjectName;
    public String detailControllerClassName;
    public String detailControllerObjectName;
    public String detailViewClassName;
    public String listViewClassName;
    public String detailViewObjectName;
    public String listViewObjectName;
    public int cardinality;
    public String listRendering;
    public String detailRendering;
    public boolean hasComboBox;
    public boolean createEnabled;
    public boolean updateEnabled;
    public boolean deleteEnabled;
    public DetailMode detailMode;
    public List<String> interfaces;
    public List<String> annotations;
    public List<Property> properties = new ArrayList<Property>();
    public List<OneToMany> oneToManyList = new ArrayList<OneToMany>();
    public List<OneToManyComponent> oneToManyComponentList = new ArrayList<OneToManyComponent>();
    public List<OneToOne> oneToOneList = new ArrayList<OneToOne>();
    public List<OneToOneComponent> oneToOneComponentList = new ArrayList<OneToOneComponent>();
    public boolean isComponent = false;
    public boolean isEmbedded = false;
    public boolean isOneToOneComponent = false;
    public BasicViewBean basicViewBean;
    public FullViewBean fullViewBean;
    public OptionBean optionBean;

    public boolean hasTabsInDetailView() {
        return this.oneToManyComponentList.size() > 0 || this.oneToManyList.size() > 0 || this.oneToOneComponentList.size() > 0 || this.oneToOneList.size() > 0;
    }

    public List<Property> getReferenceProperties() {
        ArrayList<Property> findPropertyList = new ArrayList<Property>();
        List<Object> tempPropertyList = new ArrayList();
        int propertiesMaxIndex = this.cardinality > 0 ? this.cardinality : this.properties.size() - 1;
        for (int i = 1; i <= propertiesMaxIndex; ++i) {
            Property currentProperty = this.properties.get(i);
            if (currentProperty.referenceBean != null) {
                tempPropertyList = currentProperty.referenceBean.getReferenceProperties();
                for (Property property : tempPropertyList) {
                    Property property2 = new Property();
                    property2.name = currentProperty.name + property.capName;
                    property2.capName = currentProperty.capName + property.capName;
                    property2.fetchName = currentProperty.fetchName + "." + property.fetchName;
                    property2.beanDataType = property.beanDataType;
                    property2.dataType = property.dataType;
                    property2.format = property.format;
                    property2.nullable = currentProperty.nullable;
                    property2.visibility = currentProperty.visibility;
                    property2.editable = currentProperty.editable;
                    property2.lastPropertyName = property.lastPropertyName;
                    property2.joinedAliasName = currentProperty.capName + property.joinedAliasName;
                    property2.comboBoxBean = property.comboBoxBean;
                    property2.rendering = property.rendering;
                    findPropertyList.add(property2);
                }
                continue;
            }
            Property property = new Property();
            property.name = currentProperty.name;
            property.capName = currentProperty.capName;
            property.fetchName = currentProperty.fetchName;
            property.beanDataType = currentProperty.beanDataType;
            property.dataType = currentProperty.dataType;
            property.format = currentProperty.format;
            property.nullable = currentProperty.nullable;
            property.visibility = currentProperty.visibility;
            property.editable = currentProperty.editable;
            property.lastPropertyName = currentProperty.name;
            property.joinedAliasName = "";
            property.rendering = currentProperty.rendering;
            if (this.hasComboBox) {
                property.comboBoxBean = this;
            }
            findPropertyList.add(property);
        }
        return findPropertyList;
    }

    public List<Property> getVisibleProperties() {
        return this.getVisiblePropertiesExcludingField(null);
    }

    public List<Property> getVisiblePropertiesExcludingField(String excludedFieldName) {
        ArrayList<Property> visiblePropertyList = new ArrayList<Property>();
        for (int i = 1; i < this.properties.size(); ++i) {
            Property currentProperty = this.properties.get(i);
            if (currentProperty.referenceBean != null) {
                if (currentProperty.name.equals(excludedFieldName)) continue;
                if (currentProperty.referenceBean.isEmbedded) {
                    this.addEmbeddedProperties(currentProperty, visiblePropertyList);
                    continue;
                }
                this.addReferenceProperties(currentProperty, visiblePropertyList);
                continue;
            }
            Property property = new Property();
            property.name = currentProperty.name;
            property.capName = currentProperty.capName;
            property.beanDataType = currentProperty.beanDataType;
            property.dataType = currentProperty.dataType;
            property.format = currentProperty.format;
            property.nullable = currentProperty.nullable;
            property.visibility = currentProperty.visibility;
            property.editable = currentProperty.editable;
            property.rendering = currentProperty.rendering;
            visiblePropertyList.add(property);
        }
        return visiblePropertyList;
    }

    private void addReferenceProperties(Property currentProperty, List<Property> visiblePropertyList) {
        List<Property> tempPropertyList = currentProperty.referenceBean.getReferenceProperties();
        for (Property tempProperty : tempPropertyList) {
            Property property = new Property();
            property.name = currentProperty.name + tempProperty.capName;
            property.capName = currentProperty.capName + tempProperty.capName;
            property.beanDataType = tempProperty.beanDataType;
            property.dataType = tempProperty.dataType;
            property.format = tempProperty.format;
            property.nullable = currentProperty.nullable;
            property.visibility = currentProperty.visibility;
            property.editable = currentProperty.editable;
            property.comboBoxBean = tempProperty.comboBoxBean;
            property.rendering = tempProperty.rendering;
            visiblePropertyList.add(property);
        }
    }

    private void addEmbeddedProperties(Property currentProperty, List<Property> visiblePropertyList) {
        List<Property> tempPropertyList = currentProperty.referenceBean.getReferenceProperties();
        for (Property tempProperty : tempPropertyList) {
            Property property = new Property();
            property.name = tempProperty.name;
            property.capName = tempProperty.capName;
            property.beanDataType = tempProperty.beanDataType;
            property.dataType = tempProperty.dataType;
            property.format = tempProperty.format;
            property.nullable = tempProperty.nullable;
            property.visibility = Visibility.min(currentProperty.visibility, tempProperty.visibility);
            property.editable = tempProperty.editable;
            property.comboBoxBean = tempProperty.comboBoxBean;
            property.rendering = tempProperty.rendering;
            visiblePropertyList.add(property);
        }
    }

    public List<Alias> getReferenceAliases() {
        ArrayList<Alias> aliasList = new ArrayList<Alias>();
        List<Object> tempAliasList = new ArrayList();
        for (int i = 1; i <= this.cardinality; ++i) {
            Property currentProperty = this.properties.get(i);
            if (currentProperty.referenceBean == null) continue;
            Alias alias = new Alias();
            alias.propertyName = currentProperty.name;
            alias.name = currentProperty.capName;
            aliasList.add(alias);
            tempAliasList = currentProperty.referenceBean.getReferenceAliases();
            for (int j = 0; j < tempAliasList.size(); ++j) {
                Alias currentAlias = (Alias)tempAliasList.get(j);
                Alias tempAlias = new Alias();
                tempAlias.propertyName = alias.propertyName + "." + currentAlias.propertyName;
                tempAlias.name = alias.name + currentAlias.name;
                aliasList.add(tempAlias);
            }
        }
        return aliasList;
    }

    public List<Property> getBasicViewProperties() {
        ArrayList<Property> result = new ArrayList<Property>();
        for (Property property : this.getVisibleProperties()) {
            if (!property.visibility.isListVisible()) continue;
            result.add(property);
        }
        return result;
    }

    public List<Property> getFullViewProperties() {
        ArrayList<Property> result = new ArrayList<Property>();
        for (Property property : this.getVisibleProperties()) {
            if (!property.visibility.isDetailVisible()) continue;
            result.add(property);
        }
        return result;
    }
}

