/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.generator.model.domain;

import java.util.List;
import org.sklsft.generator.exception.BeanNotFoundException;
import org.sklsft.generator.exception.PackageNotFoundException;
import org.sklsft.generator.exception.TableNotFoundException;
import org.sklsft.generator.model.domain.Package;
import org.sklsft.generator.model.domain.Project;
import org.sklsft.generator.model.domain.business.Bean;
import org.sklsft.generator.model.domain.database.Table;

public class Model {
    public Project project;
    public List<Package> packages;
    public String populationExceptionPackageName;
    public String controllerPackageName;
    public String mvcModelPackageName;
    public String commandPackageName;
    public String commandExecutorPackageName;
    public String filterPackageName;

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public List<Package> getPackages() {
        return this.packages;
    }

    public void setPackages(List<Package> packages) {
        this.packages = packages;
    }

    public String getPopulationExceptionPackageName() {
        return this.populationExceptionPackageName;
    }

    public void setPopulationExceptionPackageName(String populationExceptionPackageName) {
        this.populationExceptionPackageName = populationExceptionPackageName;
    }

    public String getControllerPackageName() {
        return this.controllerPackageName;
    }

    public void setControllerPackageName(String controllerPackageName) {
        this.controllerPackageName = controllerPackageName;
    }

    public String getMvcModelPackageName() {
        return this.mvcModelPackageName;
    }

    public void setMvcModelPackageName(String mvcModelPackageName) {
        this.mvcModelPackageName = mvcModelPackageName;
    }

    public String getCommandPackageName() {
        return this.commandPackageName;
    }

    public void setCommandPackageName(String commandPackageName) {
        this.commandPackageName = commandPackageName;
    }

    public String getCommandExecutorPackageName() {
        return this.commandExecutorPackageName;
    }

    public void setCommandExecutorPackageName(String commandExecutorPackageName) {
        this.commandExecutorPackageName = commandExecutorPackageName;
    }

    public String getFilterPackageName() {
        return this.filterPackageName;
    }

    public void setFilterPackageName(String filterPackageName) {
        this.filterPackageName = filterPackageName;
    }

    public Table findTable(String tableName) {
        if (tableName == null) {
            return null;
        }
        if (tableName.isEmpty()) {
            return null;
        }
        for (Package myPackage : this.packages) {
            for (Table table : myPackage.tables) {
                if (!table.originalName.equals(tableName)) continue;
                return table;
            }
        }
        throw new TableNotFoundException("Invalid table reference : " + tableName);
    }

    public Package findPackage(String packageName) {
        String lowerCaseName = packageName.toLowerCase();
        for (Package packg : this.packages) {
            if (!packg.name.equals(lowerCaseName)) continue;
            return packg;
        }
        throw new PackageNotFoundException(packageName);
    }

    public Bean findBean(String tableOriginalName) {
        for (Package myPackage : this.packages) {
            for (Bean bean : myPackage.beans) {
                if (!bean.table.originalName.equals(tableOriginalName)) continue;
                return bean;
            }
        }
        throw new BeanNotFoundException("invalid table reference : " + tableOriginalName);
    }
}

